/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.tab;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

class SearchText {
    private final int margin;
    private Label label;
    private Text text;
    private Button button;

    SearchText(Composite parent, String labelText, String buttonText, int margin) {
        this.margin = margin;
        this.label = this.createLabel(parent, labelText);
        this.text = this.createText(parent);
        this.button = this.createButton(parent, buttonText);
    }

    void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    String getText() {
        return this.text.getText().trim();
    }

    void setText(String string) {
        this.text.setText(string);
    }

    void addModifyListener(ModifyListener modifyListener) {
        this.text.addModifyListener(modifyListener);
    }

    void removeModifyListener(ModifyListener modifyListener) {
        this.text.removeModifyListener(modifyListener);
    }

    void addSelectionListener(SelectionListener selectionListener) {
        this.button.addSelectionListener(selectionListener);
    }

    void removeSelectionListener(SelectionListener selectionListener) {
        this.button.removeSelectionListener(selectionListener);
    }

    private Label createLabel(Composite parent, String string) {
        Label result = new Label(parent, 0);
        result.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalIndent = this.margin;
        result.setLayoutData((Object)gridData);
        return result;
    }

    private Text createText(Composite parent) {
        Text result = new Text(parent, 2048);
        result.setLayoutData((Object)new GridData(4, 128, true, false));
        return result;
    }

    private Button createButton(Composite parent, String string) {
        Button result = new Button(parent, 8);
        result.setText(string);
        return result;
    }
}

