/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.config;

import java.text.MessageFormat;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.config.ValidationResult;
import org.eclipse.rap.ui.internal.launch.rwt.config.Validator;

class WebXmlLocationValidator
extends Validator {
    static final int ERR_WEB_XML_LOCATION_EMPTY = 8010;
    static final int ERR_WEB_XML_LOCATION_NOT_FOUND = 8011;

    WebXmlLocationValidator(RWTLaunchConfig config, ValidationResult validationResult) {
        super(config, validationResult);
    }

    void validate() {
        if (this.config.getUseWebXml()) {
            String webXmlLocation = this.config.getWebXmlLocation();
            if ("".equals(webXmlLocation)) {
                String msg = "The location for the web.xml is empty.";
                this.addError(msg, 8010);
            } else {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (!root.exists(Path.fromPortableString((String)webXmlLocation))) {
                    String text = "File {0} does not exist.";
                    Object[] args = new Object[]{webXmlLocation};
                    String msg = MessageFormat.format(text, args);
                    this.addError(msg, 8011);
                }
            }
        }
    }
}

