/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import java.io.IOException;
import org.eclipse.rwt.internal.FacadesInitializer;
import org.eclipse.rwt.internal.lifecycle.IDisplayLifeCycleAdapter;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class DisplayLCAFacade {
    private static final DisplayLCAFacade FACADE_IMPL;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.displaykit.DisplayLCAFacade");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FACADE_IMPL = (DisplayLCAFacade)FacadesInitializer.load(clazz);
    }

    public static void registerResources() {
        FACADE_IMPL.registerResourcesInternal();
    }

    public static IDisplayLifeCycleAdapter getDisplayLCA() {
        return FACADE_IMPL.getDisplayLCAInternal();
    }

    public static void writeTestWidgetId(Widget widget, String id) throws IOException {
        FACADE_IMPL.writeTestWidgetIdInternal(widget, id);
    }

    abstract void registerResourcesInternal();

    abstract IDisplayLifeCycleAdapter getDisplayLCAInternal();

    abstract void writeTestWidgetIdInternal(Widget var1, String var2) throws IOException;

    abstract void readBounds(Display var1);

    abstract void readFocusControl(Display var1);

    static void doReadData(Display display) {
        Rectangle oldBounds = display.getBounds();
        FACADE_IMPL.readBounds(display);
        FACADE_IMPL.readFocusControl(display);
        WidgetTreeVisitor.AllWidgetTreeVisitor visitor = new WidgetTreeVisitor.AllWidgetTreeVisitor(){

            public boolean doVisit(Widget widget) {
                AbstractWidgetLCA adapter = WidgetUtil.getLCA(widget);
                adapter.readData(widget);
                return true;
            }
        };
        Shell[] shells = display.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            WidgetTreeVisitor.accept(shell, visitor);
            ++i;
        }
        i = 0;
        while (i < shells.length) {
            if (shells[i].getBounds().equals(oldBounds)) {
                shells[i].setBounds(display.getBounds());
            }
            ++i;
        }
    }

    static void doProcessAction(Device display) {
        ProcessActionRunner.execute();
        TypedEvent.processScheduledEvents();
    }
}

