/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablekit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.CellToolTipUtil;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.tablekit.TableLCAUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class TableLCA
extends AbstractWidgetLCA {
    static final String PROP_HEADER_HEIGHT = "headerHeight";
    static final String PROP_HEADER_VISIBLE = "headerVisible";
    static final String PROP_LINES_VISIBLE = "linesVisible";
    static final String PROP_ITEM_HEIGHT = "itemHeight";
    static final String PROP_TOP_INDEX = "topIndex";
    static final String PROP_SELECTION_LISTENERS = "selectionListeners";
    static final String PROP_DEFAULT_COLUMN_WIDTH = "defaultColumnWidth";
    static final String PROP_ITEM_COUNT = "itemCount";
    static final String PROP_ALWAYS_HIDE_SELECTION = "alwaysHideSelection";
    static final String PROP_HAS_H_SCROLL_BAR = "hasHScrollBar";
    static final String PROP_HAS_V_SCROLL_BAR = "hasVScrollBar";
    static final String PROP_LEFT_OFFSET = "leftOffset";
    static final String PROP_SCROLLBARS_SELECTION_LISTENER = "scrollBarsSelectionListeners";
    static final String PROP_ENABLE_CELL_TOOLTIP = "enableCellToolTip";
    private static final Integer DEFAULT_TOP_INDEX = new Integer(0);
    private static final Integer DEFAULT_ITEM_COUNT = new Integer(0);
    private static final Integer DEFAUT_ITEM_HEIGHT = new Integer(0);
    private static final Integer DEFAULT_COLUMN_WIDTH = new Integer(0);
    private static final Integer DEFAULT_LEFT_OFFSET = new Integer(0);
    private static final JSListenerInfo SELECTION_LISTENER = new JSListenerInfo("itemselected", "this.onItemSelected", JSListenerType.ACTION);
    private static final JSListenerInfo DEFAULT_SELECTION_LISTENER = new JSListenerInfo("itemdefaultselected", "this.onItemDefaultSelected", JSListenerType.ACTION);
    private static final JSListenerInfo CHECK_SELECTION_LISTENER = new JSListenerInfo("itemchecked", "this.onItemChecked", JSListenerType.ACTION);
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        Table table = (Table)widget;
        ControlLCAUtil.preserveValues((Control)table);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)table);
        adapter.preserve(PROP_HEADER_HEIGHT, (Object)new Integer(table.getHeaderHeight()));
        adapter.preserve(PROP_HEADER_VISIBLE, (Object)table.getHeaderVisible());
        adapter.preserve(PROP_LINES_VISIBLE, (Object)table.getLinesVisible());
        adapter.preserve(PROP_ITEM_HEIGHT, (Object)new Integer(table.getItemHeight()));
        TableLCAUtil.preserveItemMetrics(table);
        adapter.preserve(PROP_ITEM_COUNT, (Object)new Integer(table.getItemCount()));
        adapter.preserve(PROP_TOP_INDEX, (Object)new Integer(table.getTopIndex()));
        adapter.preserve(PROP_SELECTION_LISTENERS, (Object)SelectionEvent.hasListener((Adaptable)table));
        adapter.preserve(PROP_DEFAULT_COLUMN_WIDTH, (Object)new Integer(TableLCA.getDefaultColumnWidth(table)));
        TableLCAUtil.preserveFocusIndex(table);
        WidgetLCAUtil.preserveCustomVariant((Widget)table);
        adapter.preserve(PROP_ALWAYS_HIDE_SELECTION, (Object)TableLCA.alwaysHideSelection(table));
        adapter.preserve(PROP_HAS_H_SCROLL_BAR, (Object)TableLCA.hasHScrollBar(table));
        adapter.preserve(PROP_HAS_V_SCROLL_BAR, (Object)TableLCA.hasVScrollBar(table));
        adapter.preserve(PROP_LEFT_OFFSET, (Object)TableLCA.getLeftOffset(table));
        adapter.preserve(PROP_SCROLLBARS_SELECTION_LISTENER, (Object)TableLCA.hasScrollBarsSelectionListener(table));
        adapter.preserve(PROP_ENABLE_CELL_TOOLTIP, (Object)new Boolean(CellToolTipUtil.isEnabledFor((Widget)table)));
    }

    public void readData(Widget widget) {
        Table table = (Table)widget;
        TableLCA.readTopIndex(table);
        TableLCA.readLeftOffset(table);
        TableLCA.readSelection(table);
        TableLCA.readFocusIndex(table);
        TableLCA.readSetData(table);
        TableLCA.readWidgetSelected(table);
        TableLCA.readWidgetDefaultSelected(table);
        TableLCA.readCellToolTipTextRequested(table);
        ControlLCAUtil.processMouseEvents((Control)table);
        ControlLCAUtil.processKeyEvents((Control)table);
        ControlLCAUtil.processMenuDetect((Control)table);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Table table = (Table)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        String style = "";
        if ((table.getStyle() & 0x20) != 0) {
            style = "check";
        }
        if ((table.getStyle() & 2) != 0) {
            style = String.valueOf(style) + "|multi";
        }
        if ((table.getStyle() & 0x8000) != 0) {
            style = String.valueOf(style) + "|hideSelection";
        }
        if ((table.getStyle() & 0x10) != 0) {
            style = String.valueOf(style) + "|noScroll";
        }
        Object[] args = new Object[]{WidgetUtil.getId((Widget)table), style};
        writer.newWidget("org.eclipse.swt.widgets.Table", args);
        ControlLCAUtil.writeStyleFlags((Control)table);
        writer.set("borderWidth", table.getBorderWidth());
    }

    public void renderChanges(Widget widget) throws IOException {
        Table table = (Table)widget;
        TableLCA.writeItemCount(table);
        ControlLCAUtil.writeChanges((Control)table);
        TableLCA.writeHeaderHeight(table);
        TableLCA.writeHeaderVisible(table);
        TableLCA.writeItemHeight(table);
        TableLCAUtil.writeItemMetrics(table);
        TableLCA.writeTopIndex(table);
        TableLCA.writeFocusIndex(table);
        TableLCA.writeLinesVisible(table);
        TableLCA.writeSelectionListener(table);
        TableLCA.writeScrollBarsSelectionListener(table);
        TableLCA.writeDefaultColumnWidth(table);
        TableLCA.writeAlwaysHideSelection(table);
        TableLCA.writeScrollBarsVisible(table);
        TableLCA.writeLeftOffset(table);
        TableLCA.writeEnableCellToolTip(table);
        TableLCA.writeCellToolTipText(table);
        WidgetLCAUtil.writeCustomVariant((Widget)table);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void doRedrawFake(Control control) {
        Table table = (Table)control;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = table.getAdapter((Class)clazz);
        ITableAdapter tableAdapter = (ITableAdapter)adapter;
        tableAdapter.checkData();
    }

    private static void readSelection(Table table) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)table, "selection");
        if (value != null) {
            int[] newSelection;
            if ("".equals(value)) {
                newSelection = new int[]{};
            } else {
                String[] selectedIndices = value.split(",");
                newSelection = new int[selectedIndices.length];
                int i = 0;
                while (i < selectedIndices.length) {
                    newSelection[i] = NumberFormatUtil.parseInt((String)selectedIndices[i]);
                    ++i;
                }
            }
            table.deselectAll();
            table.select(newSelection);
        }
    }

    private static void readTopIndex(Table table) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)table, PROP_TOP_INDEX);
        if (value != null) {
            int topIndex = NumberFormatUtil.parseInt((String)value);
            int topOffset = topIndex * table.getItemHeight();
            table.setTopIndex(topIndex);
            TableLCA.processScrollBarSelection(table.getVerticalBar(), topOffset);
        }
    }

    private static void readFocusIndex(Table table) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)table, "focusIndex");
        if (value != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ITableAdapter adapter = (ITableAdapter)table.getAdapter((Class)clazz);
            adapter.setFocusIndex(NumberFormatUtil.parseInt((String)value));
        }
    }

    private static void readLeftOffset(Table table) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)table, PROP_LEFT_OFFSET);
        if (value != null) {
            int leftOffset = NumberFormatUtil.parseInt((String)value);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = table.getAdapter((Class)clazz);
            ITableAdapter tableAdapter = (ITableAdapter)adapter;
            tableAdapter.setLeftOffset(leftOffset);
            TableLCA.processScrollBarSelection(table.getHorizontalBar(), leftOffset);
        }
    }

    private static void readSetData(Table table) {
        if (WidgetLCAUtil.wasEventSent((Widget)table, "org.eclipse.swt.events.setData")) {
            HttpServletRequest request = ContextProvider.getRequest();
            String value = request.getParameter("org.eclipse.swt.events.setData.index");
            String[] indices = value.split(",");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = table.getAdapter((Class)clazz);
            ITableAdapter tableAdapter = (ITableAdapter)adapter;
            int i = 0;
            while (i < indices.length) {
                int index = NumberFormatUtil.parseInt((String)indices[i]);
                if (index > -1 && index < table.getItemCount()) {
                    tableAdapter.checkData(index);
                }
                ++i;
            }
        }
    }

    private static void readWidgetSelected(Table table) {
        int index;
        if (WidgetLCAUtil.wasEventSent((Widget)table, "org.eclipse.swt.events.widgetSelected") && (index = TableLCA.getWidgetSelectedIndex()) > -1 && index < table.getItemCount()) {
            TableItem item = table.getItem(index);
            int detail = TableLCA.getWidgetSelectedDetail();
            int id = 13;
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            SelectionEvent event = new SelectionEvent((Widget)table, (Widget)item, id, bounds, stateMask, "", true, detail);
            event.processEvent();
        }
    }

    private static void readWidgetDefaultSelected(Table table) {
        String defaultSelectedParam = "org.eclipse.swt.events.widgetDefaultSelected";
        if (WidgetLCAUtil.wasEventSent((Widget)table, defaultSelectedParam)) {
            TableItem item = TableLCA.getFocusedItem(table);
            int selectedIndex = TableLCA.getWidgetSelectedIndex();
            if (selectedIndex != -1) {
                item = table.getItem(selectedIndex);
            }
            int id = 14;
            SelectionEvent event = new SelectionEvent((Widget)table, (Widget)item, id);
            event.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            event.processEvent();
        }
    }

    private static int getWidgetSelectedDetail() {
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter("org.eclipse.swt.events.widgetSelected.detail");
        return "check".equals(value) ? 32 : 0;
    }

    private static int getWidgetSelectedIndex() {
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter("org.eclipse.swt.events.widgetSelected.index");
        return NumberFormatUtil.parseInt((String)value);
    }

    private static TableItem getFocusedItem(Table table) {
        ITableAdapter tableAdapter;
        int focusIndex;
        TableItem result = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((focusIndex = (tableAdapter = (ITableAdapter)table.getAdapter((Class)clazz)).getFocusIndex()) != -1) {
            result = table.getItem(focusIndex);
        }
        return result;
    }

    private static void writeHeaderHeight(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Integer newValue = new Integer(table.getHeaderHeight());
        writer.set(PROP_HEADER_HEIGHT, PROP_HEADER_HEIGHT, newValue, null);
    }

    private static void writeHeaderVisible(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Boolean newValue = table.getHeaderVisible();
        writer.set(PROP_HEADER_VISIBLE, PROP_HEADER_VISIBLE, newValue, null);
    }

    private static void writeItemHeight(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Integer newValue = new Integer(table.getItemHeight());
        writer.set(PROP_ITEM_HEIGHT, PROP_ITEM_HEIGHT, newValue, DEFAUT_ITEM_HEIGHT);
    }

    private static void writeItemCount(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Integer newValue = new Integer(table.getItemCount());
        writer.set(PROP_ITEM_COUNT, PROP_ITEM_COUNT, newValue, DEFAULT_ITEM_COUNT);
    }

    private static void writeTopIndex(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Integer newValue = new Integer(table.getTopIndex());
        writer.set(PROP_TOP_INDEX, PROP_TOP_INDEX, newValue, DEFAULT_TOP_INDEX);
    }

    private static void writeFocusIndex(Table table) throws IOException {
        if (TableLCAUtil.hasFocusIndexChanged(table)) {
            ITableAdapter adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ITableAdapter)table.getAdapter((Class)clazz)).getFocusIndex() == -1) {
                JSWriter writer = JSWriter.getWriterFor((Widget)table);
                writer.set("focusIndex", new Object[]{new Integer(-1)});
            }
        }
    }

    private static void writeLinesVisible(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Boolean newValue = table.getLinesVisible();
        writer.set(PROP_LINES_VISIBLE, PROP_LINES_VISIBLE, newValue, Boolean.FALSE);
    }

    private static void writeSelectionListener(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        writer.updateListener(SELECTION_LISTENER, PROP_SELECTION_LISTENERS, SelectionEvent.hasListener((Adaptable)table));
        writer.updateListener(DEFAULT_SELECTION_LISTENER, PROP_SELECTION_LISTENERS, SelectionEvent.hasListener((Adaptable)table));
        if ((table.getStyle() & 0x20) != 0) {
            writer.updateListener(CHECK_SELECTION_LISTENER, PROP_SELECTION_LISTENERS, SelectionEvent.hasListener((Adaptable)table));
        }
    }

    private static void writeScrollBarsSelectionListener(Table table) throws IOException {
        String prop = PROP_SCROLLBARS_SELECTION_LISTENER;
        Boolean newValue = TableLCA.hasScrollBarsSelectionListener(table);
        if (WidgetLCAUtil.hasChanged((Widget)table, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)table);
            writer.set("hasScrollBarsSelectionListener", newValue);
        }
    }

    private static void writeDefaultColumnWidth(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        String prop = PROP_DEFAULT_COLUMN_WIDTH;
        Integer newValue = new Integer(TableLCA.getDefaultColumnWidth(table));
        Integer defValue = DEFAULT_COLUMN_WIDTH;
        writer.set(prop, PROP_DEFAULT_COLUMN_WIDTH, newValue, defValue);
    }

    private static void writeAlwaysHideSelection(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Boolean newValue = TableLCA.alwaysHideSelection(table);
        Boolean defValue = Boolean.FALSE;
        String prop = PROP_ALWAYS_HIDE_SELECTION;
        writer.set(prop, PROP_ALWAYS_HIDE_SELECTION, newValue, defValue);
    }

    private static void writeScrollBarsVisible(Table table) throws IOException {
        boolean hasHChanged = WidgetLCAUtil.hasChanged((Widget)table, PROP_HAS_H_SCROLL_BAR, TableLCA.hasHScrollBar(table), Boolean.TRUE);
        boolean hasVChanged = WidgetLCAUtil.hasChanged((Widget)table, PROP_HAS_V_SCROLL_BAR, TableLCA.hasVScrollBar(table), Boolean.TRUE);
        if (hasHChanged || hasVChanged) {
            JSWriter writer = JSWriter.getWriterFor((Widget)table);
            Object[] args = new Object[]{TableLCA.hasHScrollBar(table), TableLCA.hasVScrollBar(table)};
            writer.call("setScrollBarsVisibile", args);
        }
    }

    private static void writeLeftOffset(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Integer newValue = TableLCA.getLeftOffset(table);
        writer.set(PROP_LEFT_OFFSET, PROP_LEFT_OFFSET, newValue, DEFAULT_LEFT_OFFSET);
    }

    private static void writeEnableCellToolTip(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        String prop = PROP_ENABLE_CELL_TOOLTIP;
        Boolean newValue = new Boolean(CellToolTipUtil.isEnabledFor((Widget)table));
        writer.set(prop, PROP_ENABLE_CELL_TOOLTIP, newValue, Boolean.FALSE);
    }

    private static void readCellToolTipTextRequested(Table table) {
        ICellToolTipProvider provider;
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter((Widget)table);
        adapter.setToolTipText(null);
        String event = "org.eclipse.swt.events.cellToolTipTextRequested";
        if (WidgetLCAUtil.wasEventSent((Widget)table, event) && (provider = adapter.getCellToolTipProvider()) != null) {
            HttpServletRequest request = ContextProvider.getRequest();
            String cell = request.getParameter("org.eclipse.swt.events.cellToolTipTextRequested.cell");
            String[] details = cell.split(",");
            String itemId = details[0];
            int columnIndex = NumberFormatUtil.parseInt((String)details[1]);
            TableItem item = (TableItem)WidgetUtil.find((Composite)table, (String)itemId);
            if (item != null && (columnIndex == 0 || columnIndex < table.getColumnCount())) {
                provider.getToolTipText((Item)item, columnIndex);
            }
        }
    }

    private static void writeCellToolTipText(Table table) throws IOException {
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter((Widget)table);
        String text = adapter.getToolTipText();
        if (text != null) {
            JSWriter writer = JSWriter.getWriterFor((Widget)table);
            text = WidgetLCAUtil.escapeText(text, false);
            text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            writer.call("setCellToolTipText", new String[]{text});
        }
    }

    private static Boolean hasHScrollBar(Table table) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = table.getAdapter((Class)clazz);
        ITableAdapter tableAdapter = (ITableAdapter)adapter;
        return tableAdapter.hasHScrollBar();
    }

    private static Boolean hasVScrollBar(Table table) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = table.getAdapter((Class)clazz);
        ITableAdapter tableAdapter = (ITableAdapter)adapter;
        return tableAdapter.hasVScrollBar();
    }

    private static Integer getLeftOffset(Table table) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = table.getAdapter((Class)clazz);
        ITableAdapter tableAdapter = (ITableAdapter)adapter;
        return new Integer(tableAdapter.getLeftOffset());
    }

    private static Boolean hasScrollBarsSelectionListener(Table table) {
        ScrollBar verticalBar;
        boolean result = false;
        ScrollBar horizontalBar = table.getHorizontalBar();
        if (horizontalBar != null) {
            boolean bl = result = result || SelectionEvent.hasListener((Adaptable)horizontalBar);
        }
        if ((verticalBar = table.getVerticalBar()) != null) {
            result = result || SelectionEvent.hasListener((Adaptable)verticalBar);
        }
        return result;
    }

    private static void processScrollBarSelection(ScrollBar scrollBar, int selection) {
        if (scrollBar != null) {
            scrollBar.setSelection(selection);
            if (SelectionEvent.hasListener((Adaptable)scrollBar)) {
                int eventId = 13;
                SelectionEvent evt = new SelectionEvent((Widget)scrollBar, null, eventId);
                evt.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
                evt.processEvent();
            }
        }
    }

    static int getDefaultColumnWidth(Table table) {
        int result = 0;
        if (table.getColumnCount() == 0) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = table.getAdapter((Class)clazz);
            ITableAdapter tableAdapter = (ITableAdapter)adapter;
            result = tableAdapter.getDefaultColumnWidth();
        }
        return result;
    }

    static Boolean alwaysHideSelection(Table table) {
        Boolean result = Boolean.FALSE;
        Object data = table.getData(Table.ALWAYS_HIDE_SELECTION);
        if (Boolean.TRUE.equals(data)) {
            result = Boolean.TRUE;
        }
        return result;
    }
}

