/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.expandbarkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IExpandBarAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public final class ExpandBarLCA
extends AbstractWidgetLCA {
    public static final String PROP_BOTTOM_SPACING_BOUNDS = "bottomSpacingBounds";
    public static final String PROP_SHOW_VSCROLLBAR = "showVScrollbar";
    public static final String PROP_VSCROLLBAR_MAX = "vScrollbarMax";
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        ExpandBar expandBar = (ExpandBar)widget;
        ControlLCAUtil.preserveValues((Control)expandBar);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        IExpandBarAdapter expandBarAdapter = ExpandBarLCA.getExpandBarAdapter(expandBar);
        adapter.preserve(PROP_SHOW_VSCROLLBAR, (Object)expandBarAdapter.isVScrollbarVisible());
        adapter.preserve(PROP_VSCROLLBAR_MAX, (Object)ExpandBarLCA.getVScrollbarMax(expandBar));
        adapter.preserve(PROP_BOTTOM_SPACING_BOUNDS, (Object)expandBarAdapter.getBottomSpacingBounds());
    }

    public void readData(Widget widget) {
        ControlLCAUtil.processKeyEvents((Control)widget);
        ControlLCAUtil.processMenuDetect((Control)widget);
        WidgetLCAUtil.processHelp(widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ExpandBar expandBar = (ExpandBar)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)expandBar);
        writer.newWidget("org.eclipse.swt.widgets.ExpandBar");
        WidgetLCAUtil.writeCustomVariant(widget);
        ControlLCAUtil.writeStyleFlags((Control)expandBar);
    }

    public void renderChanges(Widget widget) throws IOException {
        ExpandBar expandBar = (ExpandBar)widget;
        ControlLCAUtil.writeChanges((Control)expandBar);
        ExpandBarLCA.writeBottomSpacing(expandBar);
        ExpandBarLCA.writeShowVScrollbar(expandBar);
        ExpandBarLCA.writeVScrollbarMax(expandBar);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public static IExpandBarAdapter getExpandBarAdapter(ExpandBar bar) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IExpandBarAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IExpandBarAdapter)bar.getAdapter((Class)clazz);
    }

    private static void writeBottomSpacing(ExpandBar bar) throws IOException {
        IExpandBarAdapter expandBarAdapter = ExpandBarLCA.getExpandBarAdapter(bar);
        Rectangle bottomSpacingBounds = expandBarAdapter.getBottomSpacingBounds();
        if (WidgetLCAUtil.hasChanged((Widget)bar, PROP_BOTTOM_SPACING_BOUNDS, bottomSpacingBounds)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)bar);
            writer.call("setBottomSpacingBounds", new Object[]{new Integer(bottomSpacingBounds.x), new Integer(bottomSpacingBounds.y), new Integer(bottomSpacingBounds.width), new Integer(bottomSpacingBounds.height)});
        }
    }

    private static void writeShowVScrollbar(ExpandBar bar) throws IOException {
        IExpandBarAdapter expandBarAdapter = ExpandBarLCA.getExpandBarAdapter(bar);
        Boolean newValue = expandBarAdapter.isVScrollbarVisible();
        if (WidgetLCAUtil.hasChanged((Widget)bar, PROP_SHOW_VSCROLLBAR, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)bar);
            writer.call(PROP_SHOW_VSCROLLBAR, new Object[]{newValue});
        }
    }

    private static void writeVScrollbarMax(ExpandBar bar) throws IOException {
        Integer newValue = ExpandBarLCA.getVScrollbarMax(bar);
        if (WidgetLCAUtil.hasChanged((Widget)bar, PROP_VSCROLLBAR_MAX, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)bar);
            writer.call("setVScrollbarMax", new Object[]{newValue});
        }
    }

    private static Integer getVScrollbarMax(ExpandBar bar) {
        int result = 0;
        IExpandBarAdapter expandBarAdapter = ExpandBarLCA.getExpandBarAdapter(bar);
        ExpandItem[] items = bar.getItems();
        int i = 0;
        while (i < items.length) {
            result += expandBarAdapter.getBounds((ExpandItem)items[i]).height;
            ++i;
        }
        return new Integer(result += bar.getSpacing() * (items.length + 1));
    }
}

