/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.graphics.ColorUtil;

public class ResourceFactory {
    private final Map colors = new HashMap();
    private final Map fonts = new HashMap();
    private final Map cursors = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public Color getColor(int red, int green, int blue) {
        int colorNr = ColorUtil.computeColorNr(red, green, blue);
        return this.getColor(colorNr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Color getColor(int value) {
        Color result;
        Integer key = new Integer(value);
        Map map = this.colors;
        synchronized (map) {
            if (this.colors.containsKey(key)) {
                result = (Color)this.colors.get(key);
            } else {
                result = ResourceFactory.createColorInstance(value);
                this.colors.put(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(FontData fontData) {
        Font result;
        Integer key = new Integer(fontData.hashCode());
        Map map = this.fonts;
        synchronized (map) {
            result = (Font)this.fonts.get(key);
            if (result == null) {
                result = ResourceFactory.createFontInstance(fontData);
                this.fonts.put(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor getCursor(int style) {
        Integer key = new Integer(style);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Cursor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Cursor result = (Cursor)this.cursors.get(key);
            if (result == null) {
                result = ResourceFactory.createCursorInstance(style);
                this.cursors.put(key, result);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return result;
        }
    }

    private static Color createColorInstance(int colorNr) {
        Class[] paramTypes = new Class[]{Integer.TYPE};
        Object[] paramValues = new Object[]{new Integer(colorNr)};
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Color)ClassUtil.newInstance(clazz, paramTypes, paramValues);
    }

    private static Font createFontInstance(FontData fontData) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.graphics.FontData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] paramTypes = classArray;
        Object[] paramValues = new Object[]{fontData};
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.swt.graphics.Font");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Font)ClassUtil.newInstance(clazz2, paramTypes, paramValues);
    }

    private static Cursor createCursorInstance(int style) {
        Class[] paramTypes = new Class[]{Integer.TYPE};
        Object[] paramValues = new Object[]{new Integer(style)};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Cursor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Cursor)ClassUtil.newInstance(clazz, paramTypes, paramValues);
    }
}

