/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.experimental;

import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.queryrender.BaseTupleExprRenderer;
import org.eclipse.rdf4j.queryrender.QueryRenderer;
import org.eclipse.rdf4j.queryrender.sparql.experimental.ParsedQueryPreprocessor;
import org.eclipse.rdf4j.queryrender.sparql.experimental.PreprocessedQuerySerializer;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedBooleanQuery;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedConstructQuery;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedTupleQuery;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedUpdate;

@Experimental
public class SparqlQueryRenderer
extends BaseTupleExprRenderer
implements QueryRenderer {
    @Override
    public QueryLanguage getLanguage() {
        return QueryLanguage.SPARQL;
    }

    @Override
    public String render(ParsedQuery theQuery) {
        if (theQuery instanceof ParsedTupleQuery) {
            ParsedQueryPreprocessor parserVisitor = new ParsedQueryPreprocessor();
            PreprocessedQuerySerializer serializerVisitor = new PreprocessedQuerySerializer();
            SerializableParsedTupleQuery toSerialize = parserVisitor.transformToSerialize((ParsedTupleQuery)theQuery);
            return serializerVisitor.serialize(toSerialize);
        }
        if (theQuery instanceof ParsedBooleanQuery) {
            ParsedQueryPreprocessor parserVisitor = new ParsedQueryPreprocessor();
            PreprocessedQuerySerializer serializerVisitor = new PreprocessedQuerySerializer();
            SerializableParsedBooleanQuery toSerialize = parserVisitor.transformToSerialize((ParsedBooleanQuery)theQuery);
            return serializerVisitor.serialize(toSerialize);
        }
        if (theQuery instanceof ParsedGraphQuery) {
            ParsedQueryPreprocessor parserVisitor = new ParsedQueryPreprocessor();
            PreprocessedQuerySerializer serializerVisitor = new PreprocessedQuerySerializer();
            SerializableParsedConstructQuery toSerialize = parserVisitor.transformToSerialize((ParsedGraphQuery)theQuery);
            return serializerVisitor.serialize(toSerialize);
        }
        throw new UnsupportedOperationException("Only SELECT, ASK, and CONSTRUCT queries are supported");
    }

    public String render(ParsedOperation theOperation) {
        if (theOperation instanceof ParsedQuery) {
            return this.render((ParsedQuery)theOperation);
        }
        if (theOperation instanceof ParsedUpdate) {
            return this.renderUpdate((ParsedUpdate)theOperation);
        }
        throw new UnsupportedOperationException("Only ParsedQuery and ParsedUpdate operations are supported");
    }

    private String renderUpdate(ParsedUpdate theUpdate) {
        StringBuilder exprBuilder = new StringBuilder();
        boolean multipleExpressions = theUpdate.getUpdateExprs().size() > 1;
        for (UpdateExpr updateExpr : theUpdate.getUpdateExprs()) {
            ParsedQueryPreprocessor parserVisitor = new ParsedQueryPreprocessor();
            PreprocessedQuerySerializer serializerVisitor = new PreprocessedQuerySerializer();
            SerializableParsedUpdate toSerialize = parserVisitor.transformToSerialize(updateExpr, theUpdate.getDatasetMapping().get(updateExpr));
            exprBuilder.append(serializerVisitor.serialize(toSerialize));
            if (!multipleExpressions) continue;
            exprBuilder.append(";\n");
        }
        return exprBuilder.toString();
    }

    @Override
    public String render(TupleExpr theExpr) {
        ParsedQueryPreprocessor parserVisitor = new ParsedQueryPreprocessor();
        PreprocessedQuerySerializer serializerVisitor = new PreprocessedQuerySerializer();
        SerializableParsedTupleQuery toSerialize = parserVisitor.transformToSerialize(theExpr);
        return serializerVisitor.serialize(toSerialize);
    }

    @Override
    public String renderValueExpr(ValueExpr theExpr) {
        PreprocessedQuerySerializer serializerVisitor = new PreprocessedQuerySerializer();
        theExpr.visit(serializerVisitor);
        return serializerVisitor.builder.toString();
    }
}

