/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.download;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.rcptt.tesla.swt.download.ServletOutputStreamWrapper;

public class OutputStreamResponseWrapper
extends HttpServletResponseWrapper {
    protected HttpServletResponse origResponse = null;
    protected ByteArrayOutputStream duplicateOutput = null;
    protected ServletOutputStream stream = null;
    protected PrintWriter writer = null;
    private final boolean callRealOutputStream;

    public OutputStreamResponseWrapper(HttpServletResponse response, boolean callRealOutputStream) {
        super(response);
        this.origResponse = response;
        this.callRealOutputStream = callRealOutputStream;
    }

    public void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void flushBuffer() throws IOException {
        this.stream.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getOutputStream() has already been called!");
        }
        if (this.stream == null) {
            try {
                this.duplicateOutput = new ByteArrayOutputStream();
                ServletOutputStream real = this.callRealOutputStream ? super.getOutputStream() : null;
                this.stream = new ServletOutputStreamWrapper((OutputStream)real, this.duplicateOutput);
            }
            catch (Exception ex) {
                throw new IOException("Unable to construct servlet output stream: " + ex.getMessage(), ex);
            }
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called!");
        }
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), "UTF-8"));
        return this.writer;
    }

    public void setContentLength(int length) {
    }

    public ByteArrayOutputStream getSpyOutputStream() {
        return this.duplicateOutput;
    }
}

