/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt.rap;

import org.eclipse.rcptt.tesla.recording.core.swt.rap.IRecorderDescriberExtension;
import org.eclipse.rcptt.tesla.recording.core.swt.rap.IRecordingDescriber;
import org.eclipse.rcptt.tesla.recording.core.swt.rap.RecordingWidgetDescriber;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SWTDescriberExtension
implements IRecorderDescriberExtension {
    @Override
    public IRecordingDescriber getDescriber(Widget widget, IRecordingDescriber previous, int x, int y, boolean fromAsser) {
        return this.getItemAt(new RecordingWidgetDescriber(widget), x, y, fromAsser);
    }

    private IRecordingDescriber getItemAt(IRecordingDescriber descr, int x, int y, boolean fromAssert) {
        Rectangle bounds;
        int n;
        int n2;
        CoolItem[] coolItemArray;
        Widget base = descr.getWidget();
        if (base != null && base.isDisposed()) {
            return descr;
        }
        if (base instanceof TreeItem) {
            return this.getItemAt(new RecordingWidgetDescriber((Widget)((TreeItem)base).getParent()), x, y, fromAssert);
        }
        if (base instanceof TableItem) {
            return this.getItemAt(new RecordingWidgetDescriber((Widget)((TableItem)base).getParent()), x, y, fromAssert);
        }
        if (base instanceof Tree) {
            Tree widget = (Tree)base;
            TreeItem item = null;
            TreeItem[] items = widget.getItems();
            item = this.findTreeItemAt(items, x, y);
            if (item != null) {
                return this.getDescriber((Widget)item);
            }
            return descr;
        }
        if (base instanceof Table) {
            Table widget = (Table)base;
            TableItem item = null;
            TableItem[] items = widget.getItems();
            item = this.findTableItemAt(items, x, y);
            if (item != null) {
                return this.getDescriber((Widget)item);
            }
            return descr;
        }
        if (base instanceof ToolBar) {
            ToolBar bar = (ToolBar)base;
            ToolItem item = bar.getItem(new Point(x, y));
            if (item != null) {
                return this.getDescriber((Widget)item);
            }
            return descr;
        }
        if (base instanceof CoolBar) {
            CoolBar bar = (CoolBar)base;
            CoolItem[] items = bar.getItems();
            Point pt = new Point(x, y);
            coolItemArray = items;
            n2 = items.length;
            n = 0;
            while (n < n2) {
                CoolItem coolItem = coolItemArray[n];
                bounds = coolItem.getBounds();
                if (bounds.contains(pt)) {
                    return this.getDescriber((Widget)coolItem);
                }
                ++n;
            }
        }
        if (fromAssert) {
            if (base instanceof Browser) {
                return descr;
            }
            if (base instanceof ToolItem) {
                return this.getDescriber(base);
            }
            if (base instanceof Control && ((Control)base).getParent() instanceof CCombo) {
                return this.getDescriber((Widget)((Control)base).getParent());
            }
            if (base instanceof Control && ((Control)base).getParent() instanceof DateTime) {
                return this.getDescriber((Widget)((Control)base).getParent());
            }
            if (base instanceof Composite) {
                Composite compo = (Composite)base;
                Control[] children = compo.getChildren();
                Point p = new Point(x, y);
                coolItemArray = children;
                n2 = children.length;
                n = 0;
                while (n < n2) {
                    CoolItem control = coolItemArray[n];
                    if (control.isVisible() && (bounds = control.getBounds()).contains(p)) {
                        return this.getItemAt(this.getDescriber((Widget)control), x - bounds.x, y - bounds.y, fromAssert);
                    }
                    ++n;
                }
            }
        }
        return descr;
    }

    private IRecordingDescriber getDescriber(Widget item) {
        return new RecordingWidgetDescriber(item);
    }

    private TreeItem findTreeItemAt(TreeItem[] items, int x, int y) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (!treeItem.isDisposed()) {
                TreeItem itemAt;
                TreeItem[] treeItems;
                Rectangle treeBounds = treeItem.getParent().getBounds();
                int columnCount = treeItem.getParent().getColumnCount();
                if (columnCount == 0) {
                    Rectangle bounds = treeItem.getBounds();
                    bounds.x = 0;
                    bounds.width = treeBounds.width;
                    if (bounds.contains(x, y)) {
                        return treeItem;
                    }
                } else {
                    int i = 0;
                    while (i < columnCount) {
                        Rectangle bounds = treeItem.getBounds(i);
                        bounds.x = 0;
                        bounds.width = treeBounds.width;
                        if (bounds.contains(x, y)) {
                            return treeItem;
                        }
                        ++i;
                    }
                }
                if ((treeItems = treeItem.getItems()) != null && treeItems.length > 0 && (itemAt = this.findTreeItemAt(treeItems, x, y)) != null) {
                    return itemAt;
                }
            }
            ++n2;
        }
        return null;
    }

    private TableItem findTableItemAt(TableItem[] items, int x, int y) {
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Table parent;
            TableItem tableItem = tableItemArray[n2];
            if (!tableItem.isDisposed() && !(parent = tableItem.getParent()).isDisposed()) {
                int columnCount = parent.getColumnCount();
                if (columnCount == 0) {
                    if (tableItem.getBounds().contains(x, y)) {
                        return tableItem;
                    }
                } else {
                    int i = 0;
                    while (i < columnCount) {
                        if (tableItem.getBounds(i).contains(x, y)) {
                            return tableItem;
                        }
                        ++i;
                    }
                }
            }
            ++n2;
        }
        return null;
    }
}

