/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.EclBoolean;
import org.eclipse.rcptt.ecl.core.EclString;
import org.eclipse.rcptt.tesla.core.protocol.CanvasUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ClickAboutMenu;
import org.eclipse.rcptt.tesla.core.protocol.ClickPreferencesMenu;
import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.DragKind;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.PartUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SWTDialogKind;
import org.eclipse.rcptt.tesla.core.protocol.SetSWTDialogInfo;
import org.eclipse.rcptt.tesla.core.protocol.SetStatusDialogMode;
import org.eclipse.rcptt.tesla.core.protocol.ShowContentAssist;
import org.eclipse.rcptt.tesla.core.protocol.TextUIElement;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.ViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramFactory;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.diagram.FigureUIElement;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommand;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommandKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.ecl.TeslaEclUtils;
import org.eclipse.rcptt.tesla.ecl.impl.rap.AbstractActionService;
import org.eclipse.rcptt.tesla.ecl.impl.rap.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.ActivateCellEdit;
import org.eclipse.rcptt.tesla.ecl.model.CellEdit;
import org.eclipse.rcptt.tesla.ecl.model.Check;
import org.eclipse.rcptt.tesla.ecl.model.Click;
import org.eclipse.rcptt.tesla.ecl.model.ClickRuler;
import org.eclipse.rcptt.tesla.ecl.model.ClickText;
import org.eclipse.rcptt.tesla.ecl.model.Close;
import org.eclipse.rcptt.tesla.ecl.model.ControlHandler;
import org.eclipse.rcptt.tesla.ecl.model.Decrypt;
import org.eclipse.rcptt.tesla.ecl.model.DecryptResult;
import org.eclipse.rcptt.tesla.ecl.model.DoubleClick;
import org.eclipse.rcptt.tesla.ecl.model.DoubleClickRuler;
import org.eclipse.rcptt.tesla.ecl.model.DoubleClickText;
import org.eclipse.rcptt.tesla.ecl.model.DragAction;
import org.eclipse.rcptt.tesla.ecl.model.GetRuntimeTarget;
import org.eclipse.rcptt.tesla.ecl.model.GetText;
import org.eclipse.rcptt.tesla.ecl.model.HoverAtTextOffset;
import org.eclipse.rcptt.tesla.ecl.model.HoverRuler;
import org.eclipse.rcptt.tesla.ecl.model.HoverText;
import org.eclipse.rcptt.tesla.ecl.model.IsDisabled;
import org.eclipse.rcptt.tesla.ecl.model.IsDisposed;
import org.eclipse.rcptt.tesla.ecl.model.KeyType;
import org.eclipse.rcptt.tesla.ecl.model.Maximize;
import org.eclipse.rcptt.tesla.ecl.model.Minimize;
import org.eclipse.rcptt.tesla.ecl.model.OpenDeclaration;
import org.eclipse.rcptt.tesla.ecl.model.Options;
import org.eclipse.rcptt.tesla.ecl.model.Restore;
import org.eclipse.rcptt.tesla.ecl.model.ReturnFromOsDialog;
import org.eclipse.rcptt.tesla.ecl.model.SelectRange;
import org.eclipse.rcptt.tesla.ecl.model.SetCaretPos;
import org.eclipse.rcptt.tesla.ecl.model.SetDialogResult;
import org.eclipse.rcptt.tesla.ecl.model.SetFocus;
import org.eclipse.rcptt.tesla.ecl.model.SetText;
import org.eclipse.rcptt.tesla.ecl.model.SetTextOffset;
import org.eclipse.rcptt.tesla.ecl.model.SetTextSelection;
import org.eclipse.rcptt.tesla.ecl.model.SetValue;
import org.eclipse.rcptt.tesla.ecl.model.ShowTabList;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.tesla.ecl.model.TypeCommandKey;
import org.eclipse.rcptt.tesla.ecl.model.TypeText;
import org.eclipse.rcptt.tesla.ecl.model.Uncheck;
import org.eclipse.rcptt.tesla.ecl.model.Unfocus;
import org.eclipse.rcptt.tesla.ecl.model.diagram.DirectEdit;
import org.eclipse.rcptt.tesla.ecl.model.diagram.MouseAction;
import org.eclipse.rcptt.util.KeysAndButtons;

public class ActionService
extends AbstractActionService {
    @Override
    protected Object exec(Command command) throws CoreException {
        Object result = null;
        if (command instanceof GetText) {
            result = this.handleGetText((GetText)command);
        } else if (command instanceof IsDisposed) {
            result = this.handleIsDisposed((IsDisposed)command);
        } else if (command instanceof IsDisabled) {
            result = this.handleIsDisabled((IsDisabled)command);
        } else if (command instanceof DoubleClick) {
            result = this.handleDoubleClick((DoubleClick)command);
        } else if (command instanceof Click) {
            result = this.handleClick((Click)command);
        } else if (command instanceof TypeText) {
            result = this.handleTypeText((TypeText)command);
        } else if (command instanceof KeyType) {
            result = this.handleKeyType((KeyType)command);
        } else if (command instanceof TypeCommandKey) {
            result = this.handleTypeCommandKey((TypeCommandKey)command);
        } else if (command instanceof DragAction) {
            result = this.handleDrag((DragAction)command);
        } else if (command instanceof SetText) {
            result = this.handleSetText((SetText)command);
        } else if (command instanceof SetValue) {
            result = this.handleSetValue((SetValue)command);
        } else if (command instanceof SetTextSelection) {
            result = this.handleSetTextSelection((SetTextSelection)command);
        } else if (command instanceof SelectRange) {
            result = this.handleSelectRange((SelectRange)command);
        } else if (command instanceof SetTextOffset) {
            result = this.handleSetTextOffset((SetTextOffset)command);
        } else if (command instanceof SetCaretPos) {
            result = this.handleSetCaretPos((SetCaretPos)command);
        } else if (command instanceof OpenDeclaration) {
            result = this.handleOpenDeclaration((OpenDeclaration)command);
        } else if (command instanceof HoverText) {
            result = this.handleHoverAtText((HoverText)command);
        } else if (command instanceof HoverAtTextOffset) {
            result = this.handleHoverAtTextOffset((HoverAtTextOffset)command);
        } else if (command instanceof ClickRuler) {
            result = this.handleRulerClick((ClickRuler)command);
        } else if (command instanceof DoubleClickRuler) {
            result = this.handleRulerDoubleClick((DoubleClickRuler)command);
        } else if (command instanceof HoverRuler) {
            result = this.handleRulerHover((HoverRuler)command);
        } else if (command instanceof MouseAction) {
            result = this.handleMouseAction((MouseAction)command);
        } else if (command instanceof Close) {
            result = this.handleClose((Close)command);
        } else if (command instanceof Check) {
            result = this.handleCheck((Check)command);
        } else if (command instanceof Uncheck) {
            result = this.handleUncheck((Uncheck)command);
        } else if (command instanceof CellEdit) {
            result = this.handleCellEditorAction((CellEdit)command);
        } else if (command instanceof Minimize) {
            result = this.handleMinimize((Minimize)command);
        } else if (command instanceof Maximize) {
            result = this.handleMaximize((Maximize)command);
        } else if (command instanceof Restore) {
            result = this.handleRestore((Restore)command);
        } else if (command instanceof ShowTabList) {
            result = this.handleShowTabList((ShowTabList)command);
        } else if (command instanceof DirectEdit) {
            result = this.handleDirectEdit((DirectEdit)command);
        } else if (command instanceof ReturnFromOsDialog) {
            this.handleReturnFromOsDialog((ReturnFromOsDialog)command);
        } else if (command instanceof SetDialogResult) {
            this.handleSetDialogResult((SetDialogResult)command);
        } else if (command instanceof org.eclipse.rcptt.tesla.ecl.model.ShowContentAssist) {
            this.handleShowContentAssist((org.eclipse.rcptt.tesla.ecl.model.ShowContentAssist)command);
        } else if (command instanceof SetFocus) {
            this.handleSetFocus((SetFocus)command);
        } else if (command instanceof Unfocus) {
            this.handleUnfocus((Unfocus)command);
        } else if (command instanceof ClickText) {
            this.handleClickText((ClickText)command);
        } else if (command instanceof DoubleClickText) {
            this.handleDoubleClickText((DoubleClickText)command);
        } else {
            if (command instanceof Decrypt) {
                return this.handleDecrypt((Decrypt)command);
            }
            if (command instanceof Options) {
                this.handleOptions((Options)command);
            } else if (command instanceof GetRuntimeTarget) {
                return this.handleRuntimeTarget((GetRuntimeTarget)command);
            }
        }
        return result;
    }

    private Object handleRuntimeTarget(GetRuntimeTarget command) {
        EclString result = CoreFactory.eINSTANCE.createEclString();
        result.setValue("rap");
        return result;
    }

    private DecryptResult handleDecrypt(Decrypt command) {
        DecryptResult result = TeslaFactory.eINSTANCE.createDecryptResult();
        result.setValue(command.getValue());
        return result;
    }

    private Object handleMinimize(Minimize command) throws CoreException {
        ControlUIElement controlUIElement = this.getControlUIElement(command.getControl());
        controlUIElement.minimize();
        return command.getControl();
    }

    private Object handleMaximize(Maximize command) throws CoreException {
        ControlUIElement controlUIElement = this.getControlUIElement(command.getControl());
        controlUIElement.maximize();
        return command.getControl();
    }

    private Object handleRestore(Restore command) throws CoreException {
        ControlUIElement controlUIElement = this.getControlUIElement(command.getControl());
        controlUIElement.restore();
        return command.getControl();
    }

    private Object handleShowTabList(ShowTabList command) throws CoreException {
        ControlUIElement controlUIElement = this.getControlUIElement(command.getControl());
        controlUIElement.showTabList();
        return command.getControl();
    }

    private Object handleTypeCommandKey(TypeCommandKey tck) throws CoreException {
        ControlUIElement controlUIElement = this.getControlUIElement(tck.getControl());
        controlUIElement.typeAction(tck.getCommandId());
        return tck.getControl();
    }

    private EclString handleGetText(GetText gt) throws CoreException {
        EclString result = CoreFactory.eINSTANCE.createEclString();
        result.setValue(this.getControlUIElement(gt.getControl()).getText());
        return result;
    }

    private EclBoolean handleIsDisposed(IsDisposed id) throws CoreException {
        EclBoolean result = CoreFactory.eINSTANCE.createEclBoolean();
        result.setValue(this.getControlUIElement(id.getControl()).isDisposed());
        return result;
    }

    private EclBoolean handleIsDisabled(IsDisabled id) throws CoreException {
        EclBoolean result = CoreFactory.eINSTANCE.createEclBoolean();
        result.setValue(this.getControlUIElement(id.getControl()).isDisabled());
        return result;
    }

    private ControlHandler handleClick(Click c) throws CoreException {
        ControlHandler control = c.getControl();
        if (control.getKind() == ElementKind.Item && control.getIndex() != null) {
            Integer column = control.getIndex();
            ControlHandler itemParent = control.getParent();
            if (itemParent == null) {
                throw new CoreException(TeslaImplPlugin.error("Cell parent is not specified"));
            }
            switch (itemParent.getKind()) {
                case Tree: 
                case Table: {
                    ControlHandler viewer = itemParent;
                    Element viewerElement = TeslaBridge.find(viewer);
                    if (viewerElement == null) {
                        throw new CoreException(TeslaImplPlugin.error("Couldn't find " + viewer.getKind().name()));
                    }
                    ViewerUIElement viewerUIElement = new ViewerUIElement(viewerElement, (UIPlayer)TeslaBridge.getPlayer());
                    viewerUIElement.cellClick(column.intValue());
                    break;
                }
                default: {
                    throw new CoreException(TeslaImplPlugin.error("Cell parent must be table or tree"));
                }
            }
            return control;
        }
        if (control.getKind() == ElementKind.AboutMenu) {
            ClickAboutMenu a = ProtocolFactory.eINSTANCE.createClickAboutMenu();
            a.setElement(TeslaBridge.eclipseWindow());
            TeslaBridge.getPlayer().safeExecuteCommand((org.eclipse.rcptt.tesla.core.protocol.raw.Command)a);
            return control;
        }
        if (control.getKind() == ElementKind.PreferencesMenu) {
            ClickPreferencesMenu a = ProtocolFactory.eINSTANCE.createClickPreferencesMenu();
            a.setElement(TeslaBridge.eclipseWindow());
            TeslaBridge.getPlayer().safeExecuteCommand((org.eclipse.rcptt.tesla.core.protocol.raw.Command)a);
            return control;
        }
        ControlUIElement controlUIElement = this.getControlUIElement(control);
        controlUIElement.click(!c.isNowait(), c.isDefault(), c.isArrow());
        return control;
    }

    private ControlHandler handleDoubleClick(DoubleClick dc) throws CoreException {
        ControlUIElement controlUIElement = this.getControlUIElement(dc.getControl());
        controlUIElement.doubleClick(!dc.isNowait());
        return dc.getControl();
    }

    private ControlHandler handleTypeText(TypeText tt) throws CoreException {
        this.getControlUIElement(tt.getControl()).type(tt.getText(), 0, tt.isDisplay());
        return tt.getControl();
    }

    private Object handleKeyType(KeyType kt) throws CoreException {
        char ch;
        if (this.tryHandleTraverse(kt)) {
            return kt.getControl();
        }
        ControlUIElement controlUIElement = this.getControlUIElement(kt.getControl());
        String keyStr = TeslaEclUtils.getKeyByAlias((String)kt.getKey());
        String charStr = kt.getChar();
        try {
            ch = charStr == null ? (char)'\u0000' : this.stringToChar(charStr).charValue();
        }
        catch (ParseException parseException) {
            throw new CoreException(TeslaImplPlugin.error("Illegal character"));
        }
        try {
            KeyStroke key = this.parseKey(keyStr);
            int keyCode = key.getNaturalKey();
            int mask = key.getModifierKeys();
            if (keyCode == 0) {
                controlUIElement.press(mask, 0, kt.isDisplay(), ch, 0, false, kt.getTimes().intValue());
            } else {
                if (ch == '\u0000') {
                    if (keyCode < 0x1000001 || keyCode > 16777303) {
                        int ctrlForm = Character.toUpperCase(keyCode) - 64;
                        ch = (mask & 0x20000) != 0 && (mask & 0x40000) != 0 && (ctrlForm < 32 || ctrlForm == 127) && (ctrlForm & 0x1000000) == 0 ? (char)ctrlForm : ((mask & 0x40000) != 0 && (ctrlForm < 32 || ctrlForm == 127) && (ctrlForm & 0x1000000) == 0 ? (char)ctrlForm : ((mask & 0x20000) != 0 ? (char)Character.toUpperCase(keyCode) : (char)keyCode));
                    }
                } else if ((mask & 0x40000) != 0 && (ch - 64 < 32 || ch - 64 == 127) && (ch - 64 & 0x1000000) == 0) {
                    ch = (char)(ch - 64);
                }
                controlUIElement.press(keyCode, mask, kt.isDisplay(), ch, 0, false, kt.getTimes().intValue());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CoreException(TeslaImplPlugin.error("Illegal key"));
        }
        return kt.getControl();
    }

    private boolean tryHandleTraverse(KeyType kt) throws CoreException {
        String Key = kt.getKey();
        char ch = '\u0000';
        Integer traverseType = null;
        if (Key.equals("TRAVERSE_NONE")) {
            traverseType = 0;
        } else if (Key.equals("TRAVERSE_ESCAPE")) {
            traverseType = 2;
        } else if (Key.equals("TRAVERSE_RETURN")) {
            traverseType = 4;
        } else if (Key.equals("TRAVERSE_TAB_NEXT")) {
            traverseType = 16;
        } else if (Key.equals("TRAVERSE_TAB_PREVIOUS")) {
            traverseType = 8;
        }
        if (traverseType != null) {
            ControlUIElement controlUIElement = this.getControlUIElement(kt.getControl());
            controlUIElement.traverse(traverseType.intValue(), ch, kt.getTimes().intValue());
            return true;
        }
        return false;
    }

    private int parseMask(String keyStr) throws CoreException {
        block5: {
            try {
                if (keyStr != null && keyStr.length() != 0) break block5;
                return 0;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return Integer.valueOf(keyStr);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CoreException(TeslaImplPlugin.error("Invalid mask"));
                }
            }
        }
        KeyStroke ks = this.parseKey(keyStr);
        return ks.getModifierKeys() | ks.getNaturalKey();
    }

    private static int parseDetail(String detail) {
        if (detail == null) {
            return 0;
        }
        if (detail.equalsIgnoreCase("copy")) {
            return 1;
        }
        if (detail.equalsIgnoreCase("move")) {
            return 2;
        }
        if (detail.equalsIgnoreCase("link")) {
            return 4;
        }
        if (detail.equalsIgnoreCase("target-move")) {
            return 8;
        }
        if (detail.equalsIgnoreCase("any")) {
            return 16;
        }
        if (detail.equalsIgnoreCase("none")) {
            return 0;
        }
        try {
            return Integer.parseInt(detail);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private Object handleDrag(DragAction d) throws CoreException {
        DragKind kind = null;
        switch (d.eClass().getClassifierID()) {
            case 75: {
                kind = DragKind.ACCEPT;
                break;
            }
            case 76: {
                kind = DragKind.DETECT;
                break;
            }
            case 78: {
                kind = DragKind.DROP;
                break;
            }
            case 71: {
                kind = DragKind.END;
                break;
            }
            case 72: {
                kind = DragKind.ENTER;
                break;
            }
            case 73: {
                kind = DragKind.LEAVE;
                break;
            }
            case 77: {
                kind = DragKind.OVER;
                break;
            }
            case 74: {
                kind = DragKind.SET_DATA;
                break;
            }
            case 70: {
                kind = DragKind.START;
                break;
            }
            default: {
                throw new CoreException(TeslaImplPlugin.error("Unsupported kind of DnD"));
            }
        }
        int detail = ActionService.parseDetail(d.getDetail());
        int button = d.getButton() == null ? 0 : d.getButton().getValue();
        int operations = d.getOperation() == null ? -1 : d.getOperation();
        int stateMask = this.parseMask(d.getMask());
        String style = "";
        style = String.valueOf(style) + "detail:" + detail + ",";
        style = String.valueOf(style) + "button:" + button + ",";
        style = String.valueOf(style) + "mask:" + stateMask + ",";
        style = String.valueOf(style) + "operations:" + operations;
        this.getControlUIElement(d.getControl()).drag(kind, d.getX(), d.getY(), style);
        return d.getControl();
    }

    private ControlHandler handleSetText(SetText st) throws CoreException {
        ControlHandler control = st.getControl();
        if (ElementKind.Item.equals((Object)control.getKind())) {
            ControlHandler parent = control.getParent();
            ViewerUIElement viewer = new ViewerUIElement(TeslaBridge.find(parent), (UIPlayer)TeslaBridge.getPlayer());
            viewer.setSelection(new String[]{control.getPath()});
            viewer.activateCellEditor(1);
            PartUIElement part = new PartUIElement(TeslaBridge.find(parent.getParent()), (UIPlayer)TeslaBridge.getPlayer());
            TextUIElement text = part.text();
            text.setText(st.getText());
            viewer.applyCellEditor();
        } else {
            ActionService.getTextUIElement(control).setText(st.getText());
        }
        return control;
    }

    private ControlHandler handleSetValue(SetValue st) throws CoreException {
        ControlHandler control = st.getControl();
        if (ElementKind.Item.equals((Object)control.getKind())) {
            ControlHandler parent = control.getParent();
            ViewerUIElement viewer = new ViewerUIElement(TeslaBridge.find(parent), (UIPlayer)TeslaBridge.getPlayer());
            viewer.setSelection(new String[]{control.getPath()});
            viewer.activateCellEditor(1);
            PartUIElement part = new PartUIElement(TeslaBridge.find(parent.getParent()), (UIPlayer)TeslaBridge.getPlayer());
            TextUIElement text = part.text();
            text.setText(st.getValue());
            viewer.applyCellEditor();
        } else {
            ActionService.getTextUIElement(control).setText(st.getValue());
        }
        return control;
    }

    private ControlHandler handleSetTextSelection(SetTextSelection st) throws CoreException {
        ControlHandler control = st.getControl();
        if (st.getStartLine() != null && st.getEndLine() != null && st.getEndOffset() != null) {
            ActionService.getTextUIElement(control).setSelection(st.getStartLine().intValue(), st.getOffset().intValue(), st.getEndLine().intValue(), st.getEndOffset().intValue());
        } else {
            ActionService.getTextUIElement(control).setSelection(st.getOffset().intValue(), st.getLength().intValue());
        }
        return control;
    }

    private ControlHandler handleSelectRange(SelectRange st) throws CoreException {
        ControlHandler control = st.getControl();
        ActionService.getTextUIElement(control).setSelection2(st.getLine(), st.getColumn(), st.getEndLine(), st.getEndColumn());
        return control;
    }

    private ControlHandler handleSetTextOffset(SetTextOffset st) throws CoreException {
        if (st.getLine() != null) {
            ActionService.getTextUIElement(st.getControl()).setTextOffset(st.getLine().intValue(), st.getValue().intValue());
        } else {
            ActionService.getTextUIElement(st.getControl()).setTextOffset(-1, st.getValue().intValue());
        }
        return st.getControl();
    }

    private ControlHandler handleSetCaretPos(SetCaretPos st) throws CoreException {
        ActionService.getTextUIElement(st.getControl()).setTextCursor(st.getLine(), st.getColumn());
        return st.getControl();
    }

    private ControlHandler handleOpenDeclaration(OpenDeclaration od) throws CoreException {
        ActionService.getTextUIElement(od.getControl()).openDeclaration();
        return od.getControl();
    }

    private ControlHandler handleHoverAtTextOffset(HoverAtTextOffset st) throws CoreException {
        ActionService.getTextUIElement(st.getControl()).hoverAtOffset(st.getOffset().intValue(), st.getLine().intValue());
        return st.getControl();
    }

    private ControlHandler handleHoverAtText(HoverText st) throws CoreException {
        ActionService.getTextUIElement(st.getControl()).hoverAtText(st.getLine(), st.getColumn(), KeysAndButtons.stateMaskFromStr((String)st.getWith()));
        return st.getControl();
    }

    private ControlHandler handleRulerClick(ClickRuler rulerClick) throws CoreException {
        int button = KeysAndButtons.getButtonNumber((String)rulerClick.getButton());
        int stateMask = KeysAndButtons.stateMaskFromStr((String)rulerClick.getWith());
        ActionService.getTextUIElement(rulerClick.getControl()).RulerClick(rulerClick.getLine(), button, stateMask);
        return rulerClick.getControl();
    }

    private ControlHandler handleRulerDoubleClick(DoubleClickRuler rulerDoubleClick) throws CoreException {
        int button = KeysAndButtons.getButtonNumber((String)rulerDoubleClick.getButton());
        ActionService.getTextUIElement(rulerDoubleClick.getControl()).RulerDoubleClick(rulerDoubleClick.getLine(), button, KeysAndButtons.stateMaskFromStr((String)rulerDoubleClick.getWith()));
        return rulerDoubleClick.getControl();
    }

    private ControlHandler handleRulerHover(HoverRuler rulerHover) throws CoreException {
        ActionService.getTextUIElement(rulerHover.getControl()).RulerHover(rulerHover.getLine(), KeysAndButtons.stateMaskFromStr((String)rulerHover.getWith()));
        return rulerHover.getControl();
    }

    private ControlHandler handleMouseAction(MouseAction ma) throws CoreException {
        int x = ma.getX() == null ? 0 : ma.getX();
        int y = ma.getY() == null ? 0 : ma.getY();
        int button = ma.getButton() == null ? 0 : ma.getButton().getValue();
        int mask = this.parseMask(ma.getMask());
        MouseCommandKind kind = null;
        switch (ma.eClass().getClassifierID()) {
            case 14: {
                kind = MouseCommandKind.DOUBLE_CLICK;
                break;
            }
            case 11: {
                kind = MouseCommandKind.DRAG;
                break;
            }
            case 15: {
                kind = MouseCommandKind.ENTER;
                break;
            }
            case 16: {
                kind = MouseCommandKind.EXIT;
                break;
            }
            case 17: {
                kind = MouseCommandKind.HOVER;
                break;
            }
            case 10: {
                kind = MouseCommandKind.MOVE;
                break;
            }
            case 12: {
                kind = MouseCommandKind.DOWN;
                break;
            }
            case 13: {
                kind = MouseCommandKind.UP;
                break;
            }
            default: {
                throw new CoreException(TeslaImplPlugin.error("Unsupported mouse command kind"));
            }
        }
        ControlHandler control = ma.getControl();
        Integer height = ma.getHeight();
        Integer width = ma.getWidth();
        if (height != null && width != null) {
            ControlHandler target = control;
            if (target.getKind().equals((Object)ElementKind.PaletteEntry)) {
                Element paletteEntry = TeslaBridge.find(target);
                FigureUIElement uiElement = new FigureUIElement(paletteEntry, (UIPlayer)TeslaBridge.getPlayer());
                uiElement.executeFigureMouseCommand(x, y, button, kind, null, null, width.intValue(), height.intValue(), width.intValue(), height.intValue(), mask);
                return target;
            }
            if (target.getKind().equals((Object)ElementKind.Canvas)) {
                Element paletteEntry = TeslaBridge.find(target);
                FigureUIElement uiElement = new FigureUIElement(paletteEntry, (UIPlayer)TeslaBridge.getPlayer());
                uiElement.executeFigureMouseCommand(x, y, button, kind, null, null, width.intValue(), height.intValue(), width.intValue(), height.intValue(), mask);
                return target;
            }
            switch (target.getKind()) {
                case DiagramFigure: {
                    FigureUIElement element = this.getFigureUIElement(target);
                    element.executeFigureMouseCommand(x, y, button, kind, null, null, width.intValue(), height.intValue(), width.intValue(), height.intValue(), mask);
                    return target;
                }
                case DiagramViewer: 
                case PaletteViewer: {
                    DiagramViewerUIElement element = this.getDiagramViewerUIElement(target);
                    element.executeFigureMouseCommand(x, y, button, kind, null, null, width.intValue(), height.intValue(), width.intValue(), height.intValue(), mask);
                    return target;
                }
            }
            throw new CoreException(TeslaImplPlugin.error("Illegal control kind: " + target.getKind()));
        }
        MouseCommand command = DiagramFactory.eINSTANCE.createMouseCommand();
        command.setKind(kind);
        command.setButton(button);
        command.setElement(TeslaBridge.find(control));
        command.setX(x);
        command.setY(y);
        command.setStateMask(mask);
        TeslaBridge.getPlayer().safeExecuteCommand((org.eclipse.rcptt.tesla.core.protocol.raw.Command)command);
        return control;
    }

    private ControlHandler handleClose(Close c) throws CoreException {
        this.getPartUIElement(c.getControl()).close();
        return c.getControl();
    }

    private ControlHandler handleCheck(Check c) throws CoreException {
        ControlHandler control = c.getControl();
        String path = control.getPath();
        if (path == null || path != null && control.getKind().equals((Object)ElementKind.Menu)) {
            ControlUIElement controlUIElement = this.getControlUIElement(control);
            controlUIElement.check(true);
            return control;
        }
        boolean result = ActionService.getViewerUIElement(control.getParent()).checkItemList(true, TeslaBridge.parsePath(path));
        if (!result) {
            throw new CoreException(TeslaImplPlugin.error("Cannot check item(s)"));
        }
        return control;
    }

    private ControlHandler handleUncheck(Uncheck c) throws CoreException {
        ControlHandler control = c.getControl();
        String path = control.getPath();
        if (path == null || path != null && control.getKind().equals((Object)ElementKind.Menu)) {
            ControlUIElement controlUIElement = this.getControlUIElement(control);
            controlUIElement.check(false);
            return control;
        }
        boolean result = ActionService.getViewerUIElement(control.getParent()).checkItemList(false, TeslaBridge.parsePath(path));
        if (!result) {
            throw new CoreException(TeslaImplPlugin.error("Cannot uncheck item(s)"));
        }
        return control;
    }

    private ControlHandler handleCellEditorAction(CellEdit c) throws CoreException {
        block12: {
            block11: {
                boolean capable;
                ControlHandler control = c.getControl();
                Integer column = null;
                if (control.getKind() == ElementKind.Item && control.getColumn() != null) {
                    column = control.getColumn();
                    if ((control = control.getParent()) == null) {
                        throw new CoreException(TeslaImplPlugin.error("Parent is not specified"));
                    }
                }
                if (control.getKind() != ElementKind.Tree && control.getKind() != ElementKind.Table && control.getKind() == ElementKind.Item && (control = control.getParent()) == null) {
                    throw new CoreException(TeslaImplPlugin.error("Parent is not specified"));
                }
                boolean bl = capable = control.getKind().equals((Object)ElementKind.Tree) || control.getKind().equals((Object)ElementKind.Table) || "NebulaGrid".equals(control.getCustomKindId());
                if (!capable) break block11;
                Element viewerElement = TeslaBridge.find(control);
                if (viewerElement == null) {
                    throw new CoreException(TeslaImplPlugin.error("Couldn't find " + control.getKind().name()));
                }
                ViewerUIElement viewerUIElement = new ViewerUIElement(viewerElement, (UIPlayer)TeslaBridge.getPlayer());
                switch (c.eClass().getClassifierID()) {
                    case 61: {
                        if (column == null) {
                            column = ((ActivateCellEdit)c).getColumn();
                        }
                        viewerUIElement.activateCellEditor(column.intValue());
                        break block12;
                    }
                    case 62: {
                        viewerUIElement.applyCellEditor();
                        break block12;
                    }
                    case 63: {
                        viewerUIElement.cancelCellEditor();
                        break block12;
                    }
                    case 64: {
                        viewerUIElement.deactivateCellEditor();
                        break block12;
                    }
                    default: {
                        throw new CoreException(TeslaImplPlugin.error("Unsupported cell operation"));
                    }
                }
            }
            throw new CoreException(TeslaImplPlugin.error("Cell parent must be table or tree"));
        }
        return c.getControl();
    }

    private ControlHandler handleDirectEdit(DirectEdit c) throws CoreException {
        ControlHandler control = c.getControl();
        if (control.getKind() != ElementKind.DiagramViewer && control.getKind() != ElementKind.PaletteViewer && control.getKind() != ElementKind.DiagramFigure && control.getKind() != ElementKind.PaletteEntry) {
            throw new CoreException(TeslaImplPlugin.error("Diagram element is not specified"));
        }
        FigureUIElement diagramUIElement = this.getFigureUIElement(control);
        switch (c.eClass().getClassifierID()) {
            case 6: {
                diagramUIElement.activateDirectEdit(null);
                break;
            }
            case 7: {
                diagramUIElement.commitDirectEdit();
                break;
            }
            case 8: {
                diagramUIElement.cancelDirectEdit();
                break;
            }
            default: {
                throw new CoreException(TeslaImplPlugin.error("Unsupported direct edit operation"));
            }
        }
        return c.getControl();
    }

    private void handleReturnFromOsDialog(ReturnFromOsDialog c) throws CoreException {
        SetSWTDialogInfo info = ProtocolFactory.eINSTANCE.createSetSWTDialogInfo();
        SWTDialogKind kind = SWTDialogKind.valueOf((String)c.getKind());
        if (kind == null) {
            throw new CoreException(TeslaImplPlugin.error("Illegal kind"));
        }
        info.setKind(kind);
        for (String currentStr : c.getResult()) {
            info.getPath().add((Object)currentStr);
        }
        TeslaBridge.getPlayer().safeExecuteCommand((org.eclipse.rcptt.tesla.core.protocol.raw.Command)info);
    }

    private void handleSetDialogResult(SetDialogResult c) throws CoreException {
        SetSWTDialogInfo info = ProtocolFactory.eINSTANCE.createSetSWTDialogInfo();
        SWTDialogKind kind = null;
        String k = c.getKind();
        if (k.equalsIgnoreCase("File")) {
            kind = SWTDialogKind.FILE_SELECTOR;
        } else if (k.equalsIgnoreCase("Folder")) {
            kind = SWTDialogKind.FOLDER_SELECTOR;
        } else if (k.equalsIgnoreCase("Color")) {
            kind = SWTDialogKind.COLOR;
        } else if (k.equalsIgnoreCase("Font")) {
            kind = SWTDialogKind.FONT_DIALOG;
        } else if (k.equalsIgnoreCase("MessageBox")) {
            kind = SWTDialogKind.MESSAGE_BOX;
        }
        if (kind == null) {
            throw new CoreException(TeslaImplPlugin.error("Illegal kind"));
        }
        info.setKind(kind);
        for (String currentStr : c.getResult()) {
            info.getPath().add((Object)currentStr);
        }
        TeslaBridge.getPlayer().safeExecuteCommand((org.eclipse.rcptt.tesla.core.protocol.raw.Command)info);
    }

    private void handleOptions(Options c) throws CoreException {
        SetStatusDialogMode mode = ProtocolFactory.eINSTANCE.createSetStatusDialogMode();
        mode.setEnabled(c.isAllowStatusDialog());
        TeslaBridge.getPlayer().safeExecuteCommand((org.eclipse.rcptt.tesla.core.protocol.raw.Command)mode);
    }

    private void handleShowContentAssist(org.eclipse.rcptt.tesla.ecl.model.ShowContentAssist c) throws CoreException {
        ShowContentAssist a = ProtocolFactory.eINSTANCE.createShowContentAssist();
        a.setElement(TeslaBridge.find(c.getControl()));
        TeslaBridge.getPlayer().safeExecuteCommand((org.eclipse.rcptt.tesla.core.protocol.raw.Command)a);
    }

    private ControlHandler handleSetFocus(SetFocus c) throws CoreException {
        this.getControlUIElement(c.getControl()).setFocus();
        return c.getControl();
    }

    private ControlHandler handleUnfocus(Unfocus c) throws CoreException {
        this.getControlUIElement(c.getControl()).unfocus();
        return c.getControl();
    }

    private ControlHandler handleClickText(ClickText c) throws CoreException {
        this.getControlUIElement(c.getControl()).clickText(c.getStart(), c.getEnd(), c.getButton());
        return c.getControl();
    }

    private ControlHandler handleDoubleClickText(DoubleClickText c) throws CoreException {
        this.getControlUIElement(c.getControl()).doubleClickText(c.getPosition(), c.getButton());
        return c.getControl();
    }

    private ControlUIElement getControlUIElement(ControlHandler control) throws CoreException {
        ControlUIElement element = new ControlUIElement(TeslaBridge.find(control), (UIPlayer)TeslaBridge.getPlayer());
        TeslaBridge.storeLastControlUIElement(element);
        return element;
    }

    static TextUIElement getTextUIElement(ControlHandler control) throws CoreException {
        TextUIElement element = new TextUIElement(TeslaBridge.find(control), (UIPlayer)TeslaBridge.getPlayer());
        TeslaBridge.storeLastControlUIElement((ControlUIElement)element);
        return element;
    }

    private CanvasUIElement getCanvasUIElement(ControlHandler control) throws CoreException {
        CanvasUIElement element = new CanvasUIElement(TeslaBridge.find(control), (UIPlayer)TeslaBridge.getPlayer());
        return element;
    }

    private PartUIElement getPartUIElement(ControlHandler control) throws CoreException {
        PartUIElement element = new PartUIElement(TeslaBridge.find(control), (UIPlayer)TeslaBridge.getPlayer());
        TeslaBridge.storeLastControlUIElement((ControlUIElement)element);
        return element;
    }

    static ViewerUIElement getViewerUIElement(ControlHandler control) throws CoreException {
        ViewerUIElement element = new ViewerUIElement(TeslaBridge.find(control), (UIPlayer)TeslaBridge.getPlayer());
        TeslaBridge.storeLastControlUIElement((ControlUIElement)element);
        return element;
    }

    private DiagramViewerUIElement getDiagramViewerUIElement(ControlHandler control) throws CoreException {
        DiagramViewerUIElement element = new DiagramViewerUIElement(TeslaBridge.find(control), (UIPlayer)TeslaBridge.getPlayer());
        return element;
    }

    private FigureUIElement getFigureUIElement(ControlHandler control) throws CoreException {
        return new FigureUIElement(TeslaBridge.find(control), (UIPlayer)TeslaBridge.getPlayer());
    }

    private KeyStroke parseKey(String string) {
        if (string == null) {
            throw new NullPointerException("Cannot parse a null string");
        }
        IKeyLookup lookup = KeyLookupFactory.getDefault();
        int modifierKeys = 0;
        int naturalKey = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+", true);
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (i % 2 == 0) {
                if (stringTokenizer.hasMoreTokens()) {
                    int modifierKey = lookup.formalModifierLookup(token = token.toUpperCase());
                    if (modifierKey == 0) {
                        throw new IllegalArgumentException();
                    }
                    modifierKeys |= modifierKey;
                } else if (token.length() == 1) {
                    naturalKey = token.charAt(0);
                } else {
                    token = token.toUpperCase();
                    try {
                        naturalKey = lookup.formalKeyLookup(token);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        naturalKey = lookup.formalModifierLookup(token);
                    }
                    if (naturalKey == 0) {
                        throw new IllegalArgumentException();
                    }
                }
            }
            ++i;
        }
        return KeyStroke.getInstance((int)modifierKeys, (int)naturalKey);
    }

    private Character stringToChar(String s) throws ParseException {
        if (s.length() == 1) {
            return Character.valueOf(s.charAt(0));
        }
        if (s.startsWith("\\u")) {
            try {
                return Character.valueOf((char)Integer.valueOf(s.substring(2), 16).intValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }
}

