/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;

public class DirectoryBundleContainer
extends AbstractBundleContainer {
    public static final String TYPE = "Directory";
    private final String fPath;

    public DirectoryBundleContainer(String path) {
        this.fPath = path;
    }

    @Override
    public String getLocation(boolean resolve) throws CoreException {
        if (resolve) {
            return this.getDirectory().toString();
        }
        return this.fPath;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        File dir = this.getDirectory();
        if (dir.isDirectory()) {
            File site = this.getSite(dir);
            File[] files = site.listFiles();
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DirectoryBundleContainer_0, (int)files.length);
            ArrayList bundles = new ArrayList(files.length);
            ((Stream)Arrays.stream(files).parallel()).forEach(file -> {
                try {
                    TargetBundle rb = new TargetBundle((File)file);
                    List list2 = bundles;
                    synchronized (list2) {
                        bundles.add(rb);
                    }
                }
                catch (CoreException coreException) {}
                localMonitor.split(1);
            });
            return bundles.toArray(new TargetBundle[bundles.size()]);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.DirectoryBundleContainer_1, (Object)dir.toString())));
    }

    @Override
    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        File dir = this.getDirectory();
        if (!dir.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.DirectoryBundleContainer_1, (Object)dir.toString())));
        }
        File site = this.getFeatureSite(dir);
        File[] files = site.listFiles();
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DirectoryBundleContainer_0, (int)files.length);
        ArrayList features = new ArrayList(files.length);
        ((Stream)Arrays.stream(files).parallel()).forEach(file -> {
            try {
                TargetFeature rf = new TargetFeature((File)file);
                List list2 = features;
                synchronized (list2) {
                    features.add(rf);
                }
            }
            catch (CoreException coreException) {}
            localMonitor.split(1);
        });
        return features.toArray(new TargetFeature[features.size()]);
    }

    protected File getDirectory() throws CoreException {
        String path = this.resolveVariables(this.fPath);
        return new File(path);
    }

    public boolean equals(Object o) {
        if (o instanceof DirectoryBundleContainer) {
            DirectoryBundleContainer dbc = (DirectoryBundleContainer)o;
            return this.fPath.equals(dbc.fPath);
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode();
    }

    public String toString() {
        return "Directory " + this.fPath;
    }

    private File getSite(File root) {
        File file = new File(root, "plugins");
        if (file.exists()) {
            return file;
        }
        return root;
    }

    private File getFeatureSite(File root) {
        File file = new File(root, "features");
        if (file.exists()) {
            return file;
        }
        return root;
    }
}

