/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.equinox;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lbc.api.BackendCluster;
import org.eclipse.passage.lbc.api.BackendLauncher;
import org.eclipse.passage.lbc.internal.equinox.i18n.EquinoxMessages;
import org.eclipse.passage.lic.api.LicensingResult;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

@Component(immediate=true)
public class ServerRunnerImpl
implements BackendCluster {
    private List<BackendLauncher> backendLaunchers = new ArrayList<BackendLauncher>();
    private LoggerFactory loggerFactory;
    private Logger logger;

    @Activate
    public void activate() {
    }

    @Deactivate
    public void deactivate() {
        for (BackendLauncher launcher : this.backendLaunchers) {
            launcher.terminate();
        }
        this.backendLaunchers.clear();
    }

    @Reference
    public void bindLogger(LoggerFactory factory) {
        this.loggerFactory = factory;
        this.logger = factory.getLogger(ServerRunnerImpl.class);
    }

    public void unbindLogger(LoggerFactory factory) {
        if (this.loggerFactory == factory) {
            this.loggerFactory = null;
            this.logger = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindServerHandler(BackendLauncher serverHandler, Map<String, Object> context) {
        this.logger.info(NLS.bind((String)EquinoxMessages.ServerRunnerImpl_i_launcher_bind, (Object)serverHandler));
        LicensingResult result = serverHandler.launch(context);
        switch (result.getSeverity()) {
            case 4: {
                this.logger.error(result.getMessage());
                this.logger.error(NLS.bind((String)EquinoxMessages.ServerRunnerImpl_error_launching, (Object)serverHandler.getClass().getName()));
                break;
            }
            case 0: {
                this.logger.info(result.getMessage());
                this.backendLaunchers.add(serverHandler);
                break;
            }
            default: {
                this.logger.warn(result.getMessage());
            }
        }
    }

    public void unbindServerHandler(BackendLauncher serverHandler) {
        if (serverHandler != null) {
            this.logger.info(NLS.bind((String)EquinoxMessages.ServerRunnerImpl_i_launcher_unbind, (Object)serverHandler));
            serverHandler.terminate();
            this.backendLaunchers.remove(serverHandler);
        }
    }

    public List<BackendLauncher> getBackendLaunchers() {
        return this.backendLaunchers;
    }
}

