/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Disks;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.jna.platform.mac.CoreFoundation;
import oshi.jna.platform.mac.DiskArbitration;
import oshi.jna.platform.mac.IOKit;
import oshi.jna.platform.mac.SystemB;
import oshi.util.ExecutingCommand;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.mac.CfUtil;
import oshi.util.platform.mac.IOKitUtil;

public class MacDisks
implements Disks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacDisks.class);
    private static final Map<String, String> mountPointMap = new HashMap<String, String>();
    private static final Map<String, String> logicalVolumeMap = new HashMap<String, String>();

    private static boolean updateDiskStats(HWDiskStore diskStore, DiskArbitration.DASessionRef session) {
        String bsdName = diskStore.getName();
        CoreFoundation.CFMutableDictionaryRef matchingDict = IOKitUtil.getBSDNameMatchingDict(bsdName);
        if (matchingDict != null) {
            IntByReference driveList = new IntByReference();
            IOKitUtil.getMatchingServices(matchingDict, driveList);
            int drive = IOKit.INSTANCE.IOIteratorNext(driveList.getValue());
            if (drive != 0) {
                IntByReference parent = new IntByReference();
                if (IOKit.INSTANCE.IOObjectConformsTo(drive, "IOMedia") && IOKit.INSTANCE.IORegistryEntryGetParentEntry(drive, "IOService", parent) == 0) {
                    PointerByReference propsPtr = new PointerByReference();
                    if (IOKit.INSTANCE.IOObjectConformsTo(parent.getValue(), "IOBlockStorageDriver") && IOKit.INSTANCE.IORegistryEntryCreateCFProperties(parent.getValue(), propsPtr, CfUtil.ALLOCATOR, 0) == 0) {
                        CoreFoundation.CFMutableDictionaryRef properties = new CoreFoundation.CFMutableDictionaryRef();
                        properties.setPointer(propsPtr.getValue());
                        Pointer statsPtr = CoreFoundation.INSTANCE.CFDictionaryGetValue(properties, CfUtil.getCFString("Statistics"));
                        diskStore.setTimeStamp(System.currentTimeMillis());
                        CoreFoundation.CFDictionaryRef statistics = new CoreFoundation.CFDictionaryRef();
                        statistics.setPointer(statsPtr);
                        Pointer stat = CoreFoundation.INSTANCE.CFDictionaryGetValue(statistics, CfUtil.getCFString("Operations (Read)"));
                        diskStore.setReads(CfUtil.cfPointerToLong(stat));
                        stat = CoreFoundation.INSTANCE.CFDictionaryGetValue(statistics, CfUtil.getCFString("Bytes (Read)"));
                        diskStore.setReadBytes(CfUtil.cfPointerToLong(stat));
                        stat = CoreFoundation.INSTANCE.CFDictionaryGetValue(statistics, CfUtil.getCFString("Operations (Write)"));
                        diskStore.setWrites(CfUtil.cfPointerToLong(stat));
                        stat = CoreFoundation.INSTANCE.CFDictionaryGetValue(statistics, CfUtil.getCFString("Bytes (Write)"));
                        diskStore.setWriteBytes(CfUtil.cfPointerToLong(stat));
                        stat = CoreFoundation.INSTANCE.CFDictionaryGetValue(statistics, CfUtil.getCFString("Total Time (Read)"));
                        long xferTime = CfUtil.cfPointerToLong(stat);
                        stat = CoreFoundation.INSTANCE.CFDictionaryGetValue(statistics, CfUtil.getCFString("Total Time (Write)"));
                        diskStore.setTransferTime((xferTime += CfUtil.cfPointerToLong(stat)) / 1000000L);
                        CfUtil.release(properties);
                    } else {
                        LOG.debug("Unable to find block storage driver properties for {}", (Object)bsdName);
                    }
                    ArrayList<HWPartition> partitions = new ArrayList<HWPartition>();
                    if (IOKit.INSTANCE.IORegistryEntryCreateCFProperties(drive, propsPtr, CfUtil.ALLOCATOR, 0) == 0) {
                        CoreFoundation.CFMutableDictionaryRef properties = new CoreFoundation.CFMutableDictionaryRef();
                        properties.setPointer(propsPtr.getValue());
                        Pointer p = CoreFoundation.INSTANCE.CFDictionaryGetValue(properties, CfUtil.getCFString("BSD Unit"));
                        CoreFoundation.CFNumberRef bsdUnit = new CoreFoundation.CFNumberRef();
                        bsdUnit.setPointer(p);
                        p = CoreFoundation.INSTANCE.CFDictionaryGetValue(properties, CfUtil.getCFString("Leaf"));
                        CoreFoundation.CFBooleanRef cfFalse = new CoreFoundation.CFBooleanRef();
                        cfFalse.setPointer(p);
                        CoreFoundation.CFMutableDictionaryRef propertyDict = CoreFoundation.INSTANCE.CFDictionaryCreateMutable(CfUtil.ALLOCATOR, 0, null, null);
                        CoreFoundation.INSTANCE.CFDictionarySetValue(propertyDict, CfUtil.getCFString("BSD Unit"), bsdUnit);
                        CoreFoundation.INSTANCE.CFDictionarySetValue(propertyDict, CfUtil.getCFString("Whole"), cfFalse);
                        matchingDict = CoreFoundation.INSTANCE.CFDictionaryCreateMutable(CfUtil.ALLOCATOR, 0, null, null);
                        CoreFoundation.INSTANCE.CFDictionarySetValue(matchingDict, CfUtil.getCFString("IOPropertyMatch"), propertyDict);
                        IntByReference serviceIterator = new IntByReference();
                        IOKitUtil.getMatchingServices(matchingDict, serviceIterator);
                        CfUtil.release(properties);
                        CfUtil.release(propertyDict);
                        int sdService = IOKit.INSTANCE.IOIteratorNext(serviceIterator.getValue());
                        while (sdService != 0) {
                            String partBsdName;
                            String name = partBsdName = IOKitUtil.getIORegistryStringProperty(sdService, "BSD Name");
                            String type = "";
                            DiskArbitration.DADiskRef disk = DiskArbitration.INSTANCE.DADiskCreateFromBSDName(CfUtil.ALLOCATOR, session, partBsdName);
                            if (disk != null) {
                                CoreFoundation.CFDictionaryRef diskInfo = DiskArbitration.INSTANCE.DADiskCopyDescription(disk);
                                if (diskInfo != null) {
                                    Pointer volumePtr = CoreFoundation.INSTANCE.CFDictionaryGetValue(diskInfo, CfUtil.getCFString("DAMediaName"));
                                    type = CfUtil.cfPointerToString(volumePtr);
                                    volumePtr = CoreFoundation.INSTANCE.CFDictionaryGetValue(diskInfo, CfUtil.getCFString("DAVolumeName"));
                                    name = volumePtr == null ? type : CfUtil.cfPointerToString(volumePtr);
                                    CfUtil.release(diskInfo);
                                }
                                CfUtil.release(disk);
                            }
                            String mountPoint = logicalVolumeMap.containsKey(partBsdName) ? "Logical Volume: " + logicalVolumeMap.get(partBsdName) : MapUtil.getOrDefault(mountPointMap, partBsdName, "");
                            partitions.add(new HWPartition(partBsdName, name, type, IOKitUtil.getIORegistryStringProperty(sdService, "UUID"), IOKitUtil.getIORegistryLongProperty(sdService, "Size"), IOKitUtil.getIORegistryIntProperty(sdService, "BSD Major"), IOKitUtil.getIORegistryIntProperty(sdService, "BSD Minor"), mountPoint));
                            IOKit.INSTANCE.IOObjectRelease(sdService);
                            sdService = IOKit.INSTANCE.IOIteratorNext(serviceIterator.getValue());
                        }
                        IOKit.INSTANCE.IOObjectRelease(serviceIterator.getValue());
                    } else {
                        LOG.error("Unable to find properties for {}", (Object)bsdName);
                    }
                    Collections.sort(partitions);
                    diskStore.setPartitions(partitions.toArray(new HWPartition[partitions.size()]));
                    IOKit.INSTANCE.IOObjectRelease(parent.getValue());
                } else {
                    LOG.error("Unable to find IOMedia device or parent for {}", (Object)bsdName);
                }
                IOKit.INSTANCE.IOObjectRelease(drive);
            }
            IOKit.INSTANCE.IOObjectRelease(driveList.getValue());
            return true;
        }
        return false;
    }

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        DiskArbitration.DASessionRef session = DiskArbitration.INSTANCE.DASessionCreate(CfUtil.ALLOCATOR);
        if (session == null) {
            LOG.error("Unable to open session to DiskArbitration framework.");
            return false;
        }
        boolean diskFound = MacDisks.updateDiskStats(diskStore, session);
        CfUtil.release(session);
        return diskFound;
    }

    @Override
    public HWDiskStore[] getDisks() {
        mountPointMap.clear();
        logicalVolumeMap.clear();
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        int numfs = SystemB.INSTANCE.getfsstat64(null, 0, 0);
        SystemB.Statfs[] fs = new SystemB.Statfs[numfs];
        SystemB.INSTANCE.getfsstat64(fs, numfs * new SystemB.Statfs().size(), 16);
        for (SystemB.Statfs f : fs) {
            String mntFrom = new String(f.f_mntfromname).trim();
            mountPointMap.put(mntFrom.replace("/dev/", ""), new String(f.f_mntonname).trim());
        }
        HashSet<String> physicalVolumes = new HashSet<String>();
        boolean logicalVolume = false;
        for (String line : ExecutingCommand.runNative("diskutil cs list")) {
            if (line.contains("Logical Volume Group")) {
                physicalVolumes.clear();
                logicalVolume = false;
                continue;
            }
            if (line.contains("Logical Volume Family")) {
                logicalVolume = true;
                continue;
            }
            if (!line.contains("Disk:")) continue;
            String volume = ParseUtil.parseLastString(line);
            if (logicalVolume) {
                for (String pv : physicalVolumes) {
                    logicalVolumeMap.put(pv, volume);
                }
                physicalVolumes.clear();
                continue;
            }
            physicalVolumes.add(ParseUtil.parseLastString(line));
        }
        DiskArbitration.DASessionRef session = DiskArbitration.INSTANCE.DASessionCreate(CfUtil.ALLOCATOR);
        if (session == null) {
            LOG.error("Unable to open session to DiskArbitration framework.");
            return new HWDiskStore[0];
        }
        ArrayList<String> bsdNames = new ArrayList<String>();
        IntByReference iter = new IntByReference();
        IOKitUtil.getMatchingServices("IOMedia", iter);
        int media = IOKit.INSTANCE.IOIteratorNext(iter.getValue());
        while (media != 0) {
            if (IOKitUtil.getIORegistryBooleanProperty(media, "Whole")) {
                DiskArbitration.DADiskRef disk = DiskArbitration.INSTANCE.DADiskCreateFromIOMedia(CfUtil.ALLOCATOR, session, media);
                bsdNames.add(DiskArbitration.INSTANCE.DADiskGetBSDName(disk));
            }
            IOKit.INSTANCE.IOObjectRelease(media);
            media = IOKit.INSTANCE.IOIteratorNext(iter.getValue());
        }
        for (String bsdName : bsdNames) {
            String model = "";
            String serial = "";
            long size = 0L;
            String path = "/dev/" + bsdName;
            DiskArbitration.DADiskRef disk = DiskArbitration.INSTANCE.DADiskCreateFromBSDName(CfUtil.ALLOCATOR, session, path);
            if (disk == null) continue;
            CoreFoundation.CFDictionaryRef diskInfo = DiskArbitration.INSTANCE.DADiskCopyDescription(disk);
            if (diskInfo != null) {
                Pointer modelPtr = CoreFoundation.INSTANCE.CFDictionaryGetValue(diskInfo, CfUtil.getCFString("DADeviceModel"));
                model = CfUtil.cfPointerToString(modelPtr);
                Pointer sizePtr = CoreFoundation.INSTANCE.CFDictionaryGetValue(diskInfo, CfUtil.getCFString("DAMediaSize"));
                size = CfUtil.cfPointerToLong(sizePtr);
                CfUtil.release(diskInfo);
                if (!"Disk Image".equals(model)) {
                    CoreFoundation.CFStringRef modelNameRef = CoreFoundation.CFStringRef.toCFString(model);
                    CoreFoundation.CFMutableDictionaryRef propertyDict = CoreFoundation.INSTANCE.CFDictionaryCreateMutable(CfUtil.ALLOCATOR, 0, null, null);
                    CoreFoundation.INSTANCE.CFDictionarySetValue(propertyDict, CfUtil.getCFString("Model"), modelNameRef);
                    CoreFoundation.CFMutableDictionaryRef matchingDict = CoreFoundation.INSTANCE.CFDictionaryCreateMutable(CfUtil.ALLOCATOR, 0, null, null);
                    CoreFoundation.INSTANCE.CFDictionarySetValue(matchingDict, CfUtil.getCFString("IOPropertyMatch"), propertyDict);
                    IntByReference serviceIterator = new IntByReference();
                    IOKitUtil.getMatchingServices(matchingDict, serviceIterator);
                    CfUtil.release(modelNameRef);
                    CfUtil.release(propertyDict);
                    int sdService = IOKit.INSTANCE.IOIteratorNext(serviceIterator.getValue());
                    while (sdService != 0) {
                        serial = IOKitUtil.getIORegistryStringProperty(sdService, "Serial Number");
                        IOKit.INSTANCE.IOObjectRelease(sdService);
                        if (serial != null) break;
                        sdService = IOKit.INSTANCE.IOIteratorNext(serviceIterator.getValue());
                    }
                    if (serial == null) {
                        serial = "";
                    }
                    IOKit.INSTANCE.IOObjectRelease(serviceIterator.getValue());
                }
            }
            CfUtil.release(disk);
            if (size <= 0L) continue;
            HWDiskStore diskStore = new HWDiskStore(bsdName, model.trim(), serial.trim(), size, 0L, 0L, 0L, 0L, 0L, new HWPartition[0], 0L);
            MacDisks.updateDiskStats(diskStore, session);
            result.add(diskStore);
        }
        CfUtil.release(session);
        Collections.sort(result);
        return result.toArray(new HWDiskStore[result.size()]);
    }
}

