/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.notifications.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CommonImages {
    private static final URL baseUrl;
    private static ImageRegistry imageRegistry;
    private static final String T_EVIEW = "eview16";
    public static final ImageDescriptor NOTIFICATION_CLOSE;
    public static final ImageDescriptor NOTIFICATION_CLOSE_HOVER;

    static {
        Bundle bundle = null;
        if (Platform.isRunning()) {
            bundle = FrameworkUtil.getBundle(CommonImages.class);
        }
        if (bundle != null) {
            baseUrl = bundle.getEntry("/icons/");
        } else {
            URL iconsUrl = null;
            try {
                iconsUrl = new URL(CommonImages.class.getResource("CommonImages.class"), "../../../../../../icons/");
            }
            catch (MalformedURLException malformedURLException) {}
            baseUrl = iconsUrl;
        }
        NOTIFICATION_CLOSE = CommonImages.create(T_EVIEW, "notification-close.png");
        NOTIFICATION_CLOSE_HOVER = CommonImages.create(T_EVIEW, "notification-close-active.png");
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)CommonImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = CommonImages.getImageRegistry();
        Image image = imageRegistry.get(Integer.toString(imageDescriptor.hashCode()));
        if (image == null) {
            image = imageDescriptor.createImage(true);
            imageRegistry.put(Integer.toString(imageDescriptor.hashCode()), image);
        }
        return image;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseUrl == null) {
            throw new MalformedURLException();
        }
        StringBuilder buffer = new StringBuilder(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseUrl, buffer.toString());
    }
}

