/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation.handlers;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.presentation.handlers.AbstractDropdownHandler;
import org.eclipse.oomph.setup.ui.SetupEditorSupport;
import org.eclipse.oomph.setup.ui.SetupLabelProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenEditorDropdownHandler
extends AbstractDropdownHandler {
    public static final String COMMAND_ID = "org.eclipse.oomph.setup.editor.openEditorDropdown";

    public OpenEditorDropdownHandler() {
        super(COMMAND_ID);
    }

    protected AbstractDropdownHandler.ActionDescriptor createActionDescriptor() throws Exception {
        final User user = SetupFactory.eINSTANCE.createUser();
        ((InternalEObject)user).eSetProxyURI(SetupContext.USER_SETUP_URI.appendFragment("/"));
        ComposedAdapterFactory adapterFactory = BaseEditUtil.createAdapterFactory();
        ItemProviderAdapter itemProvider = (ItemProviderAdapter)adapterFactory.adapt((Notifier)user, IItemLabelProvider.class);
        ImageDescriptor imageDescriptor = SetupLabelProvider.getImageDescriptor((ItemProviderAdapter)itemProvider, (EObject)user);
        String text = OpenEditorDropdownHandler.getLabelText(itemProvider, (EObject)user, true);
        Runnable runnable = new Runnable(){

            public void run() {
                OpenEditorDropdownHandler.openEditor((EObject)user);
            }
        };
        return new AbstractDropdownHandler.ActionDescriptor(imageDescriptor, text, runnable);
    }

    public static String getLabelText(ItemProviderAdapter itemProvider, EObject object, boolean qualified) {
        String itemLabel = SetupLabelProvider.getText((ItemProviderAdapter)itemProvider, (EObject)object);
        return qualified ? "Open " + itemLabel : itemLabel;
    }

    public static void openEditor(EObject object) {
        URI uri = EcoreUtil.getURI((EObject)object);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            SetupEditorSupport.getEditor((IWorkbenchPage)page, (URI)uri, (boolean)true, (SetupEditorSupport.LoadHandler[])new SetupEditorSupport.LoadHandler[0]);
        }
    }
}

