/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.recorder;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.util.PreferencesRecorder;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.recorder.RecorderPoliciesDialog;
import org.eclipse.oomph.setup.ui.recorder.RecorderPreferencePage;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecorderManager {
    public static final RecorderManager INSTANCE = new RecorderManager();
    private static final IPersistentPreferenceStore SETUP_UI_PREFERENCES = (IPersistentPreferenceStore)SetupUIPlugin.INSTANCE.getPreferenceStore();
    private static ToolItem toolItem;
    private final DisplayListener displayListener = new DisplayListener();
    private Display display;
    private PreferencesRecorder recorder;

    private RecorderManager() {
    }

    public boolean isRecorderEnabled() {
        String value = SETUP_UI_PREFERENCES.getString("enable.preference.recorder");
        if (StringUtil.isEmpty((String)value)) {
            ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
            SetupContext setupContext = SetupContext.createUserOnly((ResourceSet)resourceSet);
            User user = setupContext.getUser();
            boolean enabled = user.isPreferenceRecorderDefault();
            this.doSetRecorderEnabled(enabled);
            return enabled;
        }
        return Boolean.parseBoolean(value);
    }

    public void setRecorderEnabled(boolean enabled) {
        if (this.isRecorderEnabled() != enabled) {
            try {
                this.doSetRecorderEnabled(enabled);
            }
            finally {
                if (enabled) {
                    if (this.recorder == null) {
                        this.recorder = new PreferencesRecorder();
                    }
                } else if (this.recorder != null) {
                    this.recorder.done();
                    this.recorder = null;
                }
            }
        }
    }

    private void doSetRecorderEnabled(boolean enabled) {
        SETUP_UI_PREFERENCES.setValue("enable.preference.recorder", Boolean.toString(enabled));
        try {
            SETUP_UI_PREFERENCES.save();
        }
        catch (IOException ex) {
            SetupUIPlugin.INSTANCE.log(ex);
        }
    }

    private void handleRecording(final Shell shell, final Map<URI, String> values) {
        final RecorderTransaction transaction = RecorderTransaction.open();
        try {
            Iterator<URI> it = values.keySet().iterator();
            while (it.hasNext()) {
                URI uri = it.next();
                String path = PreferencesFactory.eINSTANCE.convertURI(uri);
                Boolean policy = transaction.getPolicy(path);
                if (policy == null) {
                    transaction.setPolicy(path, true);
                    continue;
                }
                if (policy.booleanValue()) continue;
                it.remove();
            }
            if (transaction.isDirty()) {
                final boolean[] exitEarly = new boolean[1];
                UIUtil.syncExec((Display)this.display, (Runnable)new Runnable(){

                    public void run() {
                        RecorderPoliciesDialog reviewDialog = new RecorderPoliciesDialog(shell, transaction, values);
                        int result = reviewDialog.open();
                        if (!reviewDialog.isEnablePreferenceRecorder()) {
                            RecorderManager.this.setRecorderEnabled(false);
                            exitEarly[0] = true;
                        } else if (result != 0) {
                            exitEarly[0] = true;
                        }
                    }
                });
                if (exitEarly[0]) {
                    return;
                }
            }
            transaction.setPreferences(values);
            transaction.commit();
        }
        finally {
            transaction.close();
        }
    }

    private static boolean isPreferenceDialog(Shell shell) {
        Object data = shell.getData();
        return data instanceof WorkbenchPreferenceDialog;
    }

    private static void hookRecorderCheckbox(Shell shell) {
        try {
            Control child;
            Composite buttonBar;
            Control[] children;
            WorkbenchPreferenceDialog dialog = (WorkbenchPreferenceDialog)shell.getData();
            if (dialog.buttonBar instanceof Composite && (children = (buttonBar = (Composite)dialog.buttonBar).getChildren()).length != 0 && (child = children[0]) instanceof ToolBar) {
                ToolBar toolBar = (ToolBar)child;
                toolItem = new ToolItem(toolBar, 8);
                RecorderManager.updateRecorderCheckboxState();
                toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean recorderEnabled = INSTANCE.isRecorderEnabled();
                        INSTANCE.setRecorderEnabled(!recorderEnabled);
                        RecorderManager.updateRecorderCheckboxState();
                        RecorderPreferencePage.updateEnablement();
                    }
                });
                toolItem.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        RecorderManager.toolItem = null;
                    }
                });
                buttonBar.layout();
            }
        }
        catch (Throwable throwable) {}
    }

    static void updateRecorderCheckboxState() {
        if (toolItem != null) {
            boolean recorderEnabled = INSTANCE.isRecorderEnabled();
            String state = recorderEnabled ? "enabled" : "disabled";
            String verb = !recorderEnabled ? "enable" : "disable";
            toolItem.setImage(SetupUIPlugin.INSTANCE.getSWTImage("recorder_" + state));
            toolItem.setToolTipText("Oomph preference recorder " + state + " - Push to " + verb);
        }
    }

    private final class DisplayListener
    implements Listener {
        private boolean stopped;

        private DisplayListener() {
        }

        public void stop() {
            this.stopped = true;
        }

        public void handleEvent(Event event) {
            Shell shell;
            if (this.stopped) {
                return;
            }
            if (event.widget instanceof Shell && RecorderManager.isPreferenceDialog(shell = (Shell)event.widget) && toolItem == null) {
                UIUtil.asyncExec((Display)RecorderManager.this.display, (Runnable)new Runnable(){

                    public void run() {
                        RecorderManager.hookRecorderCheckbox(shell);
                    }
                });
                if (RecorderManager.this.isRecorderEnabled()) {
                    RecorderManager.this.recorder = new PreferencesRecorder();
                }
                shell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (RecorderManager.this.recorder == null) {
                            return;
                        }
                        final Map values = RecorderManager.this.recorder.done();
                        RecorderManager.this.recorder = null;
                        Iterator it = values.keySet().iterator();
                        while (it.hasNext()) {
                            URI uri = (URI)it.next();
                            String pluginID = uri.segment(0);
                            if (!SetupUIPlugin.PLUGIN_ID.equals(pluginID) || !"enable.preference.recorder".equals(uri.lastSegment())) continue;
                            it.remove();
                        }
                        if (values.isEmpty()) {
                            RecorderTransaction transaction = RecorderTransaction.getInstance();
                            if (transaction != null) {
                                transaction.close();
                            }
                        } else {
                            Job job = new Job("Store preferences"){

                                protected IStatus run(IProgressMonitor monitor) {
                                    RecorderManager.this.handleRecording(shell, values);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setSystem(true);
                            job.schedule();
                        }
                    }
                });
            }
        }
    }

    public static class Lifecycle {
        public static void start(Display display) {
            INSTANCE.display = display;
            display.addListener(45, (Listener)INSTANCE.displayListener);
        }

        public static void stop() {
            INSTANCE.displayListener.stop();
            if (INSTANCE.display != null) {
                UIUtil.asyncExec((Display)INSTANCE.display, (Runnable)new Runnable(){

                    public void run() {
                        if (!INSTANCE.display.isDisposed()) {
                            INSTANCE.display.removeListener(45, (Listener)INSTANCE.displayListener);
                        }
                    }
                });
            }
        }
    }
}

