/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.impl;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.util.ObjectUtil;

public class PreferenceTaskImpl
extends SetupTaskImpl
implements PreferenceTask {
    protected static final String KEY_EDEFAULT = null;
    protected String key = KEY_EDEFAULT;
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    private transient PreferencesUtil.PreferenceProperty preferenceProperty;

    protected PreferenceTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupPackage.Literals.PREFERENCE_TASK;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String newKey) {
        String oldKey = this.key;
        this.key = newKey;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldKey, (Object)this.key));
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldValue, (Object)this.value));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getKey();
            }
            case 10: {
                return this.getValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setKey((String)newValue);
                return;
            }
            case 10: {
                this.setValue((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setKey(KEY_EDEFAULT);
                return;
            }
            case 10: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return KEY_EDEFAULT == null ? this.key != null : !KEY_EDEFAULT.equals(this.key);
            }
            case 10: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (key: ");
        result.append(this.key);
        result.append(", value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public int getPriority() {
        String key = this.getKey();
        return key != null && key.startsWith("/project") ? 600 : 400;
    }

    public Object getOverrideToken() {
        String key = this.getKey();
        if (key == null) {
            return super.getOverrideToken();
        }
        return this.createToken(new Path(key).makeAbsolute().toString());
    }

    public int getProgressMonitorWork() {
        return 0;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        this.preferenceProperty = new PreferencesUtil.PreferenceProperty(this.key);
        String oldValue = this.preferenceProperty.get(null);
        return !ObjectUtil.equals((Object)this.getValue(), (Object)oldValue);
    }

    public void perform(SetupTaskContext context) throws Exception {
        String key = this.getKey();
        URI uri = PreferencesFactory.eINSTANCE.createURI(key);
        if ("project".equals(uri.authority()) && !ResourcesPlugin.getWorkspace().getRoot().getProject(URI.decode((String)uri.segment(0))).isAccessible()) {
            context.log("Ignoring preference " + key + " = " + this.value);
            return;
        }
        final String value = this.getValue();
        if (value != null && value.indexOf(10) != -1) {
            context.log(value);
        }
        this.performUI(context, new SetupTaskImpl.RunnableWithContext(){

            public void run(SetupTaskContext context) throws Exception {
                PreferenceTaskImpl.this.preferenceProperty.set(value);
            }
        });
        this.preferenceProperty.getNode().flush();
    }
}

