/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ListValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;

public class CPTypeAnchorAttribute
extends ListValueAttribute {
    private List<TypeAnchor> anchors = new LinkedList<TypeAnchor>();

    public CPTypeAnchorAttribute() {
        super(CLASS_INFO_ANCHORS, 0, 4);
    }

    public CPTypeAnchorAttribute(ClassFileStruct reader, int readOffset, int[] constantPoolOffsets) {
        super(IOTConstants.CLASS_INFO_ANCHORS, 0, 4);
        this.readList(reader, readOffset, 0, constantPoolOffsets);
    }

    public void addTypeAnchor(ITeamAnchor bestName, int cpIndex) {
        this.anchors.add(new TypeAnchor(cpIndex, bestName.internalName()));
        ++this._count;
    }

    void writeElementValue(int i) {
        TypeAnchor ta = this.anchors.get(i);
        this.writeUnsignedShort(ta.idx);
        this.writeName(ta.path);
    }

    void read(int i) {
        int idx = this.consumeShort();
        char[] name = this.consumeName();
        this.anchors.add(new TypeAnchor(idx, name));
    }

    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        this.checkBindingMismatch(binding, 0);
        if (binding instanceof ReferenceBinding) {
            ReferenceBinding refBinding = (ReferenceBinding)binding;
            refBinding.model.setTypeAnchors(this);
        }
    }

    public char[] getPath(int cpIndex) {
        for (TypeAnchor anchor : this.anchors) {
            if (anchor.idx != cpIndex) continue;
            return anchor.path;
        }
        return null;
    }

    String toString(int i) {
        TypeAnchor ta = this.anchors.get(i);
        return String.valueOf(91 + ta.idx + 93) + new String(ta.path);
    }

    private class TypeAnchor {
        char[] path;
        int idx;

        TypeAnchor(int idx, char[] path) {
            this.path = path;
            this.idx = idx;
        }
    }
}

