/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.conflation;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.conflation.AbstractEventConflater;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;

public class VisualChangeEventConflater
extends AbstractEventConflater {
    private final NatTable natTable;
    private volatile AtomicBoolean running = new AtomicBoolean(false);

    public VisualChangeEventConflater(NatTable ownerLayer) {
        this.natTable = ownerLayer;
    }

    @Override
    public void addEvent(ILayerEvent event) {
        if (event instanceof IVisualChangeEvent) {
            super.addEvent(event);
        }
    }

    @Override
    public Runnable getConflaterTask() {
        return () -> {
            if (!this.queue.isEmpty() && this.running.compareAndSet(false, true)) {
                this.clearQueue();
                this.natTable.getDisplay().asyncExec(() -> {
                    this.natTable.updateResize();
                    this.running.set(false);
                });
            }
        };
    }
}

