/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.sort.painter;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

public class SortIconPainter
extends ImagePainter {
    private Image upImage0;
    private Image upImage1;
    private Image upImage2;
    private Image downImage0;
    private Image downImage1;
    private Image downImage2;

    public SortIconPainter() {
        this(true);
    }

    public SortIconPainter(boolean paintBg) {
        this(paintBg, false);
    }

    public SortIconPainter(boolean paintBg, boolean invertIcons) {
        super(null, paintBg);
        String postFix = "";
        if (invertIcons) {
            postFix = "_inv";
        }
        this.upImage0 = GUIHelper.getImage("up_0" + postFix);
        this.upImage1 = GUIHelper.getImage("up_1" + postFix);
        this.upImage2 = GUIHelper.getImage("up_2" + postFix);
        this.downImage0 = GUIHelper.getImage("down_0" + postFix);
        this.downImage1 = GUIHelper.getImage("down_1" + postFix);
        this.downImage2 = GUIHelper.getImage("down_2" + postFix);
    }

    @Override
    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        Image icon = null;
        if (this.isSortedAscending(cell)) {
            icon = this.selectUpImage(this.getSortSequence(cell));
        } else if (this.isSortedDescending(cell)) {
            icon = this.selectDownImage(this.getSortSequence(cell));
        }
        return icon;
    }

    private boolean isSortedAscending(ILayerCell cell) {
        return cell.getConfigLabels().hasLabel("SORT_UP");
    }

    private boolean isSortedDescending(ILayerCell cell) {
        return cell.getConfigLabels().hasLabel("SORT_DOWN");
    }

    private int getSortSequence(ILayerCell cell) {
        int sortSeq = 0;
        for (String configLabel : cell.getConfigLabels()) {
            if (!configLabel.startsWith("SORT_SEQ_")) continue;
            String[] tokens = configLabel.split("_");
            sortSeq = Integer.parseInt(tokens[tokens.length - 1]);
        }
        return sortSeq;
    }

    protected Image selectUpImage(int sortSequence) {
        switch (sortSequence) {
            case 0: {
                return this.upImage0;
            }
            case 1: {
                return this.upImage1;
            }
            case 2: {
                return this.upImage2;
            }
        }
        return this.upImage2;
    }

    protected Image selectDownImage(int sortSequence) {
        switch (sortSequence) {
            case 0: {
                return this.downImage0;
            }
            case 1: {
                return this.downImage1;
            }
            case 2: {
                return this.downImage2;
            }
        }
        return this.downImage2;
    }

    public void setSortImages(Image upImage0, Image upImage1, Image upImage2, Image downImage0, Image downImage1, Image downImage2) {
        this.upImage0 = upImage0;
        this.upImage1 = upImage1;
        this.upImage2 = upImage2;
        this.downImage0 = downImage0;
        this.downImage1 = downImage1;
        this.downImage2 = downImage2;
    }
}

