/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze.event;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class FreezeEventHandler
implements ILayerEventHandler<IStructuralChangeEvent> {
    private final FreezeLayer freezeLayer;

    public FreezeEventHandler(FreezeLayer freezeLayer) {
        this.freezeLayer = freezeLayer;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        Collection<StructuralDiff> rowDiffs;
        PositionCoordinate topLeftPosition = this.freezeLayer.getTopLeftPosition();
        PositionCoordinate bottomRightPosition = this.freezeLayer.getBottomRightPosition();
        Collection<StructuralDiff> columnDiffs = event.getColumnDiffs();
        if (columnDiffs != null) {
            int leftOffset = 0;
            int rightOffset = 0;
            for (StructuralDiff columnDiff : columnDiffs) {
                StructuralDiff.DiffTypeEnum diffType = columnDiff.getDiffType();
                if (diffType == StructuralDiff.DiffTypeEnum.ADD) {
                    Range afterPositionRange = columnDiff.getAfterPositionRange();
                    if (afterPositionRange.start < topLeftPosition.columnPosition) {
                        leftOffset += afterPositionRange.size();
                    }
                    if (afterPositionRange.start > bottomRightPosition.columnPosition) continue;
                    rightOffset += afterPositionRange.size();
                    continue;
                }
                if (diffType != StructuralDiff.DiffTypeEnum.DELETE) continue;
                Range beforePositionRange = columnDiff.getBeforePositionRange();
                if (beforePositionRange.start < topLeftPosition.columnPosition) {
                    leftOffset -= Math.min(beforePositionRange.end, topLeftPosition.columnPosition + 1) - beforePositionRange.start;
                }
                if (beforePositionRange.start > bottomRightPosition.columnPosition) continue;
                rightOffset -= Math.min(beforePositionRange.end, bottomRightPosition.columnPosition + 1) - beforePositionRange.start;
            }
            topLeftPosition.columnPosition += leftOffset;
            bottomRightPosition.columnPosition += rightOffset;
        }
        if ((rowDiffs = event.getRowDiffs()) != null) {
            int leftOffset = 0;
            int rightOffset = 0;
            for (StructuralDiff rowDiff : rowDiffs) {
                StructuralDiff.DiffTypeEnum diffType = rowDiff.getDiffType();
                if (diffType == StructuralDiff.DiffTypeEnum.ADD) {
                    Range afterPositionRange = rowDiff.getAfterPositionRange();
                    if (afterPositionRange.start < topLeftPosition.rowPosition) {
                        leftOffset += afterPositionRange.size();
                    }
                    if (afterPositionRange.start > bottomRightPosition.rowPosition) continue;
                    rightOffset += afterPositionRange.size();
                    continue;
                }
                if (diffType != StructuralDiff.DiffTypeEnum.DELETE) continue;
                Range beforePositionRange = rowDiff.getBeforePositionRange();
                if (beforePositionRange.start < topLeftPosition.rowPosition) {
                    leftOffset -= Math.min(beforePositionRange.end, topLeftPosition.rowPosition + 1) - beforePositionRange.start;
                }
                if (beforePositionRange.start > bottomRightPosition.rowPosition) continue;
                rightOffset -= Math.min(beforePositionRange.end, bottomRightPosition.rowPosition + 1) - beforePositionRange.start;
            }
            topLeftPosition.rowPosition += leftOffset;
            bottomRightPosition.rowPosition += rightOffset;
        }
    }
}

