/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public abstract class AbstractMultiColumnCommand
implements ILayerCommand {
    protected Collection<ColumnPositionCoordinate> columnPositionCoordinates;

    protected AbstractMultiColumnCommand(ILayer layer, int ... columnPositions) {
        this.setColumnPositions(layer, columnPositions);
    }

    protected AbstractMultiColumnCommand(AbstractMultiColumnCommand command) {
        this.columnPositionCoordinates = new HashSet<ColumnPositionCoordinate>(command.columnPositionCoordinates);
    }

    public Collection<Integer> getColumnPositions() {
        return this.columnPositionCoordinates.stream().map(ColumnPositionCoordinate::getColumnPosition).collect(Collectors.toCollection(HashSet::new));
    }

    public int[] getColumnPositionsArray() {
        return this.columnPositionCoordinates.stream().mapToInt(ColumnPositionCoordinate::getColumnPosition).sorted().toArray();
    }

    protected final void setColumnPositions(ILayer layer, int ... columnPositions) {
        this.columnPositionCoordinates = new HashSet<ColumnPositionCoordinate>();
        int[] nArray = columnPositions;
        int n = columnPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int columnPosition = nArray[n2];
            this.columnPositionCoordinates.add(new ColumnPositionCoordinate(layer, columnPosition));
            ++n2;
        }
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        Collection converted = this.columnPositionCoordinates.stream().map(coord -> LayerCommandUtil.convertColumnPositionToTargetContext(coord, targetLayer)).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
        if (!converted.isEmpty()) {
            this.columnPositionCoordinates = converted;
            return true;
        }
        return false;
    }
}

