/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MiddlePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtimperative.MiddlePropertyCallExp;
import org.eclipse.qvtd.pivot.qvtimperative.VariablePredicate;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitorDecorator;

public abstract class QVTiAbstractTracingEvaluationVisitor
extends QVTiEvaluationVisitorDecorator {
    protected static Logger logger = Logger.getLogger((String)"QVTiTrace");
    protected static final String DEFAULT_INDENT = "  ";
    static int VERBOSE_LEVEL_LOW = 0;
    static int VERBOSE_LEVEL_MED = 1;
    static int VERBOSE_LEVEL_HIGH = 2;
    protected static int verboseLevel = VERBOSE_LEVEL_LOW;
    private int indentLevel = 0;

    public QVTiAbstractTracingEvaluationVisitor(@NonNull QVTiEvaluationVisitor decorated) {
        this(decorated, 0);
        if (logger.getAppender("QVTTrace") == null) {
            FileAppender appender = new FileAppender();
            appender.setFile("QVTTrace.log");
            appender.setName("QVTTrace");
            appender.setLayout((Layout)new PatternLayout("%m%n"));
            appender.setAppend(false);
            appender.activateOptions();
            logger.addAppender((Appender)appender);
        }
        logger.setAdditivity(false);
        logger.setLevel(Level.DEBUG);
    }

    protected QVTiAbstractTracingEvaluationVisitor(@NonNull QVTiEvaluationVisitor decorated, int indentLevel) {
        super(decorated);
        this.indentLevel = indentLevel;
    }

    public int getVerboseLevel() {
        return verboseLevel;
    }

    public void setVerboseLevel(int verboseLevel) {
        QVTiAbstractTracingEvaluationVisitor.verboseLevel = verboseLevel;
    }

    @NonNull
    protected String getIndent() {
        StringBuilder outputBuffer = new StringBuilder(this.indentLevel);
        int i = 0;
        while (i < this.indentLevel) {
            outputBuffer.append(DEFAULT_INDENT);
            ++i;
        }
        String string = outputBuffer.toString();
        return string;
    }

    @NonNull
    public Pattern getRegexPattern(@NonNull String regex) {
        return ((QVTiEvaluationVisitor)this.delegate).getRegexPattern(regex);
    }

    @NonNull
    protected String safePrint(@Nullable Element element) {
        return element != null ? PrettyPrinter.print((Element)element) : "null";
    }

    @Nullable
    public Object visitAssignment(@NonNull Assignment assignment) {
        ++this.indentLevel;
        try {
            Object value = this.safeVisit((Visitable)assignment.getValue());
            value = ((QVTiEvaluationVisitor)this.delegate).getMetaModelManager().getIdResolver().unboxedValueOf(value);
            logger.info((Object)(String.valueOf(this.getIndent()) + "VisitAssignment " + this.prettyPrint(assignment.getETarget()) + " := " + this.prettyPrint(value)));
        }
        catch (InvalidValueException ex) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "VisitAssignment " + this.prettyPrint(assignment.getETarget()) + " := Invalid expression"));
        }
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitAssignment(assignment);
        --this.indentLevel;
        return result;
    }

    @Nullable
    public Object visitCoreDomain(@NonNull CoreDomain coreDomain) {
        logger.info((Object)(String.valueOf(this.getIndent()) + "CoreDomain " + coreDomain.getName()));
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitCoreDomain(coreDomain);
        --this.indentLevel;
        return result;
    }

    @Nullable
    public Object visitGuardPattern(@NonNull GuardPattern guardPattern) {
        if (guardPattern.getArea() instanceof CoreDomain) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "Visiting CoreDomain GuardPattern"));
        }
        if (guardPattern.getArea() instanceof Mapping) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "Visiting Mapping GuardPattern"));
        }
        ++this.indentLevel;
        ArrayList<Variable> nullVars = new ArrayList<Variable>();
        for (Variable v : guardPattern.getVariable()) {
            if (((QVTiEvaluationVisitor)this.delegate).getEvaluationEnvironment().getValueOf((DomainTypedElement)v) == null) {
                nullVars.add(v);
                OCLExpression initExp = v.getInitExpression();
                if (initExp == null) continue;
                ++this.indentLevel;
                logger.info((Object)(String.valueOf(this.getIndent()) + "Variable " + v.getName() + " init value:" + this.safePrint((Element)initExp)));
                --this.indentLevel;
                continue;
            }
            logger.info((Object)(String.valueOf(this.getIndent()) + "Variable " + v.getName() + ": " + this.prettyPrint(((QVTiEvaluationVisitor)this.delegate).getEvaluationEnvironment().getValueOf((DomainTypedElement)v))));
        }
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitGuardPattern(guardPattern);
        if (result == Boolean.TRUE) {
            for (Variable v : nullVars) {
                logger.info((Object)(String.valueOf(this.getIndent()) + "Variable " + v.getName() + ": " + this.prettyPrint(((QVTiEvaluationVisitor)this.delegate).getEvaluationEnvironment().getValueOf((DomainTypedElement)v))));
            }
        }
        if (guardPattern.getPredicate().size() == 0) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "GuardPattern has no predicates."));
        } else {
            logger.info((Object)(String.valueOf(this.getIndent()) + "GuardPattern result: " + result));
        }
        --this.indentLevel;
        return result;
    }

    @Nullable
    public Object visitImperativeModel(@NonNull ImperativeModel imperativeModel) {
        return ((QVTiEvaluationVisitor)this.delegate).visitImperativeModel(imperativeModel);
    }

    @Nullable
    public Object visitIteratorExp(@NonNull IteratorExp object) {
        return ((QVTiEvaluationVisitor)this.delegate).visitIteratorExp(object);
    }

    @Nullable
    public Object visitMapping(@NonNull Mapping mapping) {
        logger.info((Object)(String.valueOf(this.getIndent()) + "Mapping " + mapping.getName()));
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitMapping(mapping);
        --this.indentLevel;
        return result;
    }

    @Nullable
    public Object visitMappingCall(@NonNull MappingCall mappingCall) {
        logger.info((Object)(String.valueOf(this.getIndent()) + "Visiting MappingCall, calling: " + mappingCall.getReferredMapping().getName()));
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitMappingCall(mappingCall);
        --this.indentLevel;
        return result;
    }

    public Object visitMiddlePropertyAssignment(@NonNull MiddlePropertyAssignment propertyAssignment) {
        ++this.indentLevel;
        try {
            Object value = this.safeVisit((Visitable)propertyAssignment.getValue());
            value = ((QVTiEvaluationVisitor)this.delegate).getMetaModelManager().getIdResolver().unboxedValueOf(value);
            logger.info((Object)(String.valueOf(this.getIndent()) + "VisitMiddlePropertyAssignment " + propertyAssignment.getSlotExpression() + "." + propertyAssignment.getTargetProperty().getName() + " = " + this.prettyPrint(value)));
        }
        catch (InvalidValueException ex) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "VisitMiddlePropertyAssignment " + propertyAssignment.getSlotExpression() + "." + propertyAssignment.getTargetProperty().getName() + " = InvalidValue"));
        }
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitMiddlePropertyAssignment(propertyAssignment);
        --this.indentLevel;
        return result;
    }

    public Object visitMiddlePropertyCallExp(@NonNull MiddlePropertyCallExp callExp) {
        return ((QVTiEvaluationVisitor)this.delegate).visitMiddlePropertyCallExp(callExp);
    }

    @Nullable
    public Object visitPropertyAssignment(@NonNull PropertyAssignment propertyAssignment) {
        try {
            Object value = this.safeVisit((Visitable)propertyAssignment.getValue());
            value = ((QVTiEvaluationVisitor)this.delegate).getMetaModelManager().getIdResolver().unboxedValueOf(value);
            logger.info((Object)(String.valueOf(this.getIndent()) + "VisitPropertyAssignment " + propertyAssignment.getSlotExpression() + "." + propertyAssignment.getTargetProperty().getName() + " = " + this.prettyPrint(value)));
        }
        catch (InvalidValueException ex) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "VisitPropertyAssignment " + propertyAssignment.getSlotExpression() + "." + propertyAssignment.getTargetProperty().getName() + " = InvalidValueException"));
        }
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitPropertyAssignment(propertyAssignment);
        return result;
    }

    @Nullable
    public Object visitTransformation(@NonNull Transformation transformation) {
        logger.info((Object)("---- Transformation " + transformation.getName() + " ----"));
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitTransformation(transformation);
        --this.indentLevel;
        logger.info((Object)"---- Transformation End ----");
        return result;
    }

    @Nullable
    public Object visitPredicate(@NonNull Predicate predicate) {
        OCLExpression exp = predicate.getConditionExpression();
        Object value = this.safeVisit((Visitable)exp);
        logger.info((Object)(String.valueOf(this.getIndent()) + "Predicate " + this.safePrint((Element)exp) + "->" + String.valueOf(value)));
        return ((QVTiEvaluationVisitor)this.delegate).visitPredicate(predicate);
    }

    @Nullable
    public Object visitVariableAssignment(@NonNull VariableAssignment variableAssignment) {
        Variable v = variableAssignment.getTargetVariable();
        logger.info((Object)(String.valueOf(this.getIndent()) + "VisitVariableAssignment " + v + ": " + ((EvaluationVisitorImpl)this.delegate).safeVisit((Visitable)variableAssignment.getValue())));
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitVariableAssignment(variableAssignment);
        --this.indentLevel;
        return result;
    }

    @Nullable
    public Object visitVariablePredicate(@NonNull VariablePredicate variablePredicate) {
        Variable v = variablePredicate.getTargetVariable();
        logger.info((Object)(String.valueOf(this.getIndent()) + "VisitVariablePredicate " + v + ": " + ((EvaluationVisitorImpl)this.delegate).safeVisit((Visitable)variablePredicate.getConditionExpression())));
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitVariablePredicate(variablePredicate);
        --this.indentLevel;
        return result;
    }

    protected String prettyPrint(Object object) {
        ArrayList<String> lines = new ArrayList<String>();
        if (object instanceof EObject) {
            EObject eo = (EObject)object;
            EClass eClass = eo.eClass();
            lines.add(String.valueOf(eClass.getName()) + " [" + Integer.toHexString(eo.hashCode()) + "] {");
            ++this.indentLevel;
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                Object value = eo.eGet(feature);
                String line = String.valueOf(this.getIndent()) + feature.getName() + " = ";
                if (value instanceof Collection) {
                    int size = ((Collection)value).size();
                    line = size > 0 ? String.valueOf(line) + "[" + ((EObject)((Iterable)value).iterator().next()).eClass().getName() + "] x " + size : String.valueOf(line) + "[ ]";
                } else if (value instanceof EObject) {
                    eClass = ((EObject)value).eClass();
                    line = String.valueOf(line) + eClass.getName() + " [" + Integer.toHexString(value.hashCode()) + "]";
                } else {
                    line = value == null ? String.valueOf(line) + "[ null ]" : String.valueOf(line) + String.valueOf(value);
                }
                lines.add(line);
            }
            lines.add(String.valueOf(this.getIndent()) + "}");
            --this.indentLevel;
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line).append('\n');
            }
            sb.delete(sb.length() - 1, sb.length());
            return sb.toString();
        }
        return String.valueOf(object);
    }

    protected String prettyPrintUnident(Object object) {
        ArrayList<String> lines = new ArrayList<String>();
        if (object instanceof EObject) {
            EObject eo = (EObject)object;
            EClass eClass = eo.eClass();
            lines.add(String.valueOf(eClass.getName()) + " [" + Integer.toHexString(eo.hashCode()) + "] {");
            ++this.indentLevel;
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                Object value = eo.eGet(feature);
                String line = DEFAULT_INDENT + feature.getName() + " = ";
                if (value instanceof Collection) {
                    int size = ((Collection)value).size();
                    line = size > 0 ? String.valueOf(line) + "[" + ((EObject)((Iterable)value).iterator().next()).eClass().getName() + "] x " + size : String.valueOf(line) + "[ ]";
                } else if (value instanceof EObject) {
                    eClass = ((EObject)value).eClass();
                    line = String.valueOf(line) + eClass.getName() + " [" + Integer.toHexString(value.hashCode()) + "]";
                } else {
                    line = value == null ? String.valueOf(line) + "[ null ]" : String.valueOf(line) + String.valueOf(value);
                }
                lines.add(line);
            }
            lines.add("  }");
            --this.indentLevel;
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line).append('\n');
            }
            sb.delete(sb.length() - 1, sb.length());
            return sb.toString();
        }
        return String.valueOf(object);
    }
}

