/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.mdht.uml.cda.tests.DiagnosticOutputHelper;
import org.eclipse.mdht.uml.cda.tests.SystemOutValidationHandler;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.INT;
import org.eclipse.mdht.uml.hl7.datatypes.IVL_INT;
import org.eclipse.mdht.uml.hl7.datatypes.IVXB_INT;

public class IVLINTTest {
    private static boolean diagnosticsHaveErrors(Diagnostic oDiagnostic) {
        return oDiagnostic.getSeverity() != 0;
    }

    private static boolean processDiagnostics(Diagnostic oDiagnostic) {
        boolean bResult = true;
        if (IVLINTTest.diagnosticsHaveErrors(oDiagnostic)) {
            SystemOutValidationHandler oValHandler = new SystemOutValidationHandler();
            DiagnosticOutputHelper.processDiagnostic(oDiagnostic, oValHandler);
            bResult = false;
        }
        return bResult;
    }

    public static boolean testOption1LowOnly() {
        IVL_INT oIvlInt = DatatypesFactory.eINSTANCE.createIVL_INT();
        IVXB_INT oLow = DatatypesFactory.eINSTANCE.createIVXB_INT();
        oIvlInt.setLow(oLow);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlInt);
        return IVLINTTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption1LowWithWidth() {
        IVL_INT oIvlInt = DatatypesFactory.eINSTANCE.createIVL_INT();
        IVXB_INT oLow = DatatypesFactory.eINSTANCE.createIVXB_INT();
        oIvlInt.setLow(oLow);
        INT oWidth = DatatypesFactory.eINSTANCE.createINT();
        oIvlInt.setWidth(oWidth);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlInt);
        return IVLINTTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption1LowWithHigh() {
        IVL_INT oIvlInt = DatatypesFactory.eINSTANCE.createIVL_INT();
        IVXB_INT oLow = DatatypesFactory.eINSTANCE.createIVXB_INT();
        oIvlInt.setLow(oLow);
        IVXB_INT oHigh = DatatypesFactory.eINSTANCE.createIVXB_INT();
        oIvlInt.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlInt);
        return IVLINTTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption1LowWithWidthAndHigh_FailureCase() {
        boolean bResult = true;
        IVL_INT oIvlInt = DatatypesFactory.eINSTANCE.createIVL_INT();
        IVXB_INT oLow = DatatypesFactory.eINSTANCE.createIVXB_INT();
        oIvlInt.setLow(oLow);
        INT oWidth = DatatypesFactory.eINSTANCE.createINT();
        oIvlInt.setWidth(oWidth);
        IVXB_INT oHigh = DatatypesFactory.eINSTANCE.createIVXB_INT();
        oIvlInt.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlInt);
        if (!IVLINTTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testOption2HighOnly() {
        IVL_INT oIvlInt = DatatypesFactory.eINSTANCE.createIVL_INT();
        IVXB_INT oHigh = DatatypesFactory.eINSTANCE.createIVXB_INT();
        oIvlInt.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlInt);
        return IVLINTTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption2HighWithCenter_FailureCase() {
        boolean bResult = true;
        IVL_INT oIvlInt = DatatypesFactory.eINSTANCE.createIVL_INT();
        IVXB_INT oHigh = DatatypesFactory.eINSTANCE.createIVXB_INT();
        oIvlInt.setHigh(oHigh);
        INT oCenter = DatatypesFactory.eINSTANCE.createINT();
        oIvlInt.setCenter(oCenter);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlInt);
        if (!IVLINTTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testOption3WidthOnly() {
        IVL_INT oIvlInt = DatatypesFactory.eINSTANCE.createIVL_INT();
        INT oWidth = DatatypesFactory.eINSTANCE.createINT();
        oIvlInt.setWidth(oWidth);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlInt);
        return IVLINTTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption3WidthAndHigh() {
        IVL_INT oIvlInt = DatatypesFactory.eINSTANCE.createIVL_INT();
        INT oWidth = DatatypesFactory.eINSTANCE.createINT();
        oIvlInt.setWidth(oWidth);
        IVXB_INT oHigh = DatatypesFactory.eINSTANCE.createIVXB_INT();
        oIvlInt.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlInt);
        return IVLINTTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption4CenterOnly() {
        IVL_INT oIvlInt = DatatypesFactory.eINSTANCE.createIVL_INT();
        INT oCenter = DatatypesFactory.eINSTANCE.createINT();
        oIvlInt.setCenter(oCenter);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlInt);
        return IVLINTTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption4CenterAndWidth() {
        IVL_INT oIvlInt = DatatypesFactory.eINSTANCE.createIVL_INT();
        INT oCenter = DatatypesFactory.eINSTANCE.createINT();
        oIvlInt.setCenter(oCenter);
        INT oWidth = DatatypesFactory.eINSTANCE.createINT();
        oIvlInt.setWidth(oWidth);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlInt);
        return IVLINTTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption4CenterAndLow_FailureCase() {
        boolean bResult = true;
        IVL_INT oIvlInt = DatatypesFactory.eINSTANCE.createIVL_INT();
        INT oCenter = DatatypesFactory.eINSTANCE.createINT();
        oIvlInt.setCenter(oCenter);
        IVXB_INT oLow = DatatypesFactory.eINSTANCE.createIVXB_INT();
        oIvlInt.setLow(oLow);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlInt);
        if (!IVLINTTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static void main(String[] args) throws Exception {
        boolean bFailure = false;
        if (!IVLINTTest.testOption1LowOnly()) {
            bFailure = true;
            System.out.println("testOption1LowOnly failed!");
        }
        if (!IVLINTTest.testOption1LowWithWidth()) {
            bFailure = true;
            System.out.println("testOption1LowWithWidth failed!");
        }
        if (!IVLINTTest.testOption1LowWithHigh()) {
            bFailure = true;
            System.out.println("testOption1LowWithHigh failed!");
        }
        if (!IVLINTTest.testOption1LowWithWidthAndHigh_FailureCase()) {
            bFailure = true;
            System.out.println("testOption1LowWithWidthAndHigh_FailureCase failed!");
        }
        if (!IVLINTTest.testOption2HighOnly()) {
            bFailure = true;
            System.out.println("testOption2HighOnly failed!");
        }
        if (!IVLINTTest.testOption2HighWithCenter_FailureCase()) {
            bFailure = true;
            System.out.println("testOption1LowWithWidthAndHigh_FailureCase failed!");
        }
        if (!IVLINTTest.testOption3WidthOnly()) {
            bFailure = true;
            System.out.println("testOption3WidthOnly failed!");
        }
        if (!IVLINTTest.testOption3WidthAndHigh()) {
            bFailure = true;
            System.out.println("testOption3WidthAndHigh failed!");
        }
        if (!IVLINTTest.testOption4CenterOnly()) {
            bFailure = true;
            System.out.println("testOption4CenterOnly failed!");
        }
        if (!IVLINTTest.testOption4CenterAndWidth()) {
            bFailure = true;
            System.out.println("testOption4CenterAndWidth failed!");
        }
        if (!IVLINTTest.testOption4CenterAndLow_FailureCase()) {
            bFailure = true;
            System.out.println("testOption4CenterAndLow_FailureCase failed!");
        }
        if (bFailure) {
            System.out.println("One or more tests Failed!!!");
        } else {
            System.out.println("All tests completed successfully...");
        }
    }
}

