/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.ui.properties;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.common.ui.search.IElementFilter;
import org.eclipse.mdht.uml.common.ui.util.UMLUIUtil;
import org.eclipse.mdht.uml.term.core.profile.BindingKind;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemVersion;
import org.eclipse.mdht.uml.term.core.profile.TermPackage;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.mdht.uml.ui.properties.sections.ResettableModelerPropertySection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class CodeSystemConstraintSection
extends ResettableModelerPropertySection {
    private Property property;
    private Text idText;
    private boolean idModified = false;
    private Text nameText;
    private boolean nameModified = false;
    private Text versionText;
    private boolean versionModified = false;
    private Text codeText;
    private boolean codeModified = false;
    private Text displayNameText;
    private boolean displayNameModified = false;
    private CCombo bindingCombo;
    private boolean bindingModified = false;
    private CLabel codeSystemRefLabel;
    private Button codeSystemRefButton;
    private Button codeSystemRefDeleteButton;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (CodeSystemConstraintSection.this.idText == event.getSource()) {
                CodeSystemConstraintSection.this.idModified = true;
            }
            if (CodeSystemConstraintSection.this.nameText == event.getSource()) {
                CodeSystemConstraintSection.this.nameModified = true;
            }
            if (CodeSystemConstraintSection.this.versionText == event.getSource()) {
                CodeSystemConstraintSection.this.versionModified = true;
            }
            if (CodeSystemConstraintSection.this.codeText == event.getSource()) {
                CodeSystemConstraintSection.this.codeModified = true;
            }
            if (CodeSystemConstraintSection.this.displayNameText == event.getSource()) {
                CodeSystemConstraintSection.this.displayNameModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                CodeSystemConstraintSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            CodeSystemConstraintSection.this.modifyFields();
        }
    };

    private void modifyFields() {
        if (!(this.idModified || this.nameModified || this.versionModified || this.codeModified || this.displayNameModified || this.bindingModified)) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.property);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Profile ctsProfile = TermProfileUtil.getTerminologyProfile((ResourceSet)CodeSystemConstraintSection.this.property.eResource().getResourceSet());
                    if (ctsProfile == null) {
                        return Status.CANCEL_STATUS;
                    }
                    Enumeration bindingKind = (Enumeration)ctsProfile.getOwnedType("BindingKind");
                    Stereotype stereotype = TermProfileUtil.getAppliedStereotype((Element)CodeSystemConstraintSection.this.property, (String)"CodeSystemConstraint");
                    if (stereotype == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (CodeSystemConstraintSection.this.idModified) {
                        CodeSystemConstraintSection.this.idModified = false;
                        this.setLabel("Set Code System ID");
                        if (stereotype != null) {
                            String value = CodeSystemConstraintSection.this.idText.getText().trim();
                            CodeSystemConstraintSection.this.property.setValue(stereotype, "identifier", (Object)(value.length() > 0 ? value : null));
                        }
                    } else if (CodeSystemConstraintSection.this.nameModified) {
                        CodeSystemConstraintSection.this.nameModified = false;
                        this.setLabel("Set Code System Name");
                        if (stereotype != null) {
                            String value = CodeSystemConstraintSection.this.nameText.getText().trim();
                            CodeSystemConstraintSection.this.property.setValue(stereotype, "name", (Object)(value.length() > 0 ? value : null));
                        }
                    } else if (CodeSystemConstraintSection.this.versionModified) {
                        CodeSystemConstraintSection.this.versionModified = false;
                        this.setLabel("Set Code System Version");
                        if (stereotype != null) {
                            String value = CodeSystemConstraintSection.this.versionText.getText().trim();
                            CodeSystemConstraintSection.this.property.setValue(stereotype, "version", (Object)(value.length() > 0 ? value : null));
                        }
                    } else if (CodeSystemConstraintSection.this.codeModified) {
                        CodeSystemConstraintSection.this.codeModified = false;
                        this.setLabel("Set Code");
                        if (stereotype != null) {
                            String value = CodeSystemConstraintSection.this.codeText.getText().trim();
                            CodeSystemConstraintSection.this.property.setValue(stereotype, "code", (Object)(value.length() > 0 ? value : null));
                        }
                    } else if (CodeSystemConstraintSection.this.displayNameModified) {
                        CodeSystemConstraintSection.this.displayNameModified = false;
                        this.setLabel("Set Code Display Name");
                        if (stereotype != null) {
                            String value = CodeSystemConstraintSection.this.displayNameText.getText().trim();
                            CodeSystemConstraintSection.this.property.setValue(stereotype, "displayName", (Object)(value.length() > 0 ? value : null));
                        }
                    } else if (CodeSystemConstraintSection.this.bindingModified) {
                        CodeSystemConstraintSection.this.bindingModified = false;
                        this.setLabel("Set Binding");
                        if (stereotype != null && bindingKind != null) {
                            if (CodeSystemConstraintSection.this.bindingCombo.getSelectionIndex() == 0) {
                                CodeSystemConstraintSection.this.property.setValue(stereotype, "binding", null);
                            } else {
                                EnumerationLiteral literal = (EnumerationLiteral)bindingKind.getOwnedLiterals().get(CodeSystemConstraintSection.this.bindingCombo.getSelectionIndex());
                                CodeSystemConstraintSection.this.property.setValue(stereotype, "binding", (Object)literal);
                            }
                        }
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    CodeSystemConstraintSection.this.updateViews();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected void resetFields() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.property);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Restore Default Values"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)CodeSystemConstraintSection.this.property);
                    if (codeSystemConstraint == null) {
                        return Status.CANCEL_STATUS;
                    }
                    codeSystemConstraint.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_CONSTRAINT__IDENTIFIER);
                    codeSystemConstraint.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_CONSTRAINT__NAME);
                    codeSystemConstraint.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_CONSTRAINT__VERSION);
                    codeSystemConstraint.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_CONSTRAINT__CODE);
                    codeSystemConstraint.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_CONSTRAINT__DISPLAY_NAME);
                    codeSystemConstraint.eUnset((EStructuralFeature)TermPackage.Literals.CODE_SYSTEM_CONSTRAINT__BINDING);
                    CodeSystemConstraintSection.this.updateViews();
                    CodeSystemConstraintSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void addCodeSystemReference() {
        IElementFilter filter = new IElementFilter(){

            public boolean accept(Element element) {
                return element instanceof Enumeration && TermProfileUtil.getCodeSystemVersion((Enumeration)((Enumeration)element)) != null;
            }
        };
        Enumeration codeSystemEnum = (Enumeration)DialogLaunchUtil.chooseElement((IElementFilter)filter, (ResourceSet)UMLUIUtil.loadModelsfromWorkspace(), (Shell)this.getPart().getSite().getShell(), null, (String)"Select a Code System");
        if (codeSystemEnum == null) {
            return;
        }
        Stereotype codeSystemStereotype = TermProfileUtil.getAppliedStereotype((Element)codeSystemEnum, (String)"CodeSystemVersion");
        if (codeSystemStereotype == null) {
            MessageDialog.openError((Shell)this.getPart().getSite().getShell(), (String)"Invalid Enumeration", (String)"The selected Enumertion must be a <<CodeSystemVersion>>");
            return;
        }
        final CodeSystemVersion codeSystem = (CodeSystemVersion)codeSystemEnum.getStereotypeApplication(codeSystemStereotype);
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.property);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)CodeSystemConstraintSection.this.property);
                    if (codeSystemConstraint == null) {
                        return Status.CANCEL_STATUS;
                    }
                    this.setLabel("Set CodeSystem reference");
                    codeSystemConstraint.setReference(codeSystem);
                    codeSystemConstraint.setIdentifier(null);
                    codeSystemConstraint.setName(null);
                    codeSystemConstraint.setVersion(null);
                    CodeSystemConstraintSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void deleteCodeSystemReference() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.property);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)CodeSystemConstraintSection.this.property);
                    if (codeSystemConstraint == null || codeSystemConstraint.getReference() == null) {
                        return Status.CANCEL_STATUS;
                    }
                    this.setLabel("Remove CodeSystem reference");
                    codeSystemConstraint.setReference(null);
                    codeSystemConstraint.setIdentifier(null);
                    codeSystemConstraint.setName(null);
                    codeSystemConstraint.setVersion(null);
                    CodeSystemConstraintSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 10;
        gc.dispose();
        shell.dispose();
        Group composite = this.getWidgetFactory().createGroup(parent, "Code System");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 4;
        layout.spacing = 7;
        composite.setLayout((Layout)layout);
        int numberOfRows = 3;
        FormData data = null;
        this.codeSystemRefLabel = this.getWidgetFactory().createCLabel((Composite)composite, "");
        this.codeSystemRefButton = this.getWidgetFactory().createButton((Composite)composite, "Select Code System...", 8);
        this.codeSystemRefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CodeSystemConstraintSection.this.addCodeSystemReference();
            }
        });
        this.codeSystemRefDeleteButton = this.getWidgetFactory().createButton((Composite)composite, "X", 8);
        this.codeSystemRefDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CodeSystemConstraintSection.this.deleteCodeSystemReference();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.height = buttonHeight;
        data.top = new FormAttachment(0, numberOfRows);
        this.codeSystemRefButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.codeSystemRefButton, 0);
        data.height = buttonHeight;
        data.top = new FormAttachment((Control)this.codeSystemRefButton, 0, 0x1000000);
        this.codeSystemRefDeleteButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.codeSystemRefDeleteButton, 0);
        data.top = new FormAttachment((Control)this.codeSystemRefButton, 0, 0x1000000);
        this.codeSystemRefLabel.setLayoutData((Object)data);
        this.createRestoreDefaultsButton((Composite)composite);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.codeSystemRefLabel, 0, 0x1000000);
        this.restoreDefaultsButton.setLayoutData((Object)data);
        this.nameText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel nameLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.nameText, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)nameLabel, 0);
        data.right = new FormAttachment(35, 0);
        data.top = new FormAttachment(1, numberOfRows, 4);
        this.nameText.setLayoutData((Object)data);
        this.idText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel idLabel = this.getWidgetFactory().createCLabel((Composite)composite, "ID:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.nameText, 5);
        data.top = new FormAttachment((Control)this.idText, 0, 0x1000000);
        idLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)idLabel, 0);
        data.right = new FormAttachment(70, 0);
        data.top = new FormAttachment(1, numberOfRows, 4);
        this.idText.setLayoutData((Object)data);
        this.versionText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel versionLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Version:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.idText, 5);
        data.top = new FormAttachment((Control)this.versionText, 0, 0x1000000);
        versionLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)versionLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(1, numberOfRows, 4);
        this.versionText.setLayoutData((Object)data);
        this.bindingCombo = this.getWidgetFactory().createCCombo((Composite)composite, 0x800808);
        this.bindingCombo.setItems(new String[]{"Static", "Dynamic"});
        this.bindingCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CodeSystemConstraintSection.this.bindingModified = true;
                CodeSystemConstraintSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                CodeSystemConstraintSection.this.bindingModified = true;
                CodeSystemConstraintSection.this.modifyFields();
            }
        });
        CLabel bindingLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Binding:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.bindingCombo, 0, 0x1000000);
        bindingLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)bindingLabel, 0);
        data.top = new FormAttachment(2, numberOfRows, 4);
        this.bindingCombo.setLayoutData((Object)data);
        this.codeText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel codeLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Code:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.bindingCombo, 5);
        data.top = new FormAttachment((Control)this.codeText, 0, 0x1000000);
        codeLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)codeLabel, 0);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment(2, numberOfRows, 4);
        this.codeText.setLayoutData((Object)data);
        this.displayNameText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel codeNameLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Code Display Name:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.codeText, 5);
        data.top = new FormAttachment((Control)this.displayNameText, 0, 0x1000000);
        codeNameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)codeNameLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(2, numberOfRows, 4);
        this.displayNameText.setLayoutData((Object)data);
    }

    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.property != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.property)) != null && editingDomain.isReadOnly(this.property.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof NamedElement));
        this.property = (Property)element;
    }

    public void dispose() {
        super.dispose();
    }

    public void refresh() {
        Profile ctsProfile = TermProfileUtil.getTerminologyProfile((ResourceSet)this.property.eResource().getResourceSet());
        if (ctsProfile == null) {
            return;
        }
        Enumeration bindingKind = (Enumeration)ctsProfile.getOwnedType("BindingKind");
        CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)this.property);
        CodeSystemVersion codeSystem = null;
        Enumeration referenceEnum = null;
        if (codeSystemConstraint != null && codeSystemConstraint.getReference() != null) {
            codeSystem = codeSystemConstraint.getReference();
            referenceEnum = codeSystem.getBase_Enumeration();
            this.codeSystemRefLabel.setText(codeSystem.getEnumerationQualifiedName());
        } else {
            this.codeSystemRefLabel.setText("");
        }
        this.codeSystemRefLabel.layout();
        this.idText.removeModifyListener(this.modifyListener);
        this.idText.removeKeyListener(this.keyListener);
        this.idText.removeFocusListener(this.focusListener);
        if (codeSystemConstraint != null) {
            String id = codeSystem == null ? codeSystemConstraint.getIdentifier() : codeSystem.getIdentifier();
            this.idText.setText(id != null ? id : "");
        } else {
            this.idText.setText("");
        }
        this.idText.addModifyListener(this.modifyListener);
        this.idText.addKeyListener(this.keyListener);
        this.idText.addFocusListener(this.focusListener);
        this.nameText.removeModifyListener(this.modifyListener);
        this.nameText.removeKeyListener(this.keyListener);
        this.nameText.removeFocusListener(this.focusListener);
        if (codeSystemConstraint != null) {
            String name = codeSystem == null ? codeSystemConstraint.getName() : codeSystem.getEnumerationName();
            this.nameText.setText(name != null ? name : "");
        } else {
            this.nameText.setText("");
        }
        this.nameText.addModifyListener(this.modifyListener);
        this.nameText.addKeyListener(this.keyListener);
        this.nameText.addFocusListener(this.focusListener);
        this.versionText.removeModifyListener(this.modifyListener);
        this.versionText.removeKeyListener(this.keyListener);
        this.versionText.removeFocusListener(this.focusListener);
        if (codeSystemConstraint != null) {
            String version = codeSystem == null ? codeSystemConstraint.getVersion() : codeSystem.getVersion();
            this.versionText.setText(version != null ? version : "");
        } else {
            this.versionText.setText("");
        }
        this.versionText.addModifyListener(this.modifyListener);
        this.versionText.addKeyListener(this.keyListener);
        this.versionText.addFocusListener(this.focusListener);
        this.codeText.removeModifyListener(this.modifyListener);
        this.codeText.removeKeyListener(this.keyListener);
        this.codeText.removeFocusListener(this.focusListener);
        if (codeSystemConstraint != null) {
            String code = codeSystemConstraint.getCode();
            this.codeText.setText(code != null ? code : "");
        } else {
            this.codeText.setText("");
        }
        this.codeText.addModifyListener(this.modifyListener);
        this.codeText.addKeyListener(this.keyListener);
        this.codeText.addFocusListener(this.focusListener);
        this.displayNameText.removeModifyListener(this.modifyListener);
        this.displayNameText.removeKeyListener(this.keyListener);
        this.displayNameText.removeFocusListener(this.focusListener);
        if (codeSystemConstraint != null) {
            String displayName = codeSystemConstraint.getDisplayName();
            this.displayNameText.setText(displayName != null ? displayName : "");
        } else {
            this.displayNameText.setText("");
        }
        this.displayNameText.addModifyListener(this.modifyListener);
        this.displayNameText.addKeyListener(this.keyListener);
        this.displayNameText.addFocusListener(this.focusListener);
        this.bindingCombo.select(0);
        if (codeSystemConstraint != null) {
            BindingKind binding = codeSystemConstraint.getBinding();
            if (bindingKind != null && binding != null) {
                EnumerationLiteral literal = bindingKind.getOwnedLiteral(binding.getName());
                int index = bindingKind.getOwnedLiterals().indexOf((Object)literal);
                this.bindingCombo.select(index);
            }
        }
        if (this.isReadOnly()) {
            this.codeSystemRefLabel.setEnabled(false);
            this.idText.setEnabled(false);
            this.nameText.setEnabled(false);
            this.versionText.setEnabled(false);
            this.codeText.setEnabled(false);
            this.displayNameText.setEnabled(false);
            this.bindingCombo.setEnabled(false);
            this.restoreDefaultsButton.setEnabled(false);
        } else {
            this.codeSystemRefLabel.setEnabled(true);
            this.idText.setEnabled(referenceEnum == null);
            this.nameText.setEnabled(referenceEnum == null);
            this.versionText.setEnabled(referenceEnum == null);
            this.codeText.setEnabled(true);
            this.displayNameText.setEnabled(true);
            this.bindingCombo.setEnabled(true);
            this.restoreDefaultsButton.setEnabled(codeSystemConstraint != null);
        }
    }

    public void update(Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!CodeSystemConstraintSection.this.isDisposed() && CodeSystemConstraintSection.this.property.eResource() != null) {
                        CodeSystemConstraintSection.this.refresh();
                    }
                }
            });
        }
    }

    protected void updateViews() {
        NotificationImpl notification = new NotificationImpl(1, null, this.property.getName()){

            public Object getNotifier() {
                return CodeSystemConstraintSection.this.property;
            }

            public int getFeatureID(Class expectedClass) {
                return 5;
            }
        };
        this.property.eNotify((Notification)notification);
    }
}

