/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.validation.internal.classifiers;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.mdht.uml.validation.ocl.EcoreProfileEnvironment;
import org.eclipse.mdht.uml.validation.ocl.EcoreProfileEnvironmentFactory;
import org.eclipse.mdht.uml.validation.provider.AbstractMultiConstraint;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.uml.OCL;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class OCLConstraintConstraints
extends AbstractMultiConstraint {
    private static final String ANALYSISLANGUAGE = "ANALYSIS";
    private static final String OCLLANGUAGE = "OCL";
    private static final String UNIMPLEMENTABLE = "UNIMPLEMENTABLE";

    public IStatus validateInvalidOCLConstraint(IValidationContext context) {
        Element owner;
        IStatus result = context.createSuccessStatus();
        Constraint constraint = null;
        OpaqueExpression specification = null;
        if (context.getTarget() instanceof OpaqueExpression && (context.getFeature() == null || this.isOCLBodyChange(context)) && (owner = (specification = (OpaqueExpression)context.getTarget()).getOwner()) instanceof Constraint) {
            constraint = (Constraint)owner;
        }
        if (specification != null && constraint != null) {
            int languageCtr = 0;
            for (String language : specification.getLanguages()) {
                String ocl;
                if (OCLLANGUAGE.equalsIgnoreCase(language) && (ocl = (String)specification.getBodies().get(languageCtr)) != null && constraint.getContext() instanceof Classifier) {
                    try {
                        OCL.Helper helper = this.getOCLCache(context).helper((Classifier)constraint.getContext());
                        if (EcoreProfileEnvironment.isQueryConstraint((Constraint)constraint)) {
                            helper.createQuery(ocl);
                        } else {
                            helper.createInvariant(ocl);
                        }
                    }
                    catch (ParserException pe) {
                        Object[] data = new Object[]{constraint.getName(), pe.getMessage()};
                        result = context.createFailureStatus(data);
                    }
                }
                ++languageCtr;
            }
        }
        return result;
    }

    private boolean isOCLBodyChange(IValidationContext context) {
        OpaqueExpression expr;
        int index;
        boolean result = false;
        if (context.getFeature() == UMLPackage.Literals.OPAQUE_EXPRESSION__BODY && (index = (expr = (OpaqueExpression)context.getTarget()).getBodies().indexOf(context.getFeatureNewValue())) >= 0 && index < expr.getLanguages().size()) {
            result = OCLLANGUAGE.equalsIgnoreCase((String)expr.getLanguages().get(index));
        }
        return result;
    }

    public IStatus validateMissingOCLConstraint(IValidationContext context) {
        Constraint constraint;
        ValueSpecification vs;
        IStatus result = context.createSuccessStatus();
        if (context.getTarget() instanceof Constraint && (vs = (constraint = (Constraint)context.getTarget()).getSpecification()) instanceof OpaqueExpression) {
            OpaqueExpression oe = (OpaqueExpression)vs;
            int languageCtr = 0;
            String ocl = null;
            String analysis = null;
            for (String language : oe.getLanguages()) {
                if (OCLLANGUAGE.equalsIgnoreCase(language)) {
                    ocl = (String)oe.getBodies().get(languageCtr);
                }
                if (ANALYSISLANGUAGE.equalsIgnoreCase(language)) {
                    analysis = (String)oe.getBodies().get(languageCtr);
                }
                ++languageCtr;
            }
            if (analysis != null) {
                boolean unimplementable = false;
                for (Comment comment : constraint.getOwnedComments()) {
                    if (comment.getBody() == null || !comment.getBody().startsWith(UNIMPLEMENTABLE)) continue;
                    unimplementable = true;
                }
                if (!(unimplementable || ocl != null && ocl.trim().length() != 0)) {
                    result = context.createFailureStatus(new Object[]{constraint.getQualifiedName()});
                }
            }
        }
        return result;
    }

    private OCLCache getOCLCache(IValidationContext ctx) {
        OCLCache result = (OCLCache)ctx.getCurrentConstraintData();
        if (result == null) {
            result = OCLCache.create(ctx.getTarget());
            ctx.putCurrentConstraintData((Object)result);
        }
        return result;
    }

    private static final class OCLCache {
        private static final Map<Reference<OCLCache>, OCL> INSTANCES = new HashMap<Reference<OCLCache>, OCL>();
        private static final ReferenceQueue<OCLCache> QUEUE = new ReferenceQueue();
        private final OCL ocl;

        static {
            ModelValidationService.getInstance().addValidationListener(OCLCache.createCleanupListener());
        }

        private OCLCache(ResourceSet rset) {
            this.ocl = OCL.newInstance((EnvironmentFactory)(rset == null ? new EcoreProfileEnvironmentFactory() : new EcoreProfileEnvironmentFactory(rset)));
            INSTANCES.put(new PhantomReference<OCLCache>(this, QUEUE), this.ocl);
        }

        static OCLCache create(EObject context) {
            Resource res = context.eResource();
            OCLCache result = new OCLCache(res == null ? null : res.getResourceSet());
            OCLCache.cleanUpOCLCaches();
            return result;
        }

        OCL.Helper helper(Classifier context) {
            OCL.Helper result = this.ocl.createOCLHelper();
            result.setContext((Object)context);
            return result;
        }

        static void cleanUpOCLCaches() {
            Reference<OCLCache> next = QUEUE.poll();
            while (next != null) {
                next.clear();
                OCL ocl = INSTANCES.remove(next);
                if (ocl != null) {
                    ocl.dispose();
                }
                next = QUEUE.poll();
            }
        }

        private static IValidationListener createCleanupListener() {
            return new IValidationListener(){

                public void validationOccurred(ValidationEvent event) {
                    OCLCache.cleanUpOCLCaches();
                }
            };
        }
    }
}

