/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.internal.context;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.eclipse.mdht.uml.ui.internal.context.UMLContext;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class UMLContextManager {
    private static final String CONTEXT_ID_PREFIX = "org.eclipse.mdht.uml.ui.context.";
    private final IContextService contextService;
    private final Map<UMLContext, IContextActivation> activeContexts = new EnumMap<UMLContext, IContextActivation>(UMLContext.class);

    public UMLContextManager(IContextService contextService) {
        this.contextService = contextService;
    }

    private static String getContextID(UMLContext context) {
        return CONTEXT_ID_PREFIX + context.key();
    }

    public void activate(UMLContext context) {
        if (!this.activeContexts.containsKey((Object)context)) {
            this.activeContexts.put(context, this.contextService.activateContext(UMLContextManager.getContextID(context)));
        }
    }

    public void deactivate(UMLContext context) {
        IContextActivation token = this.activeContexts.remove((Object)context);
        if (token != null) {
            this.contextService.deactivateContext(token);
        }
    }

    public void activateAll(Iterable<? extends UMLContext> contexts) {
        for (UMLContext uMLContext : contexts) {
            this.activate(uMLContext);
        }
    }

    public void activateAll() {
        this.activateAll(EnumSet.allOf(UMLContext.class));
    }

    public void deactivateAll(Iterable<? extends UMLContext> contexts) {
        for (UMLContext uMLContext : contexts) {
            this.deactivate(uMLContext);
        }
    }

    public void deactivateAll() {
        this.deactivateAll(EnumSet.allOf(UMLContext.class));
    }

    public boolean isActive(UMLContext context) {
        return this.activeContexts.containsKey((Object)context);
    }
}

