/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.editors;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mdht.uml.common.ui.util.PartAdapter;
import org.eclipse.mdht.uml.edit.provider.UML2ExtendedAdapterFactory;
import org.eclipse.mdht.uml.ui.editors.TableEditorComposedAdapterFactory;
import org.eclipse.mdht.uml.ui.editors.UMLTableEditor;
import org.eclipse.mdht.uml.ui.internal.Logger;
import org.eclipse.mdht.uml.ui.internal.context.UMLContext;
import org.eclipse.mdht.uml.ui.internal.context.UMLContextManager;
import org.eclipse.mdht.uml.ui.internal.l10n.UML2UIMessages;
import org.eclipse.mdht.uml.ui.navigator.actions.EditCommandsFactory;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class UMLTableActionBarContributor
extends EditorActionBarContributor
implements IMenuListener {
    protected IEditorPart activeEditor;
    private EditCommandsFactory editCommandsFactory = new EditCommandsFactory();
    private final Map<IWorkbenchPartSite, UMLContextManager> contextManagers = new HashMap<IWorkbenchPartSite, UMLContextManager>();
    private Collection<UMLContextAction> umlContextActions;
    protected ShowBusinessNamesAction showBusinessNamesAction = new ShowBusinessNamesAction();

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        this.editCommandsFactory.shareGlobalActions(actionBars, false);
    }

    public IEditorPart getActiveEditor() {
        return this.activeEditor;
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part != this.activeEditor) {
            AdapterFactory adapterFactory;
            if (this.activeEditor != null) {
                this.editCommandsFactory.setActivePart(null);
                this.activeEditor = null;
            }
            if (part instanceof IEditingDomainProvider) {
                this.activeEditor = part;
                this.editCommandsFactory.setActivePart((IWorkbenchPart)this.activeEditor);
            }
            if (this.activeEditor instanceof UMLTableEditor && (adapterFactory = ((UMLTableEditor)this.activeEditor).getAdapterFactory()) instanceof UML2ExtendedAdapterFactory) {
                this.showBusinessNamesAction.setChecked(((UML2ExtendedAdapterFactory)adapterFactory).isShowBusinessNames());
            }
            if (this.activeEditor != null) {
                if (this.getContextManager() == null) {
                    Logger.log(202, "Could not get active context manager for editor site.");
                } else {
                    this.updateUMLContextActions();
                }
            }
        }
    }

    public void setActivePage(IEditorPart part) {
    }

    UMLContextManager getContextManager() {
        IWorkbenchPartSite site;
        UMLContextManager result = null;
        if (this.activeEditor != null && (result = this.contextManagers.get(site = this.activeEditor.getSite())) == null) {
            result = new UMLContextManager((IContextService)site.getService(IContextService.class));
            this.contextManagers.put(site, result);
            result.activateAll();
            site.getPage().addPartListener((IPartListener)new PartAdapter(){

                public void partClosed(IWorkbenchPart part) {
                    UMLTableActionBarContributor.this.contextManagers.remove(site);
                }
            });
        }
        return result;
    }

    public void shareGlobalActions(IPage page, IActionBars actionBars) {
        this.editCommandsFactory.shareGlobalActions(actionBars, page instanceof IPropertySheetPage);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        this.editCommandsFactory.shareGlobalActions(this.getActionBars(), false);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(UML2UIMessages._UI_UMLEditor_menu, "org.eclipse.mdht.uml.ui.umlMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        this.addUMLContextActions((IMenuManager)submenuManager);
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IAction)this.showBusinessNamesAction);
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.fillContextMenu(menuManager);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("group.new"));
        manager.add((IContributionItem)new GroupMarker("group.goto"));
        manager.add((IContributionItem)new Separator("group.open"));
        manager.add((IContributionItem)new GroupMarker("group.openWith"));
        manager.add((IContributionItem)new Separator("group.edit"));
        manager.add((IContributionItem)new Separator("group.show"));
        manager.add((IContributionItem)new GroupMarker("group.reorganize"));
        manager.add((IContributionItem)new Separator("group.port"));
        manager.add((IContributionItem)new Separator("group.generate"));
        manager.add((IContributionItem)new Separator("group.search"));
        manager.add((IContributionItem)new Separator("group.build"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("group.properties"));
        this.editCommandsFactory.fillContextMenu(manager);
    }

    private void addUMLContextActions(IMenuManager menu) {
        if (this.umlContextActions == null) {
            this.umlContextActions = Arrays.asList(new UMLContextAction(UMLContext.CLASSES, "Classes"));
        }
        MenuManager submenu = new MenuManager("Available Actions");
        menu.add((IContributionItem)submenu);
        for (UMLContextAction next : this.umlContextActions) {
            submenu.add((IAction)next);
        }
    }

    private void updateUMLContextActions() {
        if (this.umlContextActions != null) {
            for (UMLContextAction next : this.umlContextActions) {
                next.update();
            }
        }
    }

    protected class ShowBusinessNamesAction
    extends Action {
        protected ShowBusinessNamesAction() {
            super(UML2UIMessages.ShowBusinessNames_title, 2);
        }

        public void setChecked(boolean checked) {
            UMLTableEditor umlTableEditor;
            AdapterFactory adapterFactory;
            boolean wasChecked = this.isChecked();
            super.setChecked(checked);
            if (wasChecked != checked && UMLTableActionBarContributor.this.activeEditor instanceof UMLTableEditor && (adapterFactory = (umlTableEditor = (UMLTableEditor)UMLTableActionBarContributor.this.activeEditor).getAdapterFactory()) instanceof TableEditorComposedAdapterFactory) {
                for (AdapterFactory factory : ((TableEditorComposedAdapterFactory)adapterFactory).getAdapterFactories()) {
                    if (!(factory instanceof UML2ExtendedAdapterFactory)) continue;
                    ((UML2ExtendedAdapterFactory)factory).setShowBusinessNames(checked);
                    umlTableEditor.refresh();
                }
            }
        }
    }

    private class UMLContextAction
    extends Action {
        private final UMLContext context;

        UMLContextAction(UMLContext context, String label) {
            super(label, 2);
            this.context = context;
        }

        public void run() {
            boolean activate = this.isChecked();
            if (activate) {
                UMLTableActionBarContributor.this.getContextManager().activate(this.context);
            } else {
                UMLTableActionBarContributor.this.getContextManager().deactivate(this.context);
            }
        }

        public boolean isEnabled() {
            return UMLTableActionBarContributor.this.getContextManager() != null && super.isEnabled();
        }

        void update() {
            UMLContextManager ctxmgr = UMLTableActionBarContributor.this.getContextManager();
            this.setEnabled(ctxmgr != null);
            if (ctxmgr != null) {
                this.setChecked(ctxmgr.isActive(this.context));
            }
        }
    }
}

