/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.transformation.ocl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mdht.transformation.ocl.DomainSpecificOCLHandler;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.TypeType;

public abstract class OCLTransformation<PK, C, O extends EModelElement, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    protected String selfVariable = "self";
    protected boolean isMany;
    protected Map<Variable<C, PM>, String> bindings;
    protected Set<String> negatedExpressions = new HashSet<String>();
    OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> EOCL_ENV;
    OCLHelper<C, O, P, CT> helper;
    protected DomainSpecificOCLHandler<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> domainSpecificOCLHandler = new DomainSpecificOCLHandler();
    protected ResourceSet rset;

    public DomainSpecificOCLHandler<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getDomainSpecificOCLHandler() {
        return this.domainSpecificOCLHandler;
    }

    public void setDomainSpecificOCLHandler(DomainSpecificOCLHandler<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> domainSpecificOCLHandler) {
        this.domainSpecificOCLHandler = domainSpecificOCLHandler;
        this.domainSpecificOCLHandler.setTransformation(this);
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.rset = resourceSet;
    }

    public String transform(OCLExpression<C> exp) {
        if (exp instanceof OperationCallExp) {
            OperationCallExp op = (OperationCallExp)exp;
            String opName = this.getName(op.getReferredOperation());
            String domainSpecific = this.transformDomainSpecific(op, opName);
            if (domainSpecific != null) {
                return domainSpecific;
            }
            if ("oclAsType".equals(opName)) {
                String source = this.transform(op.getSource());
                String i = this.newVar();
                Object t = ((TypeType)((OCLExpression)op.getArgument().get(0)).getType()).getReferredType();
                Object tBase = this.getBaseType(t);
                if (tBase == op.getSource().getType()) {
                    return source;
                }
                if (this.isSuperTypeOf(op.getSource().getType(), tBase)) {
                    return this.iterator(this.typeCast(i, this.getName(tBase)), i, "collect", source);
                }
                return source;
            }
            if ("oclIsKindOf".equals(opName) || "oclIsTypeOf".equals(opName)) {
                String source = this.transform(op.getSource());
                String i = this.newVar();
                Object t = ((TypeType)((OCLExpression)op.getArgument().get(0)).getType()).getReferredType();
                String predicate = this.getTypeCheck(t, this.one(this.transform(op.getSource())));
                if (predicate != null) {
                    return predicate;
                }
                Object tBase = this.getBaseType(t);
                if (tBase == op.getSource().getType()) {
                    return "true()";
                }
                if (this.isSuperTypeOf(op.getSource().getType(), tBase)) {
                    return this.iterator(this.instanceOf(i, this.getName(tBase)), i, "forAll", source);
                }
                return "true()";
            }
            if ("oclIsUndefined".equals(opName)) {
                return this.isEmpty(this.transform(op.getSource()));
            }
            if ("not".equals(opName)) {
                return this.not(this.transform(op.getSource()));
            }
            if ("isEmpty".equals(opName)) {
                return this.isEmpty(this.transform(op.getSource()));
            }
            if ("notEmpty".equals(opName)) {
                return this.transform(op.getSource());
            }
            if ("implies".equals(opName)) {
                return String.valueOf(this.not(this.transform(op.getSource()))) + this.op("or") + this.transform((OCLExpression)op.getArgument().get(0));
            }
            if ("or".equals(opName) || "xor".equals(opName)) {
                OperationCallExp operationCallExp2;
                String result = this.transform(op.getSource());
                for (OCLExpression x : op.getArgument()) {
                    result = String.valueOf(result) + this.op(opName) + this.transform(x);
                }
                if (exp.eContainer() instanceof OperationCallExp && "and".equals(this.getName((operationCallExp2 = (OperationCallExp)exp.eContainer()).getReferredOperation()))) {
                    return "(" + result + ")";
                }
                return result;
            }
            if ("and".equals(opName)) {
                String result = this.transform(op.getSource());
                for (OCLExpression x : op.getArgument()) {
                    result = String.valueOf(result) + this.op(opName) + this.transform(x);
                }
                return result;
            }
            if ("=".equals(opName) || "<=".equals(opName) || ">=".equals(opName) || "<".equals(opName) || ">".equals(opName) || "<>".equals(opName)) {
                if ("=".equals(opName) && op.getSource().getType() instanceof CollectionType && ((OCLExpression)op.getArgument().get(0)).getType() instanceof CollectionType) {
                    return this.deepEqual(opName, this.transform(op.getSource()), this.transform((OCLExpression)op.getArgument().get(0)));
                }
                return this.compare(opName, this.transform(op.getSource()), this.transform((OCLExpression)op.getArgument().get(0)));
            }
            if ("asSequence".equals(opName)) {
                return this.transform(op.getSource());
            }
            EObject eClass = ((EModelElement)op.getReferredOperation()).eContainer();
            String oclString = this.getFromOperations(eClass, this.getName(op.getReferredOperation()), "__EOCL_EXP");
            EAnnotation anno = ((EModelElement)op.getReferredOperation()).getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
            if (oclString == null && anno != null) {
                oclString = (String)anno.getDetails().get((Object)"documentation");
            }
            if (oclString != null) {
                OCLExpression<EObject> exp2 = this.getOCLExpression(eClass, oclString, false);
                String body = this.transformWithNewBindings(exp2, this.selfVariable);
                String result = this.step(this.transform(op.getSource()), body);
                return result;
            }
            String source = this.transform(op.getSource());
            String params = "";
            for (OCLExpression arg : op.getArgument()) {
                params = String.valueOf(params) + ", " + this.transform(arg);
            }
            if (params.startsWith(", ")) {
                params = params.substring(", ".length());
            }
            if ("includes".equals(opName)) {
                return this.contains(source, params);
            }
            String i = this.newVar();
            String n = "collect";
            if ("Boolean".equals(this.getName(op.getType()))) {
                n = "exists";
            }
            return this.iterator(String.valueOf(i) + "." + opName + "(" + params + ")", i, n, source);
        }
        if (exp instanceof PropertyCallExp) {
            PropertyCallExp propertyCallExp = (PropertyCallExp)exp;
            return this.step(this.transform(propertyCallExp.getSource()), propertyCallExp.getReferredProperty());
        }
        if (exp instanceof IteratorExp) {
            IteratorExp iteratorExp = (IteratorExp)exp;
            String n = iteratorExp.getName();
            String self = this.transform(iteratorExp.getSource());
            for (Variable var : iteratorExp.getIterator()) {
                this.bindings.put(var, this.newVar());
            }
            try {
                String string = this.iterator(iteratorExp, n, self);
                return string;
            }
            finally {
                this.bindings.keySet().removeAll((Collection<?>)iteratorExp.getIterator());
            }
        }
        if (exp instanceof LetExp) {
            LetExp letExp = (LetExp)exp;
            String self = this.transform(letExp.getVariable().getInitExpression());
            String i = this.newVar();
            this.bindings.put(letExp.getVariable(), i);
            String result = this.isNotEmpty(this.predicate(self, this.transform(letExp.getIn()), i));
            this.bindings.keySet().remove(letExp.getVariable());
            return result;
        }
        if (exp instanceof VariableExp) {
            VariableExp variableExp = (VariableExp)exp;
            if (this.bindings.containsKey(variableExp.getReferredVariable())) {
                return this.referVar(this.bindings.get(variableExp.getReferredVariable()));
            }
            if ("self".equals(variableExp.getName())) {
                return this.selfNode();
            }
        }
        if (exp instanceof CollectionLiteralExp) {
            CollectionLiteralExp collectionLiteralExp = (CollectionLiteralExp)exp;
            if (collectionLiteralExp.getPart().isEmpty()) {
                return "*[false()]";
            }
            if (collectionLiteralExp.getPart().size() > 1) {
                throw new RuntimeException("Unsupported");
            }
            CollectionLiteralPart part = (CollectionLiteralPart)collectionLiteralExp.getPart().get(0);
            if (part instanceof CollectionItem) {
                CollectionItem collectionItem = (CollectionItem)part;
                return this.transform(collectionItem.getItem());
            }
        }
        if (exp instanceof StringLiteralExp) {
            StringLiteralExp stringLiteralExp = (StringLiteralExp)exp;
            return "\"" + stringLiteralExp.getStringSymbol() + "\"";
        }
        if (exp instanceof IntegerLiteralExp) {
            IntegerLiteralExp integerLiteralExp = (IntegerLiteralExp)exp;
            return "" + integerLiteralExp.getIntegerSymbol();
        }
        if (exp instanceof BooleanLiteralExp) {
            BooleanLiteralExp booleanLiteralExp = (BooleanLiteralExp)exp;
            return String.valueOf(booleanLiteralExp.getBooleanSymbol().toString()) + "()";
        }
        if (exp instanceof TypeExp) {
            TypeExp typeExp = (TypeExp)exp;
            return this.typeof(this.getName(typeExp.getReferredType()));
        }
        throw new RuntimeException("Could not transform OCL: " + exp);
    }

    public abstract String typeof(String var1);

    public String getQualifiedName(P referredProperty) {
        return this.domainSpecificOCLHandler.getPropertyName(referredProperty);
    }

    public abstract String newVar();

    public String referVar(String variable) {
        return variable;
    }

    public String compare(String operator, String lhs, String rhs) {
        return String.valueOf(lhs) + " " + this.op(operator) + " " + rhs;
    }

    public String deepEqual(String operator, String lhs, String rhs) {
        return String.valueOf(lhs) + " " + this.op(operator) + " " + rhs;
    }

    protected String iterator(IteratorExp<C, PM> iteratorExp, String n, String source) {
        String body = this.transform(iteratorExp.getBody());
        String i = this.bindings.get(iteratorExp.getIterator().get(0));
        return this.iterator(body, i, n, source);
    }

    public abstract String iterator(String var1, String var2, String var3, String var4);

    protected abstract String op(String var1);

    protected String transformDomainSpecific(OperationCallExp<C, O> op, String opName) {
        return this.domainSpecificOCLHandler.transformDomainSpecific(op, opName);
    }

    public abstract String isEmpty(String var1);

    public abstract String isNotEmpty(String var1);

    public boolean isClassType(C type) {
        return this.getOCLInstance().getEnvironment().getUMLReflection().isClass(type);
    }

    protected String not(String expression) {
        String func = String.valueOf(this.op("not")) + "(";
        if (this.negatedExpressions.contains(expression)) {
            return expression.substring(func.length(), expression.length() - ")".length());
        }
        if ("true()".equals(expression)) {
            return "false()";
        }
        if ("false()".equals(expression)) {
            return "true()";
        }
        String result = String.valueOf(func) + expression + ")";
        this.negatedExpressions.add(result);
        return result;
    }

    public final String predicate(String set, String predicate, String i) {
        return this.iterator(predicate, i, "select", set);
    }

    public abstract String step(String var1, String var2);

    public String step(String set, P property) {
        return this.step(set, this.getQualifiedName(property));
    }

    public final String getName(Object namedObject) {
        return this.domainSpecificOCLHandler.getName(namedObject);
    }

    public String transform(C context, String oclString) {
        OCLExpression<C> exp = this.getOCLExpression(context, oclString, true);
        return this.cosmetics(this.transformWithNewBindings(exp, this.selfVariable));
    }

    public String transformWithNewBindings(OCLExpression<C> exp, String customSelfVariable) {
        Map<Variable<C, PM>, String> saveBindings = this.bindings;
        String saveSelfName = this.selfVariable;
        this.selfVariable = customSelfVariable;
        this.bindings = new HashMap<Variable<C, PM>, String>();
        try {
            String string = this.transform(exp);
            return string;
        }
        finally {
            this.bindings = saveBindings;
            this.selfVariable = saveSelfName;
        }
    }

    public abstract String cosmetics(String var1);

    public abstract OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getOCLInstance();

    public OCLExpression<C> getOCLExpression(C context, String oclString, boolean isInvariant) {
        if (this.helper == null) {
            this.EOCL_ENV = this.getOCLInstance();
            this.helper = this.EOCL_ENV.createOCLHelper();
        }
        this.helper.setContext(context);
        try {
            if (!isInvariant) {
                return this.helper.createQuery(oclString);
            }
            try {
                Object EOCL_INV = this.helper.createInvariant(oclString);
                OCLExpression exp = this.EOCL_ENV.createQuery(EOCL_INV).getExpression();
                this.isMany = exp.getType() instanceof CollectionType;
                return exp;
            }
            catch (Exception exception) {
                OCLExpression exp = this.helper.createQuery(oclString);
                return this.EOCL_ENV.createQuery(exp).getExpression();
            }
        }
        catch (ParserException pe) {
            throw new UnsupportedOperationException(pe.getLocalizedMessage());
        }
    }

    public String getFromOperations(C eClass, String opname, String suffix) {
        return null;
    }

    public boolean isMany() {
        return this.isMany;
    }

    protected abstract String selfNode();

    public String nsPrefix(String propertyName) {
        return propertyName;
    }

    public String childNode(String step) {
        return String.valueOf(step) + "/child::node()";
    }

    public String getTypeCheck(C clazz) {
        return this.getTypeCheck(clazz, this.selfVariable);
    }

    public String getTypeCheck(C clazz, String customSelfVariable) {
        return this.domainSpecificOCLHandler.getTypeCheck(clazz, customSelfVariable);
    }

    public String getValue(P property, String value) {
        return "\"" + value + "\"";
    }

    public C getType(P property) {
        Object type = this.getOCLInstance().getEnvironment().getUMLReflection().getOCLType(property);
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            return (C)collectionType.getElementType();
        }
        return (C)type;
    }

    public String one(String transform) {
        return transform;
    }

    public boolean isSuperTypeOf(C lhs, C rhs) {
        return this.getOCLInstance().getEnvironment().getUMLReflection().getAllSupertypes(rhs).contains(lhs);
    }

    public String typeCast(String object, String type) {
        return object;
    }

    public String instanceOf(String object, String type) {
        return null;
    }

    protected final C getBaseType(C t) {
        return this.domainSpecificOCLHandler.getBaseType(t);
    }

    public abstract String contains(String var1, String var2);
}

