/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.RandomStringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.CDAPackage;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.StrucDocText;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.util.CDASwitch;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.hl7.datatypes.BL;
import org.eclipse.mdht.uml.hl7.datatypes.CD;
import org.eclipse.mdht.uml.hl7.datatypes.CS;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesPackage;
import org.eclipse.mdht.uml.hl7.datatypes.ED;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.datatypes.INT;
import org.eclipse.mdht.uml.hl7.datatypes.IVL_TS;
import org.eclipse.mdht.uml.hl7.datatypes.IVXB_TS;
import org.eclipse.mdht.uml.hl7.datatypes.ST;
import org.eclipse.mdht.uml.hl7.datatypes.SXCM_TS;
import org.eclipse.mdht.uml.hl7.datatypes.util.DatatypesSwitch;
import org.eclipse.mdht.uml.hl7.rim.InfrastructureRoot;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class InstanceGenerator {
    private Map<String, EPackage> packageURIMap = new HashMap<String, EPackage>();
    boolean standalone = true;
    ClinicalDocument clinicalDocument = null;

    private static HashMap<String, String> createshallShouldMayProperties() {
        HashMap<String, String> shallShouldMayProperties = new HashMap<String, String>();
        shallShouldMayProperties.put("text", "text");
        return shallShouldMayProperties;
    }

    static void createvalueSetProperies(Class umlClass, HashMap<String, String> shouldShallMayProperties) {
        for (Property umlProperty : umlClass.getOwnedAttributes()) {
            if (CDAModelUtil.getValidationSeverity(umlProperty) == null || shouldShallMayProperties.containsKey(umlProperty.getName())) continue;
            shouldShallMayProperties.put(umlProperty.getName(), umlProperty.getName());
        }
        for (Classifier c : umlClass.getGenerals()) {
            if (!(c instanceof Class) || c.getGenerals().size() <= 0) continue;
            InstanceGenerator.createvalueSetProperies((Class)c, shouldShallMayProperties);
        }
    }

    private static EOperation findAddOperation(EClass eClass, EOperation getOperation) {
        for (EOperation eOperation : eClass.getEAllOperations()) {
            if (eOperation.getName() == null || !eOperation.getName().startsWith("add")) continue;
            for (EParameter eParameter : eOperation.getEParameters()) {
                if (!(eParameter.getEType() instanceof EClass) || !((EClass)eParameter.getEType()).isSuperTypeOf((EClass)getOperation.getEType())) continue;
                return eOperation;
            }
        }
        return null;
    }

    private static void addObject(EClass eClass, EOperation addOperation, EObject eObject, EObject objectToAdd) {
        Method[] methodArray = eClass.getInstanceClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (addOperation.getName().equals(m.getName())) {
                try {
                    m.invoke((Object)eObject, objectToAdd);
                }
                catch (Exception exception) {}
                break;
            }
            ++n2;
        }
    }

    private static void initEObject(EObject eObject) {
        try {
            Method initMethod = eObject.getClass().getDeclaredMethod("init", new java.lang.Class[0]);
            if (initMethod != null) {
                initMethod.invoke((Object)eObject, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sampleInstanceInitialization(Class umlClass, EObject eObject, HashMap<String, String> shallShouldMayProperties, int level) {
        InstanceGenerator.initEObject(eObject);
        if (level < 0 || CDAModelUtil.isCDAModel((Element)umlClass)) {
            return;
        }
        EClass eClass = eObject.eClass();
        for (Association association : umlClass.getAssociations()) {
            for (Property property : association.getMemberEnds()) {
                EClassifier eType;
                Object cdaFeature;
                if (umlClass.getOwnedAttribute(property.getName(), property.getType()) == null || !(property.getType() instanceof Class)) continue;
                Class cdaSourceClass = CDAModelUtil.getCDAClass((Classifier)umlClass);
                Class cdaTypeClass = CDAModelUtil.getCDAClass((Classifier)property.getType());
                Property cdaProperty = null;
                if (cdaSourceClass != null) {
                    cdaProperty = cdaSourceClass.getAttribute(null, (Type)cdaTypeClass);
                    Property property2 = cdaProperty = cdaProperty == null ? cdaSourceClass.getAttribute(cdaTypeClass.getName(), null, true, null) : cdaProperty;
                }
                if (cdaProperty == null || !((cdaFeature = eClass.getEStructuralFeature(cdaProperty.getName())) instanceof EReference)) continue;
                String ePackageURI = CDAModelUtil.getEcorePackageURI((Element)property.getType());
                EPackage ePackage = this.getEPackageForURI(ePackageURI);
                EReference cdaReference = (EReference)cdaFeature;
                EObject objectToAdd = cdaReference.getEReferenceType().getEPackage().getEFactoryInstance().create(cdaReference.getEReferenceType());
                if (ePackage != null && (eType = ePackage.getEClassifier(UML2Util.getValidJavaIdentifier((String)property.getType().getName()))) != null) {
                    objectToAdd = ePackage.getEFactoryInstance().create((EClass)eType);
                    InstanceGenerator.initEObject(eObject);
                }
                if (ePackage != null && property.getType().getOwner() instanceof Class) {
                    EAnnotation annotation;
                    Class owner = (Class)property.getType().getOwner();
                    while (owner.getOwner() instanceof Class) {
                        owner = (Class)owner.getOwner();
                    }
                    EClassifier eet = ePackage.getEClassifier(UML2Util.getValidJavaIdentifier((String)owner.getName()));
                    if (eet != null && (annotation = eet.getEAnnotation("http://www.openhealthtools.org/mdht/uml/cda/annotation/" + UML2Util.getValidJavaIdentifier((String)property.getType().getQualifiedName()))) != null) {
                        CDAUtil.init((EObject)objectToAdd, (Map)annotation.getDetails().map());
                    }
                }
                HashMap<String, String> inlineshallShouldMayProperties = InstanceGenerator.createshallShouldMayProperties();
                InstanceGenerator.createvalueSetProperies((Class)property.getType(), inlineshallShouldMayProperties);
                this.sampleInstanceInitialization((Class)property.getType(), objectToAdd, inlineshallShouldMayProperties, level - 1);
                if (cdaReference.isMany()) {
                    ((EList)eObject.eGet((EStructuralFeature)cdaReference)).add((Object)objectToAdd);
                    continue;
                }
                eObject.eSet((EStructuralFeature)cdaReference, (Object)objectToAdd);
            }
        }
        if (eClass.getEPackage().getNsURI() != null && !eClass.getEPackage().getNsURI().equals(CDAPackage.eINSTANCE.getNsURI())) {
            for (EOperation eOperation : eClass.getEOperations()) {
                EObject objectToAdd;
                EOperation addOperation;
                if (!eOperation.getName().startsWith("get") || !(eOperation.getEType() instanceof EClass) || ((EClass)eOperation.getEType()).isAbstract() || (addOperation = InstanceGenerator.findAddOperation(eClass, eOperation)) == null || eClass.equals((objectToAdd = eOperation.getEGenericType().getEClassifier().getEPackage().getEFactoryInstance().create((EClass)eOperation.getEGenericType().getEClassifier())).eClass())) continue;
                if (UMLUtil.getTopPackage((Element)umlClass) != null) {
                    Class operationClass = UMLUtil.getClassByName((Package)UMLUtil.getTopPackage((Element)umlClass), (String)eOperation.getEGenericType().getEClassifier().getName());
                    if (operationClass == null) {
                        StringBuffer buffer = new StringBuffer();
                        for (String token : UMLUtil.splitName((String)eOperation.getEGenericType().getEClassifier().getName())) {
                            buffer.append(buffer.length() > 0 ? " " : "");
                            buffer.append(token);
                            operationClass = UMLUtil.getClassByName((Package)UMLUtil.getTopPackage((Element)umlClass), (String)buffer.toString());
                        }
                    }
                    if (operationClass != null) {
                        this.sampleInstanceInitialization(operationClass, objectToAdd, shallShouldMayProperties, level - 1);
                    }
                }
                InstanceGenerator.addObject(eClass, addOperation, eObject, objectToAdd);
            }
        }
        DatatypesInit datatypesInit = new DatatypesInit();
        CdaInit cdaInit = new CdaInit();
        for (EStructuralFeature structuralFeature : eClass.getEAllStructuralFeatures()) {
            Object result;
            if (structuralFeature.getLowerBound() <= 0 && !shallShouldMayProperties.containsKey(structuralFeature.getName())) continue;
            EClassifier sfEClass = structuralFeature.getEGenericType().getEClassifier();
            Property sfp = umlClass.getOwnedAttribute(structuralFeature.getName(), null);
            if (sfp != null) {
                sfEClass = this.getEClass(sfp.getType());
            }
            if (!(sfEClass instanceof EClass) || ((EClass)sfEClass).isAbstract()) continue;
            if (structuralFeature.isMany() && !structuralFeature.getName().equals("mixed")) {
                result = (EList)eObject.eGet(structuralFeature);
                if (result.size() != 0) continue;
                EObject objectToAdd = sfEClass.getEPackage().getEFactoryInstance().create((EClass)sfEClass);
                if (DatatypesPackage.eINSTANCE.getNsURI().equals(objectToAdd.eClass().getEPackage().getNsURI())) {
                    datatypesInit.setCurrentFeature(structuralFeature);
                    datatypesInit.doSwitch(objectToAdd);
                } else {
                    this.sampleInstanceInitialization(umlClass, objectToAdd, shallShouldMayProperties, level - 1);
                }
                try {
                    result.add((Object)objectToAdd);
                }
                catch (ClassCastException cce) {
                    System.out.println("Unable to add " + eClass.getName() + "." + structuralFeature.getName() + " using type " + objectToAdd.eClass().getName());
                }
                continue;
            }
            result = eObject.eGet(structuralFeature);
            if (result != null || !(structuralFeature.getEType() instanceof EClass)) continue;
            try {
                EObject objectToSet = structuralFeature.getEType().getEPackage().getEFactoryInstance().create((EClass)structuralFeature.getEType());
                eObject.eSet(structuralFeature, (Object)objectToSet);
                if (DatatypesPackage.eINSTANCE.getNsURI().equals(objectToSet.eClass().getEPackage().getNsURI())) {
                    datatypesInit.setCurrentFeature(structuralFeature);
                    datatypesInit.doSwitch(objectToSet);
                }
                cdaInit.doSwitch(objectToSet);
            }
            catch (Exception cce) {
                System.out.println("Unable to set " + eClass.getName() + "." + structuralFeature.getEType().getName() + structuralFeature.getName());
            }
        }
    }

    public InstanceGenerator() {
        CDAUtil.loadPackages();
    }

    public InstanceGenerator(boolean standalone) {
        this.standalone = standalone;
        CDAUtil.loadPackages();
    }

    public EObject createInstance(Class umlClass, int levels) {
        Package topPackage = UMLUtil.getTopPackage((Element)umlClass);
        Type type = topPackage.getOwnedType(null, false, UMLPackage.eINSTANCE.getArtifact(), false);
        EObject eObject = null;
        EClass eClass = this.getEClass((Type)umlClass);
        if (eClass != null) {
            CDAUtil.Query query;
            if (type != null && type instanceof Artifact) {
                Artifact sampleArtifact = (Artifact)type;
                try {
                    if (this.clinicalDocument == null) {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        IProject docProject = root.getProject(topPackage.eResource().getURI().segment(1).replace(".model", ".doc"));
                        if (docProject.exists()) {
                            IFile samplesFile;
                            IFolder samplesFolder = docProject.getFolder("samples");
                            if (samplesFolder.exists() && (samplesFile = samplesFolder.getFile(sampleArtifact.getFileName())).exists()) {
                                this.clinicalDocument = CDAUtil.load((InputStream)new FileInputStream(root.getLocation().append(samplesFile.getFullPath()).toFile()));
                            }
                        } else {
                            String[] segments;
                            URI uri = topPackage.eResource().getURI();
                            if (uri != null && (segments = uri.segments()).length > 3) {
                                String docProjectName = segments[segments.length - 3].replace(".model", ".doc");
                                String sampleInstancePath = uri.path();
                                if (sampleInstancePath != null) {
                                    sampleInstancePath = sampleInstancePath.replace(segments[segments.length - 3], docProjectName);
                                    sampleInstancePath = sampleInstancePath.replace(segments[segments.length - 2], "samples");
                                    File file = new File(sampleInstancePath = sampleInstancePath.replace(segments[segments.length - 1], sampleArtifact.getFileName()));
                                    if (file.exists()) {
                                        this.clinicalDocument = CDAUtil.load((InputStream)new FileInputStream(file));
                                    }
                                }
                            }
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.clinicalDocument != null && (eObject = (query = new CDAUtil.Query(this.clinicalDocument)).getEObject(eClass.getInstanceClass())) != null) {
                return EcoreUtil.copy((EObject)eObject);
            }
            HashMap<String, String> shallShouldMayProperties = InstanceGenerator.createshallShouldMayProperties();
            InstanceGenerator.createvalueSetProperies(umlClass, shallShouldMayProperties);
            if (eClass != null && !eClass.isAbstract()) {
                eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
                this.sampleInstanceInitialization(umlClass, eObject, shallShouldMayProperties, levels < 25 ? levels : 25);
            }
        }
        return eObject;
    }

    private EClass getEClass(Type umlType) {
        EClassifier eClassifier;
        EPackage ePackage;
        String ePackageURI = CDAModelUtil.getEcorePackageURI((Element)umlType);
        if (ePackageURI != null && (ePackage = this.getEPackageForURI(ePackageURI)) != null && umlType != null && (eClassifier = ePackage.getEClassifier(UML2Util.getValidJavaIdentifier((String)umlType.getName()))) instanceof EClass) {
            return (EClass)eClassifier;
        }
        return null;
    }

    private EPackage getEPackageForURI(String ePackageURI) {
        EPackage ePackage = this.packageURIMap.get(ePackageURI);
        if (!this.packageURIMap.containsKey(ePackageURI)) {
            ePackage = EPackage.Registry.INSTANCE.getEPackage(ePackageURI);
            this.packageURIMap.put(ePackageURI, ePackage);
            if (ePackage == null) {
                System.err.println("Cannot load EPackage for: " + ePackageURI);
            }
        }
        return ePackage;
    }

    public void save(EObject eObject, Writer writer) {
        try {
            if (eObject instanceof ClinicalDocument) {
                CDAUtil.save((ClinicalDocument)((ClinicalDocument)eObject), (Writer)writer);
            } else if (eObject instanceof InfrastructureRoot) {
                CDAUtil.saveSnippet((InfrastructureRoot)((InfrastructureRoot)eObject), (Writer)writer);
            } else {
                writer.write("Unable to create XML Snippet");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class CdaInit
    extends CDASwitch<Object> {
        Random randomGenerator = new Random();

        private CdaInit() {
        }

        public Object caseStrucDocText(StrucDocText object) {
            int numberOfParagraphs = this.randomGenerator.nextInt(4) + 1;
            StringBuffer sb = new StringBuffer();
            int p = 0;
            while (p < numberOfParagraphs) {
                int numberOfSentences = this.randomGenerator.nextInt(6) + 2;
                int s = 0;
                while (s < numberOfSentences) {
                    int numberOfWords = this.randomGenerator.nextInt(5) + 5;
                    int w = 0;
                    while (w < numberOfWords) {
                        sb.append(RandomStringUtils.randomAlphabetic((int)(this.randomGenerator.nextInt(5) + 5))).append(" ");
                        ++w;
                    }
                    ++s;
                }
                sb.append(System.getProperty("line.separator"));
                ++p;
            }
            object.addText(sb.toString());
            return object;
        }
    }

    private static class DatatypesInit
    extends DatatypesSwitch<Object> {
        private final Random random = new Random();
        EStructuralFeature feature;

        private DatatypesInit() {
        }

        public static String now(String dateFormat) {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            return sdf.format(cal.getTime());
        }

        public Object caseBL(BL bl) {
            bl.setValue(Boolean.valueOf(true));
            return bl;
        }

        public Object caseCS(CS object) {
            if ("statusCode".equals(this.feature.getName())) {
                object.setCode("completed");
            } else {
                object.setCode("Code for" + this.feature.getName());
            }
            return object;
        }

        public Object caseCD(CD object) {
            object.setCode(String.valueOf(Math.abs(this.random.nextInt())));
            return object;
        }

        public Object caseII(II ii) {
            if (this.feature.getName().equals("id")) {
                ii.setExtension(String.valueOf(Math.abs(this.random.nextInt())));
            } else {
                ii.setExtension(UUID.randomUUID().toString());
            }
            ii.setRoot("MDHT");
            return ii;
        }

        public Object caseIVL_TS(IVL_TS object) {
            IVXB_TS lowValue = DatatypesFactory.eINSTANCE.createIVXB_TS();
            lowValue.setValue(DatatypesInit.now("yyyy"));
            IVXB_TS highValue = DatatypesFactory.eINSTANCE.createIVXB_TS();
            highValue.setValue(DatatypesInit.now("yyyy"));
            object.setLow(lowValue);
            object.setHigh(highValue);
            return object;
        }

        public Object caseST(ST object) {
            if (object.getText() != null && object.getText().length() == 0 && object.eContainer() != null) {
                Section s;
                if (object.eContainer() instanceof Section && object.eContainingFeature().getName().equals("title") && (s = (Section)object.eContainer()).getCode() != null && s.getCode().getDisplayName() != null) {
                    return object.addText(s.getCode().getDisplayName());
                }
                if (object.eContainer() instanceof ClinicalDocument && object.eContainingFeature().getName().equals("title")) {
                    ClinicalDocument cd = (ClinicalDocument)object.eContainer();
                    if (cd.getCode() != null && cd.getCode().getDisplayName() != null) {
                        return object.addText(cd.getCode().getDisplayName());
                    }
                    StringBuffer buffer = new StringBuffer();
                    for (String token : UMLUtil.splitName((String)cd.getClass().getCanonicalName())) {
                        buffer.append(buffer.length() > 0 ? " " : "");
                        buffer.append(token);
                    }
                    return object.addText(buffer.toString());
                }
            }
            if (this.feature != null) {
                StringBuffer buffer = new StringBuffer();
                for (String token : UMLUtil.splitName((String)this.feature.getName())) {
                    buffer.append(buffer.length() > 0 ? " " : "");
                    buffer.append(token);
                }
                object.addText("TEXT FOR " + buffer.toString().toUpperCase());
            } else {
                object.addText("SAMPLE TEXT");
            }
            return object;
        }

        public Object caseSXCM_TS(SXCM_TS object) {
            object.setValue(DatatypesInit.now("yyyyMMdd"));
            return object;
        }

        public Object caseED(ED object) {
            object.addText("Text Value");
            return object;
        }

        public Object caseINT(INT object) {
            object.setValue(new Integer(1));
            return super.caseINT(object);
        }

        public Object defaultCase(EObject object) {
            return super.defaultCase(object);
        }

        public void setCurrentFeature(EStructuralFeature feature) {
            this.feature = feature;
        }
    }
}

