/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.profile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SeverityKind implements Enumerator
{
    ERROR(0, "ERROR", "ERROR"),
    WARNING(1, "WARNING", "WARNING"),
    INFO(2, "INFO", "INFO");

    public static final int ERROR_VALUE = 0;
    public static final int WARNING_VALUE = 1;
    public static final int INFO_VALUE = 2;
    private static final SeverityKind[] VALUES_ARRAY;
    public static final List<SeverityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SeverityKind[]{ERROR, WARNING, INFO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SeverityKind get(int value) {
        switch (value) {
            case 0: {
                return ERROR;
            }
            case 1: {
                return WARNING;
            }
            case 2: {
                return INFO;
            }
        }
        return null;
    }

    public static SeverityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SeverityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SeverityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SeverityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private SeverityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

