/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.navigator.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.mdht.uml.ui.navigator.UMLDomainNavigatorItem;
import org.eclipse.mdht.uml.ui.navigator.internal.plugin.Activator;
import org.eclipse.swt.graphics.Image;

public class ProblemsDecorator
implements ILabelDecorator {
    private List cachedResources = new ArrayList();
    private Map errorMarkers = new HashMap();
    private Map warningMarkers = new HashMap();
    private IValidationListener validationListener = new IValidationListener(){

        public void validationOccurred(ValidationEvent event) {
            if (event.getClientContextIds().contains("org.eclipse.mdht.uml.ui.validation.refresh") && event.getEvaluationMode() == EvaluationMode.BATCH) {
                ProblemsDecorator.this.cachedResources.clear();
                ProblemsDecorator.this.errorMarkers.clear();
                ProblemsDecorator.this.warningMarkers.clear();
                ProblemsDecorator.this.cacheMarkers(event.getValidationTargets());
            }
        }
    };

    public ProblemsDecorator() {
        ModelValidationService.getInstance().addValidationListener(this.validationListener);
    }

    public void dispose() {
        ModelValidationService.getInstance().removeValidationListener(this.validationListener);
    }

    protected void cacheMarkers(Collection targets) {
        for (Object target : targets) {
            if (!(target instanceof EObject)) continue;
            this.cacheMarkers((EObject)target);
        }
    }

    private void cacheMarkers(EObject eObject) {
        URI resourceURI = eObject.eResource().getURI();
        if (!this.cachedResources.contains(resourceURI)) {
            this.cachedResources.add(resourceURI);
        }
        IMarker[] markers = this.getValidationMarkers(eObject);
        int i = 0;
        while (i < markers.length) {
            try {
                int markerSeverity;
                EObject markerEObject = null;
                Object markerURIAttr = markers[i].getAttribute("uri");
                if (markerURIAttr != null) {
                    URI markerURI = URI.createURI((String)markerURIAttr.toString());
                    markerEObject = eObject.eResource().getEObject(markerURI.fragment());
                }
                if (2 == (markerSeverity = ((Integer)markers[i].getAttribute("severity")).intValue())) {
                    EObject errorObject = markerEObject;
                    while (errorObject != null) {
                        this.errorMarkers.put(errorObject, markers[i]);
                        errorObject = errorObject.eContainer();
                    }
                } else if (1 == markerSeverity) {
                    EObject warningObject = markerEObject;
                    while (warningObject != null) {
                        this.warningMarkers.put(warningObject, markers[i]);
                        warningObject = warningObject.eContainer();
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++i;
        }
    }

    private IMarker[] getValidationMarkers(EObject eObject) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)eObject.eResource());
        if (file != null) {
            try {
                return file.findMarkers("org.eclipse.emf.ecore.diagnostic", true, 0);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return new IMarker[0];
    }

    public boolean hasError(EObject eObject) {
        URI resourceURI = eObject.eResource().getURI();
        if (!this.cachedResources.contains(resourceURI)) {
            this.cacheMarkers(eObject);
        }
        return this.errorMarkers.get(eObject) != null;
    }

    public boolean hasWarning(EObject eObject) {
        URI resourceURI = eObject.eResource().getURI();
        if (!this.cachedResources.contains(resourceURI)) {
            this.cacheMarkers(eObject);
        }
        return this.warningMarkers.get(eObject) != null;
    }

    public Image decorateImage(Image image, Object element) {
        EObject eObject = null;
        if (element instanceof EObject) {
            eObject = (EObject)element;
        } else if (element instanceof UMLDomainNavigatorItem) {
            eObject = ((UMLDomainNavigatorItem)((Object)element)).getEObject();
        }
        if (eObject != null && eObject.eResource() != null) {
            if (this.hasError(eObject)) {
                return this.getErrorIcon(image);
            }
            if (this.hasWarning(eObject)) {
                return this.getWarningIcon(image);
            }
        }
        return image;
    }

    private Image getErrorIcon(Image baseImage) {
        ImageDescriptor errorIcon = Activator.getBundledImageDescriptor("icons/ovr16/error_co.gif");
        DecorationOverlayIcon decorated = new DecorationOverlayIcon(baseImage, errorIcon, 2);
        return ExtendedImageRegistry.getInstance().getImage((Object)decorated);
    }

    private Image getWarningIcon(Image baseImage) {
        ImageDescriptor errorIcon = Activator.getBundledImageDescriptor("icons/ovr16/warning_co.gif");
        DecorationOverlayIcon decorated = new DecorationOverlayIcon(baseImage, errorIcon, 2);
        return ExtendedImageRegistry.getInstance().getImage((Object)decorated);
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

