/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform.ui.actions;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.mdht.uml.transform.FlattenTransformer;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ui.actions.UML2AbstractAction;
import org.eclipse.uml2.uml.Element;

public class FlattenModelAction
extends UML2AbstractAction {
    public void run(IAction action) {
        boolean includeBaseModel = true;
        boolean useBusinessNames = true;
        String outputModelPath = null;
        String vocabModelPath = null;
        try {
            HashMap saveOptions;
            final List<Element> elements = this.getSelectedElements();
            if (elements.isEmpty()) {
                return;
            }
            TransformerOptions options = new TransformerOptions();
            options.setIncludeBaseModel(includeBaseModel);
            options.setUseBusinessNames(useBusinessNames);
            options.setOutputModelPath(outputModelPath);
            options.setVocabModelPath(vocabModelPath);
            final FlattenTransformer transformer = new FlattenTransformer(options);
            AbstractEMFOperation operation = new AbstractEMFOperation(this.editingDomain, "Flatten Model"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    transformer.initialize(((Element)elements.get(0)).getNearestPackage());
                    for (Element element : elements) {
                        transformer.transformModelElement(element);
                    }
                    transformer.saveResources();
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)this.editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), (IAdaptable)this.activePart);
            }
            catch (ExecutionException ee) {
                throw new RuntimeException(ee.getCause());
            }
            if (transformer.getFlattenedPackage() != null) {
                saveOptions = new HashMap();
                transformer.getFlattenedPackage().eResource().save(saveOptions);
            }
            if (transformer.getFlattenedVocabPackage() != null) {
                saveOptions = new HashMap();
                transformer.getFlattenedVocabPackage().eResource().save(saveOptions);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

