/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.ui.internal.Logger;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class AssignConformanceRuleIdsAction
implements IObjectActionDelegate {
    protected IWorkbenchPart activePart;
    protected ISelection currentSelection;
    protected Element selectedElement;
    private String rulePrefix = "CONF:";
    private int lastId = 0;

    private void assignConformanceRuleIds(Element element) {
        TreeIterator iterator = EcoreUtil.getAllContents(Collections.singletonList(element));
        while (iterator != null && iterator.hasNext()) {
            EObject child = (EObject)iterator.next();
            UMLSwitch<Object> umlSwitch = new UMLSwitch<Object>(){

                public Object caseAssociation(Association association) {
                    AssignConformanceRuleIdsAction.this.setRuleId((Element)association);
                    return association;
                }

                public Object caseClass(Class umlClass) {
                    AssignConformanceRuleIdsAction.this.setRuleId(umlClass);
                    return umlClass;
                }

                public Object caseConstraint(Constraint constraint) {
                    if (!CDAModelUtil.hasValidationSupport((Element)constraint)) {
                        CDAProfileUtil.applyCDAStereotype((Element)constraint, (String)"ConstraintValidation");
                    }
                    AssignConformanceRuleIdsAction.this.setRuleId((Element)constraint);
                    return constraint;
                }

                public Object caseGeneralization(Generalization generalization) {
                    AssignConformanceRuleIdsAction.this.setRuleId((Element)generalization);
                    return generalization;
                }

                public Object caseProperty(Property property) {
                    AssignConformanceRuleIdsAction.this.setRuleId((Element)property);
                    Association association = property.getAssociation();
                    if (association != null) {
                        AssignConformanceRuleIdsAction.this.setRuleId((Element)association);
                    }
                    return property;
                }
            };
            umlSwitch.doSwitch(child);
        }
    }

    private void findLastId() {
        TreeIterator iterator = EcoreUtil.getAllContents(Collections.singletonList(UMLUtil.getTopPackage((Element)this.selectedElement)));
        while (iterator != null && iterator.hasNext()) {
            EObject child = (EObject)iterator.next();
            UMLSwitch<Object> umlSwitch = new UMLSwitch<Object>(){

                public Object caseElement(Element element) {
                    for (String ruleId : CDAModelUtil.getConformanceRuleIdList((Element)element)) {
                        int lastDash = ruleId.lastIndexOf("-");
                        int lastColon = ruleId.lastIndexOf(":");
                        try {
                            int ruleNumber = -1;
                            if (lastDash >= 0) {
                                ruleNumber = Integer.parseInt(ruleId.substring(lastDash + 1));
                            } else if (lastColon >= 0) {
                                ruleNumber = Integer.parseInt(ruleId.substring(lastColon + 1));
                            }
                            if (ruleNumber <= AssignConformanceRuleIdsAction.this.lastId) continue;
                            AssignConformanceRuleIdsAction.this.lastId = ruleNumber;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return element;
                }
            };
            umlSwitch.doSwitch(child);
        }
    }

    protected View getSelectedView() {
        for (Object element : (IStructuredSelection)this.currentSelection) {
            View view = (View)((IAdaptable)element).getAdapter(View.class);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    public void run(IAction action) {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.selectedElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Remove Validation Messages"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    AssignConformanceRuleIdsAction.this.findLastId();
                    AssignConformanceRuleIdsAction.this.assignConformanceRuleIds(AssignConformanceRuleIdsAction.this.selectedElement);
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                Logger.logException(ee);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
        this.selectedElement = null;
        if (((IStructuredSelection)selection).size() == 1) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(EObject.class);
            }
            if (selected instanceof View) {
                selected = ((View)selected).getElement();
            }
            if (selected instanceof Element) {
                this.selectedElement = (Element)selected;
            }
        }
        if (this.selectedElement != null && CDAProfileUtil.getAppliedCDAProfile((Element)this.selectedElement) != null) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }

    private void setRuleId(Class umlClass) {
        List appliedStereotypes = CDAProfileUtil.getAppliedStereotypes((Element)umlClass, (String)"Validation");
        for (Stereotype stereotype : appliedStereotypes) {
            Object value = umlClass.getValue(stereotype, "ruleId");
            if (value != null && (!(value instanceof List) || !((List)value).isEmpty())) continue;
            String ruleId = String.valueOf(this.rulePrefix) + ++this.lastId;
            ArrayList<String> ruleIds = new ArrayList<String>();
            ruleIds.add(ruleId);
            umlClass.setValue(stereotype, "ruleId", ruleIds);
        }
    }

    private void setRuleId(Element element) {
        List appliedStereotypes = CDAProfileUtil.getAppliedStereotypes((Element)element, (String)"Validation");
        for (Stereotype stereotype : appliedStereotypes) {
            Object value = element.getValue(stereotype, "ruleId");
            if (value != null && (!(value instanceof List) || !((List)value).isEmpty())) continue;
            String ruleId = String.valueOf(this.rulePrefix) + ++this.lastId;
            ArrayList<String> ruleIds = new ArrayList<String>();
            ruleIds.add(ruleId);
            element.setValue(stereotype, "ruleId", ruleIds);
        }
    }
}

