/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.validation.internal.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.mdht.uml.validation.ConstraintProvider;
import org.eclipse.mdht.uml.validation.Diagnostic;
import org.eclipse.mdht.uml.validation.internal.ValidationPlugin;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.osgi.framework.Bundle;

public class ValidationProfileUtil {
    private static final String ECORE_EPACKAGE_STEREOTYPE = "Ecore::EPackage";
    private static final String ECORE_EPACKAGE_NSURI = "nsURI";
    private static final Pattern BUNDLE_ID_PATTERN = Pattern.compile("^\\d+");

    private ValidationProfileUtil() {
    }

    public static Diagnostic getDiagnostic(Constraint constraint) {
        return ValidationProfileUtil.getApplication((Element)constraint, Diagnostic.class);
    }

    public static ConstraintProvider getConstraintProvider(Namespace namespace) {
        return ValidationProfileUtil.getApplication((Element)namespace, ConstraintProvider.class);
    }

    static <T extends EObject> T getApplication(Element element, Class<? extends T> stereotype) {
        EObject result = null;
        for (EObject next : element.getStereotypeApplications()) {
            if (!stereotype.isInstance(next)) continue;
            result = (EObject)stereotype.cast(next);
            break;
        }
        return (T)result;
    }

    public static Iterable<Profile> getValidatingProfiles(Package context) {
        ArrayList<Profile> result = new ArrayList<Profile>(context.getAppliedProfiles().size());
        for (Profile next : context.getAppliedProfiles()) {
            if (ValidationProfileUtil.getConstraintProvider((Namespace)next) == null) continue;
            result.add(next);
        }
        return Collections.unmodifiableCollection(result);
    }

    public static URIConverter getURIConverter(EObject context) {
        ResourceSet rset;
        URIConverter result = URIConverter.INSTANCE;
        Resource res = context.eResource();
        ResourceSet resourceSet = rset = res == null ? null : res.getResourceSet();
        if (rset != null) {
            result = rset.getURIConverter();
        }
        return result;
    }

    public static String getBundleName(Profile profile) {
        URI locationURI;
        String nsURI;
        String result;
        ConstraintProvider constraintProvider = ValidationProfileUtil.getConstraintProvider((Namespace)profile);
        String string = result = constraintProvider == null ? null : constraintProvider.getBundleName();
        if (result == null && (nsURI = (String)UMLUtil.getTaggedValue((Element)profile, (String)ECORE_EPACKAGE_STEREOTYPE, (String)ECORE_EPACKAGE_NSURI)) != null && (locationURI = (URI)UMLPlugin.getEPackageNsURIToProfileLocationMap().get(nsURI)) != null) {
            locationURI = ValidationProfileUtil.getURIConverter((EObject)profile).normalize(locationURI);
            if (locationURI.isPlatformPlugin()) {
                result = locationURI.segment(1);
            } else if ("bundleentry".equals(locationURI.scheme())) {
                Bundle bundle;
                String bundleID = locationURI.authority();
                Matcher m = BUNDLE_ID_PATTERN.matcher(bundleID);
                if (m.find()) {
                    bundleID = m.group();
                }
                result = (bundle = ValidationPlugin.getPlugin().getBundle().getBundleContext().getBundle(Long.parseLong(bundleID))) == null ? null : bundle.getSymbolicName();
            }
        }
        return ValidationProfileUtil.nullSafeTrim(result, true);
    }

    public static String nullSafeTrim(String s) {
        String result = s == null ? s : s.trim();
        return result;
    }

    public static String nullSafeTrim(String s, boolean preferNull) {
        String result = ValidationProfileUtil.nullSafeTrim(s);
        return preferNull && (result == null || result.length() == 0) ? null : result;
    }

    public static Iterable<Package> getAllImportedPackages(Package package_) {
        ArrayList<Package> result = new ArrayList<Package>();
        LinkedList queue = new LinkedList(package_.getImportedPackages());
        HashSet<Package> seen = new HashSet<Package>();
        seen.add(package_);
        Package next = (Package)queue.poll();
        while (next != null) {
            Package poll = (Package)queue.poll();
            if (poll == null) break;
            if (seen.add(poll)) {
                queue.addAll(poll.getImportedPackages());
                result.add(poll);
            }
            next = (Package)queue.poll();
        }
        return Collections.unmodifiableCollection(result);
    }
}

