/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CDAPackageLoader {
    private static boolean packagesLoaded = false;

    public static boolean isPackagesLoaded() {
        return packagesLoaded;
    }

    protected static final void loadPackages() {
        if (!packagesLoaded) {
            String PATH_SEPARATOR = System.getProperty("path.separator");
            String JAVA_CLASSPATH = System.getProperty("java.class.path");
            String BIN = "bin";
            String PLUGINXML = "plugin.xml";
            StringTokenizer st = new StringTokenizer(JAVA_CLASSPATH, PATH_SEPARATOR);
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                if (path.endsWith(".jar") || path.endsWith(".zip")) {
                    try {
                        CDAPackageLoader.processModelPlugin(new ZipFile(path));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!path.endsWith("bin")) continue;
                String pluginPath = String.valueOf(path.substring(0, path.lastIndexOf("bin"))) + "plugin.xml";
                try {
                    FileInputStream pluginInputSteam = new FileInputStream(pluginPath);
                    CDAPackageLoader.processPluginXML(pluginInputSteam);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            packagesLoaded = true;
        }
    }

    protected static final void loadPackages(String dir) {
        if (!packagesLoaded) {
            File directory = new File(dir);
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().toLowerCase().endsWith(".jar") && files[i].exists()) {
                    try {
                        CDAPackageLoader.processModelPlugin(new ZipFile(files[i]));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            packagesLoaded = true;
        }
    }

    private static void processModelPlugin(ZipFile zipFile) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, ClassNotFoundException, SecurityException, NoSuchFieldException {
        ZipEntry pluginEntry = zipFile.getEntry("plugin.xml");
        if (pluginEntry != null) {
            CDAPackageLoader.processPluginXML(zipFile.getInputStream(pluginEntry));
        }
    }

    private static void processPluginXML(InputStream pluginStream) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, ClassNotFoundException, SecurityException, NoSuchFieldException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        XPathExpression expr = null;
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.parse(new InputSource(pluginStream));
        XPathFactory xFactory = XPathFactory.newInstance();
        XPath xpath = xFactory.newXPath();
        expr = xpath.compile("//plugin/extension[@point='org.eclipse.emf.ecore.generated_package']/package");
        Object result = expr.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        int i = 0;
        while (i < nodes.getLength()) {
            String packageClass = nodes.item(i).getAttributes().getNamedItem("class").getNodeValue();
            if (packageClass != null) {
                Class<?> c = Class.forName(packageClass);
                c.getDeclaredField("eINSTANCE");
            }
            ++i;
        }
    }
}

