/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class NoErrorLoggedRule
implements BeforeEachCallback,
AfterEachCallback {
    private ILog log;
    private ILogListener listener;
    private final List<IStatus> loggedErrors = new ArrayList<IStatus>();

    public NoErrorLoggedRule() {
        this(LanguageServerPlugin.getDefault().getLog());
    }

    public NoErrorLoggedRule(ILog log) {
        this.log = log;
        System.Logger logger = System.getLogger(log.getBundle().getSymbolicName());
        this.listener = (status, unused) -> {
            switch (status.getSeverity()) {
                case 4: {
                    this.loggedErrors.add(status);
                    logger.log(System.Logger.Level.ERROR, status.toString(), status.getException());
                    break;
                }
                case 2: {
                    logger.log(System.Logger.Level.WARNING, status.toString(), status.getException());
                    break;
                }
                case 1: {
                    logger.log(System.Logger.Level.INFO, status.toString(), status.getException());
                }
            }
        };
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.loggedErrors.clear();
        this.log.addLogListener(this.listener);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.log.removeLogListener(this.listener);
        Assertions.assertEquals(Collections.emptyList(), this.loggedErrors, (String)"Some errors were logged");
    }
}

