/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite.iteration;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.hawk.sqlite.iteration.ResultSetFunction;
import org.eclipse.hawk.sqlite.iteration.StatementSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementIterable<T>
implements Iterable<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementIterable.class);
    private final StatementSupplier stmtSupplier;
    private final ResultSetFunction<T> resultToEdge;

    public StatementIterable(StatementSupplier stmtSupplier, ResultSetFunction<T> fn) {
        this.stmtSupplier = stmtSupplier;
        this.resultToEdge = fn;
    }

    @Override
    public Iterator<T> iterator() {
        try {
            PreparedStatement stmt = this.stmtSupplier.get();
            ArrayList<T> results = new ArrayList<T>();
            Throwable throwable = null;
            Object var4_6 = null;
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    results.add(this.resultToEdge.apply(rs));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return results.iterator();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyIterator();
        }
    }
}

