/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnUtil {
    static {
        SvnUtil.setupLibrary();
    }

    public static SVNRepository connectToSVNInstance(String url) {
        SVNRepository repository = null;
        try {
            repository = SvnUtil.createRepository(url);
        }
        catch (SVNException svne) {
            System.err.println("error while creating an SVNRepository for location '" + url + "': " + svne.getMessage());
        }
        try {
            SvnUtil.verifySVNLocation(repository, url);
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
        return repository;
    }

    public static SVNRepository connectToSVNInstance(String url, String usr, String pass) {
        SVNRepository repository = null;
        try {
            repository = SvnUtil.createRepository(url);
        }
        catch (SVNException svne) {
            System.err.println("error while creating an SVNRepository for location '" + url + "': " + svne.getMessage());
        }
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)usr, (String)pass);
        repository.setAuthenticationManager(authManager);
        try {
            SvnUtil.verifySVNLocation(repository, url);
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
        return repository;
    }

    public static void authenticate(String usr, String pass, SVNRepository repo) {
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)usr, (String)pass);
        repo.setAuthenticationManager(authManager);
    }

    public static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public static SVNRepository createRepository(String url) throws SVNException {
        return SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
    }

    public static void verifySVNLocation(SVNRepository repository, String url) throws SVNException {
        SVNNodeKind nodeKind = repository.checkPath("", -1L);
        if (nodeKind == SVNNodeKind.NONE) {
            System.err.println("There is no entry at '" + url + "'.");
        } else if (nodeKind == SVNNodeKind.FILE) {
            System.err.println("The entry at '" + url + "' is a file while a directory was expected.");
        }
    }

    public static void listEntries(SVNRepository repository, String path) throws SVNException {
        Collection entries = repository.getDir(path, -1L, null, null);
        for (SVNDirEntry entry : entries) {
            System.out.println("/" + (path.equals("") ? "" : String.valueOf(path) + "/") + entry.getName() + " (author: '" + entry.getAuthor() + "'; revision: " + entry.getRevision() + "; date: " + entry.getDate() + ")");
            if (entry.getKind() != SVNNodeKind.DIR) continue;
            SvnUtil.listEntries(repository, path.equals("") ? entry.getName() : String.valueOf(path) + "/" + entry.getName());
        }
    }

    public static List<SVNDirEntry> getEntries(SVNRepository repository, String path) throws SVNException {
        Collection entries = repository.getDir(path, -1L, null, null);
        ArrayList<SVNDirEntry> entryURLs = new ArrayList<SVNDirEntry>();
        for (SVNDirEntry entry : entries) {
            entryURLs.add(entry);
            if (entry.getKind() != SVNNodeKind.DIR) continue;
            entryURLs.addAll(SvnUtil.getEntries(repository, path.equals("") ? entry.getName() : String.valueOf(path) + "/" + entry.getName()));
        }
        return entryURLs;
    }
}

