/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.scopes;

import java.util.Collections;
import java.util.List;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.timeaware.queries.operations.scopes.AbstractSingleWrapTimeAwareNodeWrapper;

public class EndingTimeAwareNodeWrapper
extends AbstractSingleWrapTimeAwareNodeWrapper {
    private final long toInclusive;

    public EndingTimeAwareNodeWrapper(ITimeAwareGraphNode original) {
        this(original, original.getTime());
    }

    public EndingTimeAwareNodeWrapper(ITimeAwareGraphNode original, long toInclusive) {
        super(original);
        this.toInclusive = toInclusive;
    }

    public List<Long> getAllInstants() throws Exception {
        return this.original.getInstantsUpTo(this.toInclusive);
    }

    public long getEarliestInstant() throws Exception {
        return this.original.getEarliestInstant();
    }

    public long getPreviousInstant() throws Exception {
        return this.original.getPreviousInstant();
    }

    public long getLatestInstant() throws Exception {
        return Math.min(this.toInclusive, this.original.getLatestInstant());
    }

    public long getNextInstant() throws Exception {
        return Math.min(this.toInclusive, this.original.getNextInstant());
    }

    public ITimeAwareGraphNode travelInTime(long time) {
        long actualTime = Math.min(time, this.toInclusive);
        return this.wrap(this.original.travelInTime(actualTime));
    }

    public List<Long> getInstantsBetween(long fromInclusive, long toInclusive) {
        if (this.toInclusive < fromInclusive) {
            return Collections.emptyList();
        }
        long actualToTime = Math.min(toInclusive, this.toInclusive);
        return this.original.getInstantsBetween(fromInclusive, actualToTime);
    }

    public List<Long> getInstantsFrom(long fromInclusive) {
        long actualFromTime = Math.min(fromInclusive, this.toInclusive);
        return this.original.getInstantsFrom(actualFromTime);
    }

    public List<Long> getInstantsUpTo(long toInclusive) {
        long actualToTime = Math.min(toInclusive, this.toInclusive);
        return this.original.getInstantsUpTo(actualToTime);
    }

    @Override
    protected ITimeAwareGraphNode wrap(ITimeAwareGraphNode n) {
        return new EndingTimeAwareNodeWrapper(n, this.toInclusive);
    }
}

