/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emf;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.emf.EMFModelElement;
import org.eclipse.hawk.emf.EMFWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFClass
extends EMFModelElement
implements IHawkClass {
    public static final String NULL_EPACKAGE = "NULL_EPACKAGE";
    public static final String NULL_INSTANCE_TYPE = "NULL_INSTANCE_TYPE";
    private static final Logger LOGGER = LoggerFactory.getLogger(EMFClass.class);
    protected EClass eClass;

    public EMFClass(EClass o, EMFWrapperFactory wf) {
        super((EModelElement)o, wf);
        this.eClass = o;
    }

    public EClass getEObject() {
        return this.eClass;
    }

    public String getName() {
        return this.eClass.getName();
    }

    public String getInstanceType() {
        String it = this.eClass.getInstanceClassName();
        switch (it = it == null ? NULL_INSTANCE_TYPE : it) {
            case "long": {
                return Long.class.getName();
            }
            case "int": {
                return Integer.class.getName();
            }
            case "float": {
                return Float.class.getName();
            }
            case "double": {
                return Double.class.getName();
            }
            case "boolean": {
                return Boolean.class.getName();
            }
        }
        return it;
    }

    public String getPackageNSURI() {
        EPackage ep = this.eClass.getEPackage();
        if (this.eClass.eIsProxy()) {
            LOGGER.warn("WARNING -- proxy class: {}", (Object)this.eClass.toString());
        }
        return ep == null ? NULL_EPACKAGE : ep.getNsURI();
    }

    public HashSet<IHawkAttribute> getAllAttributes() {
        HashSet<IHawkAttribute> atts = new HashSet<IHawkAttribute>();
        for (EAttribute att : this.eClass.getEAllAttributes()) {
            atts.add(this.wf.createAttribute(att));
        }
        return atts;
    }

    public Set<IHawkClass> getAllSuperTypes() {
        HashSet<IHawkClass> c = new HashSet<IHawkClass>();
        for (EClass e : this.eClass.getEAllSuperTypes()) {
            c.add(this.wf.createClass(e));
        }
        return c;
    }

    public Set<IHawkClass> getSuperTypes() {
        return this.getAllSuperTypes();
    }

    public HashSet<IHawkReference> getAllReferences() {
        HashSet<IHawkReference> c = new HashSet<IHawkReference>();
        for (EReference e : this.eClass.getEAllReferences()) {
            c.add(this.wf.createReference(e));
        }
        for (EAttribute att : this.eClass.getEAllAttributes()) {
            if (att.getEType().getInstanceClass() != FeatureMap.Entry.class) continue;
            c.add(this.wf.createFeatureMapReference(att));
        }
        return c;
    }

    public boolean isAbstract() {
        return this.eClass.isAbstract();
    }

    public boolean isInterface() {
        return this.eClass.isInterface();
    }

    public IHawkStructuralFeature getStructuralFeature(String name) {
        EStructuralFeature esf = this.eClass.getEStructuralFeature(name);
        if (esf instanceof EAttribute) {
            if (esf.getEType().getInstanceClass() == FeatureMap.Entry.class) {
                return this.wf.createFeatureMapReference((EAttribute)esf);
            }
            return this.wf.createAttribute((EAttribute)esf);
        }
        if (esf instanceof EReference) {
            return this.wf.createReference((EReference)esf);
        }
        LOGGER.warn("getEStructuralFeature({}) is not an attribute nor a reference: BUG?", (Object)name);
        return null;
    }

    @Override
    public int hashCode() {
        return this.eClass.hashCode();
    }
}

