/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.emf;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.graph.syncValidationListener.SyncValidationListener;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.eclipse.hawk.integration.tests.mm.Tree.Tree;
import org.eclipse.hawk.integration.tests.mm.Tree.TreeFactory;
import org.eclipse.hawk.integration.tests.mm.Tree.TreePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public class DerivedFromMetaPropertiesTest
extends ModelIndexingTest {
    @Rule
    public ModelIndexingTest.GraphChangeListenerRule<SyncValidationListener> syncValidation = new ModelIndexingTest.GraphChangeListenerRule((ModelIndexingTest)this, (IGraphChangeListener)new SyncValidationListener());
    @Rule
    public TemporaryFolder modelFolder = new TemporaryFolder();
    private ResourceSetImpl rs;
    private Tree tRoot;

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public DerivedFromMetaPropertiesTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new EMFModelSupportFactory());
    }

    @Before
    public void setUp() throws Throwable {
        this.rs = new ResourceSetImpl();
        this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        this.rs.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        this.rs.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        this.rs.getPackageRegistry().put((Object)"Tree", (Object)TreePackage.eINSTANCE);
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore")});
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/XMLType.ecore")});
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Tree.ecore")});
        this.tRoot = this.tn("root", this.tn("childA", this.tn("childAA", new Tree[0])), this.tn("childB", new Tree[0]));
        TreeIterator itTree = this.tRoot.eAllContents();
        while (itTree.hasNext()) {
            this.save((Tree)itTree.next());
        }
        this.save(this.tRoot);
        for (Resource r : this.rs.getResources()) {
            r.save(null);
        }
        this.requestFolderIndex(this.modelFolder.getRoot());
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            return null;
        });
    }

    protected void save(Tree tree) {
        Resource r = this.rs.createResource(URI.createFileURI((String)new File(this.modelFolder.getRoot(), String.valueOf(tree.getLabel()) + ".xmi").getAbsolutePath()));
        r.getContents().add((Object)tree);
    }

    @Test
    public void eContainersIsUpdatedRoot() throws Throwable {
        this.indexer.addDerivedAttribute("Tree", "Tree", "allContainers", "Tree", true, false, true, "org.eclipse.hawk.epsilon.emc.EOLQueryEngine", "return self.closure(e|e.eContainers);");
        Assert.assertEquals((Object)2, (Object)this.eol("return Tree.all.selectOne(t|t.label='childAA').allContainers.size;"));
        Assert.assertEquals((Object)3, (Object)this.eol("return Tree.all.selectOne(t|t.label='root').revRefNav_allContainers.size;"));
        this.tRoot.setLabel("changed");
        this.tRoot.eResource().save(null);
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            Assert.assertEquals(new HashSet<String>(Arrays.asList("changed", "childA")), (Object)this.eol("return Tree.all.selectOne(t|t.label='childAA').allContainers.collect(c|c.label).asSet;"));
            Assert.assertEquals(new HashSet<String>(Arrays.asList("childA", "childAA", "childB")), (Object)this.eol("return Tree.all.selectOne(t|t.label='changed').revRefNav_allContainers.collect(c|c.label).asSet;"));
            return null;
        });
    }

    protected Tree tn(String label, Tree ... children) {
        Tree tNode = TreeFactory.eINSTANCE.createTree();
        tNode.setLabel(label);
        Tree[] treeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Tree child = treeArray[n2];
            tNode.getChildren().add((Object)child);
            ++n2;
        }
        return tNode;
    }
}

