/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.pgetters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.util.Utils;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.contextful.CEOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.pgetters.GraphPropertyGetter;
import org.eclipse.hawk.graph.ModelElementNode;

public class CGraphPropertyGetter
extends GraphPropertyGetter {
    private final CEOLQueryEngine engine;

    public CGraphPropertyGetter(IGraphDatabase graph, CEOLQueryEngine m) {
        super(graph, m);
        this.engine = m;
    }

    @Override
    public Object invoke(Object object, String property) throws EolRuntimeException {
        Object ret = null;
        if (!(object instanceof EOLQueryEngine.GraphNodeWrapper)) {
            throw new EolRuntimeException("a non GraphNodeWrapper object passed to GraphPropertyGetter!");
        }
        IGraphNode node = ((EOLQueryEngine.GraphNodeWrapper)object).getNode();
        if (property.equals("hawkFile")) {
            String sep = "";
            StringBuilder buff = new StringBuilder(32);
            for (IGraphEdge e : node.getOutgoingWithType("_hawkFile")) {
                buff.append(sep);
                buff.append(e.getEndNode().getProperty("_hawkid").toString());
                sep = ";";
            }
            ret = buff.toString();
        } else if (property.equals("hawkRepo")) {
            String sep = "";
            StringBuilder buff = new StringBuilder(32);
            for (IGraphEdge e : node.getOutgoingWithType("_hawkFile")) {
                buff.append(sep);
                buff.append(e.getEndNode().getProperty("repository").toString());
                sep = ";";
            }
            ret = buff.toString();
        } else if (property.equals("hawkFiles")) {
            HashSet<String> files = new HashSet<String>();
            for (IGraphEdge e : node.getOutgoingWithType("_hawkFile")) {
                files.add(e.getEndNode().getProperty("_hawkid").toString());
            }
            ret = files;
        } else if (property.equals("hawkRepos")) {
            HashSet<String> repos = new HashSet<String>();
            for (IGraphEdge e : node.getOutgoingWithType("_hawkFile")) {
                repos.add(e.getEndNode().getProperty("repository").toString());
            }
            ret = repos;
        } else if (property.startsWith("revRefNav_")) {
            EolSequence nodes = new EolSequence();
            String referenceName = property.substring("revRefNav_".length());
            for (IGraphEdge r : node.getIncomingWithType(referenceName)) {
                EOLQueryEngine.GraphNodeWrapper n = this.wrapIfInScope(r.getStartNode());
                if (n == null) continue;
                nodes.add(n);
            }
            for (IGraphEdge r : node.getIncomingWithType("de" + referenceName)) {
                IGraphNode derivedNode = r.getStartNode();
                IGraphNode elementNode = ((IGraphEdge)derivedNode.getIncoming().iterator().next()).getStartNode();
                EOLQueryEngine.GraphNodeWrapper n = this.wrapIfInScope(elementNode);
                if (n == null) continue;
                nodes.add(n);
            }
            ret = nodes;
        } else if (property.equals("eContainer")) {
            Iterable inc = node.getIncoming();
            for (IGraphEdge r : inc) {
                if (r.getProperty("isContainment") == null) continue;
                ret = this.wrapIfInScope(r.getStartNode());
                break;
            }
            if (ret == null) {
                throw new EolRuntimeException("eContainer failed,\n" + object + "\nis not contained in current scope");
            }
        } else if (property.equals("eContents")) {
            ret = this.getContents(node);
        } else if (property.equals("eAllContents")) {
            ret = this.addAllContents(node, new ArrayList<EOLQueryEngine.GraphNodeWrapper>());
        } else if (property.equals("eContainers")) {
            for (IGraphEdge r : node.getIncoming()) {
                if (r.getProperty("isContainment") == null) continue;
                ret = this.wrapIfInScope(r.getStartNode());
            }
            if (ret == null) {
                for (IGraphEdge r : node.getOutgoing()) {
                    if (r.getProperty("isContainer") == null) continue;
                    ret = this.wrapIfInScope(r.getEndNode());
                    break;
                }
            }
            ret = ret == null ? Collections.emptyList() : Collections.singletonList(ret);
        } else if (property.equals("hawkIn") || property.equals("hawkOut")) {
            boolean isIncoming = property.equals("hawkIn");
            ArrayList<EOLQueryEngine.GraphNodeWrapper> results = new ArrayList<EOLQueryEngine.GraphNodeWrapper>();
            Iterable edges = isIncoming ? node.getIncoming() : node.getOutgoing();
            for (IGraphEdge r : edges) {
                if (ModelElementNode.TRANSIENT_EDGE_LABELS.contains(r.getType())) continue;
                IGraphNode edgeNode = isIncoming ? r.getStartNode() : r.getEndNode();
                EOLQueryEngine.GraphNodeWrapper edgeNodeWrapper = this.wrapIfInScope(edgeNode);
                results.add(edgeNodeWrapper);
            }
            ret = results;
        } else {
            if (property.equals("hawkProxies")) {
                return new ModelElementNode(node).getProxies();
            }
            if (this.canHaveDerivedAttr(node, property)) {
                for (IGraphEdge r : node.getOutgoingWithType(property)) {
                    if (ret == null) {
                        IGraphNode derivedNode = r.getEndNode();
                        ret = derivedNode.getProperty(property);
                        if (ret == null) {
                            EolSequence derivedTargets = new EolSequence();
                            for (IGraphEdge edge : derivedNode.getOutgoingWithType("de" + property)) {
                                derivedTargets.add(this.model.wrap(edge.getEndNode()));
                                ret = derivedTargets;
                            }
                        }
                        ret = this.retainScoped(ret);
                        continue;
                    }
                    throw new EolRuntimeException("WARNING: a derived property (arity 1) -- ( " + property + " ) has more than 1 links in store!");
                }
                if (ret == null) {
                    throw new EolRuntimeException("derived attribute lookup failed for: " + object + " # " + property);
                }
                if (ret instanceof String && ((String)ret).startsWith("_NYD##")) {
                    System.err.println("attribute: " + property + " is NYD for node: " + node.getId());
                }
            } else if (this.canHaveMixed(node, property)) {
                ret = this.getCollectionForProperty(property);
                Collection retCollection = (Collection)ret;
                if (node.getProperty(property) != null) {
                    List values = new Utils().asList(node.getProperty(property));
                    retCollection.addAll(values);
                }
                for (IGraphEdge r : node.getOutgoingWithType(property)) {
                    EOLQueryEngine.GraphNodeWrapper o = this.wrapIfInScope(r.getEndNode());
                    if (o == null) continue;
                    retCollection.add(o);
                }
            } else if (this.canHaveAttr(node, property)) {
                if (node.getProperty(property) != null) {
                    if (!this.isMany(property)) {
                        ret = node.getProperty(property);
                    } else {
                        ret = this.getCollectionForProperty(property);
                        Object[] array = (Object[])node.getProperty(property);
                        int i = 0;
                        while (i < array.length) {
                            ((Collection)ret).add(array[i]);
                            ++i;
                        }
                    }
                } else {
                    ret = null;
                }
            } else if (this.canHaveRef(node, property)) {
                EOLQueryEngine.GraphNodeWrapper otherNode = null;
                Collection<Object> otherNodes = null;
                if (this.isMany(property)) {
                    otherNodes = this.getCollectionForProperty(property);
                }
                for (IGraphEdge r : node.getOutgoingWithType(property)) {
                    IGraphNode n = r.getEndNode();
                    EOLQueryEngine.GraphNodeWrapper o = this.wrapIfInScope(n);
                    if (otherNodes != null) {
                        if (o == null) continue;
                        otherNodes.add(o);
                        continue;
                    }
                    if (otherNode == null) {
                        otherNode = o;
                        continue;
                    }
                    throw new EolRuntimeException("A relationship with arity 1 ( " + property + " ) has more than 1 links");
                }
                ret = otherNodes != null ? otherNodes : otherNode;
            } else {
                throw new EolIllegalPropertyException(object, property, null);
            }
        }
        if (this.broadcastAccess) {
            this.broadcastAccess(object, property);
        }
        return ret;
    }

    private List<EOLQueryEngine.GraphNodeWrapper> addAllContents(IGraphNode node, List<EOLQueryEngine.GraphNodeWrapper> results) {
        for (EOLQueryEngine.GraphNodeWrapper child : this.getContents(node)) {
            results.add(child);
            this.addAllContents(child.getNode(), results);
        }
        return results;
    }

    private List<EOLQueryEngine.GraphNodeWrapper> getContents(IGraphNode node) {
        ArrayList<EOLQueryEngine.GraphNodeWrapper> results = new ArrayList<EOLQueryEngine.GraphNodeWrapper>();
        Iterable out = node.getOutgoing();
        for (IGraphEdge r : out) {
            EOLQueryEngine.GraphNodeWrapper endNode;
            if (r.getProperty("isContainment") == null || (endNode = this.wrapIfInScope(r.getEndNode())) == null) continue;
            results.add(endNode);
        }
        return results;
    }

    private Object retainScoped(Object ret) {
        Collection cRet = null;
        if (ret instanceof Collection) {
            cRet = (Collection)ret;
        }
        if (cRet == null) {
            if (ret instanceof EOLQueryEngine.GraphNodeWrapper) {
                ret = this.retainScoped((EOLQueryEngine.GraphNodeWrapper)ret);
            }
        } else {
            Iterator it = cRet.iterator();
            while (it.hasNext()) {
                Object r = it.next();
                if (!(r instanceof EOLQueryEngine.GraphNodeWrapper) || this.retainScoped((EOLQueryEngine.GraphNodeWrapper)r) != null) continue;
                it.remove();
            }
        }
        return cRet == null ? ret : cRet;
    }

    private Object retainScoped(EOLQueryEngine.GraphNodeWrapper ret) {
        if (!this.engine.isTraversalScopingEnabled()) {
            return ret;
        }
        for (IGraphEdge e : this.graph.getNodeById((Object)ret.getId()).getOutgoingWithType("_hawkFile")) {
            if (!this.engine.getRawFileNodes().contains(e.getEndNode())) continue;
            return ret;
        }
        return null;
    }

    private EOLQueryEngine.GraphNodeWrapper wrapIfInScope(IGraphNode node) {
        if (!this.engine.isTraversalScopingEnabled()) {
            return this.model.wrap(node);
        }
        for (IGraphEdge e : node.getOutgoingWithType("_hawkFile")) {
            if (!this.engine.getRawFileNodes().contains(e.getEndNode())) continue;
            return this.model.wrap(node);
        }
        return null;
    }
}

