/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.execute.operations.EolOperationFactory;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributorRegistry;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphDatabase;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.contextful.AllOf;
import org.eclipse.hawk.epsilon.emc.contextful.TypeFirstAllOf;
import org.eclipse.hawk.epsilon.emc.pgetters.GraphPropertyGetter;
import org.eclipse.hawk.epsilon.emc.wrappers.FileNodeWrapper;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.ProxyReferenceList;
import org.eclipse.hawk.timeaware.graph.VCSManagerIndex;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLOperationFactory;
import org.eclipse.hawk.timeaware.queries.TimeAwareGraphPropertyGetter;
import org.eclipse.hawk.timeaware.queries.operations.reflective.TimeAwareNodeHistoryOperationContributor;
import org.eclipse.hawk.timeaware.queries.operations.reflective.TypeHistoryOperationContributor;
import org.eclipse.hawk.timeaware.queries.operations.scopes.IScopingTimeAwareGraphNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAwareEOLQueryEngine
extends EOLQueryEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeAwareEOLQueryEngine.class);
    private Function<IGraphNode, Iterable<? extends IGraphNode>> allFiles = new ContextlessTimeAwareAllFiles();
    private AllOf allOf = new ContextlessAllOf();

    public String getType() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    protected GraphPropertyGetter createContextlessPropertyGetter() {
        return new TimeAwareGraphPropertyGetter(this.graph, this);
    }

    public Collection<?> allInstancesAt(long timepoint) {
        HashSet<TimeAwareGraphNodeWrapper> allContents = new HashSet<TimeAwareGraphNodeWrapper>();
        ITimeAwareGraphDatabase taGraph = (ITimeAwareGraphDatabase)this.graph;
        for (IGraphNode node : taGraph.allNodes("eobject", timepoint)) {
            TimeAwareGraphNodeWrapper wrapper = new TimeAwareGraphNodeWrapper(node, this);
            allContents.add(wrapper);
        }
        return allContents;
    }

    public Collection<?> allInstancesAt(int timepoint) {
        return this.allInstancesAt((long)timepoint);
    }

    public Collection<?> allInstancesNow() {
        return this.allInstancesAt(System.currentTimeMillis());
    }

    public List<ProxyReferenceList> proxiesAt(String repositoryPrefix, long timepoint) throws Exception {
        HashSet<Object> visitedIDs = new HashSet<Object>();
        ArrayList<ProxyReferenceList> proxyReferenceLists = new ArrayList<ProxyReferenceList>();
        ITimeAwareGraphDatabase taGraph = (ITimeAwareGraphDatabase)this.graph;
        Throwable throwable = null;
        Object var8_8 = null;
        try (IGraphTransaction tx = this.graph.beginTransaction();){
            ITimeAwareGraphNodeIndex idxProxies = taGraph.getOrCreateNodeIndex("proxydictionary").travelInTime(timepoint);
            IGraphIterable proxies = idxProxies.query("hawkProxyRef:", (Object)(String.valueOf(repositoryPrefix) + "*"));
            for (IGraphNode n : proxies) {
                if (!visitedIDs.add(n.getId())) continue;
                ModelElementNode men = new ModelElementNode(n);
                proxyReferenceLists.addAll(men.getProxies());
            }
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return proxyReferenceLists;
    }

    public List<ProxyReferenceList> proxiesNow(String repositoryPrefix) throws Exception {
        return this.proxiesAt(repositoryPrefix, System.currentTimeMillis());
    }

    public List<ProxyReferenceList> proxiesNow() throws Exception {
        return this.proxiesNow("");
    }

    public Set<FileNodeWrapper> getFilesAt(long timepoint) {
        ITimeAwareGraphDatabase taGraph = (ITimeAwareGraphDatabase)this.graph;
        HashSet<FileNodeWrapper> allFNW = new HashSet<FileNodeWrapper>();
        for (IGraphNode n : taGraph.allNodes("file", timepoint)) {
            allFNW.add(new FileNodeWrapper(new FileNode(n), (EOLQueryEngine)this));
        }
        return allFNW;
    }

    public Set<FileNodeWrapper> getFilesNow() {
        return this.getFilesAt(System.currentTimeMillis());
    }

    public Object query(IModelIndexer m, String query, Map<String, Object> context) throws InvalidQueryException, QueryExecutionException {
        IStateListener.HawkState currentState = m.getCompositeStateListener().getCurrentState();
        if (currentState != IStateListener.HawkState.RUNNING) {
            throw new QueryExecutionException(String.format("Cannot run the query, as the indexer is not in the RUNNING state: it is %s instead.", currentState));
        }
        if (!(m.getGraph() instanceof ITimeAwareGraphDatabase)) {
            throw new QueryExecutionException(String.valueOf(((Object)((Object)this)).getClass().getName()) + " can only be used with time-aware backends");
        }
        String defaultnamespaces = null;
        if (context != null) {
            defaultnamespaces = (String)context.get("DEFAULTNAMESPACES");
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (TimeAwareEOLQueryEngine q = new TimeAwareEOLQueryEngine();){
                q.load(m);
                q.setDefaultNamespaces(defaultnamespaces);
                if (context != null && !context.isEmpty()) {
                    q.setContext(context);
                }
                IEolModule module = this.createModule();
                module.getContext().setOperationFactory((EolOperationFactory)new TimeAwareEOLOperationFactory(q));
                OperationContributorRegistry opcRegistry = module.getContext().getOperationContributorRegistry();
                opcRegistry.add((OperationContributor)new TimeAwareNodeHistoryOperationContributor(q));
                opcRegistry.add((OperationContributor)new TypeHistoryOperationContributor(q));
                this.parseQuery(query, context, q, module);
                return q.runQuery(module);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EolModelLoadingException e) {
            throw new QueryExecutionException("Loading of EOLQueryEngine failed");
        }
    }

    public String getHumanReadableName() {
        return "Time Aware " + super.getHumanReadableName();
    }

    public Collection<Object> getAllOf(IGraphNode typeNode, String typeorkind) {
        Collection nodes = this.createAllOfCollection(typeNode);
        this.allOf.addAllOf(typeNode, typeorkind, nodes);
        return nodes;
    }

    public Set<FileNodeWrapper> getFiles() {
        HashSet<FileNodeWrapper> allFNW = new HashSet<FileNodeWrapper>();
        for (IGraphNode iGraphNode : this.allFiles.apply(null)) {
            allFNW.add(new FileNodeWrapper(new FileNode(iGraphNode), (EOLQueryEngine)this));
        }
        return allFNW;
    }

    public ITimeAwareGraphDatabase getBackend() {
        return (ITimeAwareGraphDatabase)super.getBackend();
    }

    public VCSManagerIndex.RepositoryNode getRepository(Object oInstanceNode) throws Exception {
        EOLQueryEngine.GraphNodeWrapper gnw;
        if (oInstanceNode instanceof EOLQueryEngine.GraphNodeWrapper && (gnw = (EOLQueryEngine.GraphNodeWrapper)oInstanceNode).getNode() instanceof ITimeAwareGraphNode) {
            ITimeAwareGraphNode taNode = (ITimeAwareGraphNode)gnw.getNode();
            ModelElementNode me = new ModelElementNode((IGraphNode)taNode);
            String repoURL = me.getFileNode().getRepositoryURL();
            ITimeAwareGraphDatabase taGraph = (ITimeAwareGraphDatabase)this.graph;
            VCSManagerIndex.RepositoryNode repoNode = new VCSManagerIndex(taGraph).getOrCreateRepositoryNode(repoURL);
            return repoNode.travelInTime(taNode.getTime());
        }
        return null;
    }

    private void setAllFiles(Function<IGraphNode, Iterable<? extends IGraphNode>> allFiles) {
        this.allFiles = allFiles;
    }

    private void setAllOf(AllOf allOf) {
        this.allOf = allOf;
    }

    private void setContext(Map<String, Object> context) {
        if (context.containsKey("FILE") || context.containsKey("REPOSITORY")) {
            String sFilePatterns = (String)context.get("FILE");
            String[] filePatterns = sFilePatterns != null && sFilePatterns.trim().length() != 0 ? sFilePatterns.split(",") : null;
            List<String> fplist = filePatterns != null ? Arrays.asList(filePatterns) : null;
            String sRepoPatterns = (String)context.get("REPOSITORY");
            String[] repoPatterns = sRepoPatterns != null && sRepoPatterns.trim().length() != 0 ? sRepoPatterns.split(",") : null;
            List<String> rplist = repoPatterns != null ? Arrays.asList(repoPatterns) : null;
            GlobPatternTimeAwareAllFiles innerAllFiles = new GlobPatternTimeAwareAllFiles(rplist, fplist);
            this.setAllFiles(innerAllFiles);
            this.setAllOf((AllOf)new TypeFirstAllOf((Function)innerAllFiles, (EOLQueryEngine)this));
        }
    }

    public EOLQueryEngine.GraphNodeWrapper wrap(IGraphNode node) {
        if (node instanceof IScopingTimeAwareGraphNode) {
            return new StrongGraphNodeWrapper(node, this);
        }
        return new TimeAwareGraphNodeWrapper(node, this);
    }

    protected class ContextlessAllOf
    implements AllOf {
        protected ContextlessAllOf() {
        }

        public void addAllOf(IGraphNode typeNode, String typeorkind, Collection<Object> nodes) {
            for (IGraphEdge n : typeNode.getIncomingWithType(typeorkind)) {
                nodes.add((Object)new TimeAwareGraphNodeWrapper(n.getStartNode(), TimeAwareEOLQueryEngine.this));
            }
            TimeAwareEOLQueryEngine.this.broadcastAllOfXAccess(nodes);
        }
    }

    protected class ContextlessTimeAwareAllFiles
    implements Function<IGraphNode, Iterable<? extends IGraphNode>> {
        protected ContextlessTimeAwareAllFiles() {
        }

        @Override
        public Iterable<? extends ITimeAwareGraphNode> apply(IGraphNode sourceNode) {
            ITimeAwareGraphDatabase taGraph = (ITimeAwareGraphDatabase)TimeAwareEOLQueryEngine.this.graph;
            if (sourceNode == null) {
                return taGraph.allNodes("file");
            }
            ITimeAwareGraphNode taNode = (ITimeAwareGraphNode)sourceNode;
            return taGraph.allNodes("file", taNode.getTime());
        }
    }

    protected class GlobPatternTimeAwareAllFiles
    implements Function<IGraphNode, Iterable<? extends IGraphNode>> {
        private final List<String> rplist;
        private final List<String> fplist;

        protected GlobPatternTimeAwareAllFiles(List<String> rplist, List<String> fplist) {
            this.rplist = rplist;
            this.fplist = fplist;
        }

        @Override
        public Iterable<? extends ITimeAwareGraphNode> apply(IGraphNode sourceNode) {
            ITimeAwareGraphNode taNode = (ITimeAwareGraphNode)sourceNode;
            ITimeAwareGraphDatabase tadb = (ITimeAwareGraphDatabase)TimeAwareEOLQueryEngine.this.graph;
            GraphWrapper gw = new GraphWrapper((IGraphDatabase)tadb);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (IGraphTransaction tx = tadb.beginTransaction();){
                    Set fileNodes;
                    if (sourceNode == null) {
                        fileNodes = gw.getFileNodes(this.rplist, this.fplist);
                    } else {
                        ITimeAwareGraphNodeIndex fileIndex = tadb.getFileIndex().travelInTime(taNode.getTime());
                        fileNodes = gw.getFileNodes((IGraphNodeIndex)fileIndex, this.rplist, this.fplist);
                    }
                    HashSet<ITimeAwareGraphNode> rawFileNodes = new HashSet<ITimeAwareGraphNode>();
                    for (FileNode fn : fileNodes) {
                        rawFileNodes.add((ITimeAwareGraphNode)fn.getNode());
                    }
                    tx.success();
                    return rawFileNodes;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to find matching files", (Throwable)e);
                return Collections.emptySet();
            }
        }
    }

    public class StrongGraphNodeWrapper
    extends EOLQueryEngine.GraphNodeWrapper {
        private IGraphNode node;

        protected StrongGraphNodeWrapper(IGraphNode n, EOLQueryEngine containerModel) {
            super((EOLQueryEngine)TimeAwareEOLQueryEngine.this, n, containerModel);
            this.node = n;
        }

        public IGraphNode getNode() {
            return this.node;
        }
    }

    public class TimeAwareGraphNodeWrapper
    extends EOLQueryEngine.GraphNodeWrapper {
        private long time;

        protected TimeAwareGraphNodeWrapper(IGraphNode n, TimeAwareEOLQueryEngine containerModel) {
            super((EOLQueryEngine)TimeAwareEOLQueryEngine.this, n, (EOLQueryEngine)containerModel);
            this.time = ((ITimeAwareGraphNode)n).getTime();
        }

        public IGraphNode getNode() {
            IGraphNode ret = (IGraphNode)this.node.get();
            if (ret == null) {
                TimeAwareEOLQueryEngine taQuery = (TimeAwareEOLQueryEngine)this.containerModel;
                ret = taQuery.getBackend().getNodeById((Object)this.id).travelInTime(this.time);
                this.node = new WeakReference<IGraphNode>(ret);
            }
            return ret;
        }
    }
}

