/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.emf.dt.editors;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import org.apache.http.auth.Credentials;
import org.apache.thrift.transport.TTransportException;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.api.dt.http.LazyCredentials;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.emf.HawkModelDescriptor;
import org.eclipse.hawk.service.emf.dt.Activator;
import org.eclipse.hawk.service.emf.dt.editors.DetailsFormPage;
import org.eclipse.hawk.service.emf.dt.editors.EffectiveMetamodelFormPage;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class HawkMultiPageEditor
extends FormEditor
implements IResourceChangeListener {
    private DetailsFormPage detailsPage;
    private EffectiveMetamodelFormPage emmPage;
    private TextEditor textEditor;
    private int textEditorPageIndex;
    private boolean isDirty;

    public HawkMultiPageEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getActivePage() != this.textEditorPageIndex) {
            this.refreshRawText();
        }
        this.textEditor.doSave(monitor);
        if (this.getActivePage() == this.textEditorPageIndex) {
            this.refreshForm();
        }
        this.setDirty(false);
    }

    public void doSaveAs() {
        this.refreshRawText();
        this.textEditor.doSaveAs();
        this.setPageText(this.textEditorPageIndex, this.textEditor.getTitle());
        this.setInput(this.textEditor.getEditorInput());
        this.setDirty(false);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = HawkMultiPageEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)HawkMultiPageEditor.this.textEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(HawkMultiPageEditor.this.textEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    private void createFormBasedEditorPage() throws PartInitException {
        this.detailsPage = new DetailsFormPage(this, "details", "Descriptor");
        int index = this.addPage((IEditorPart)this.detailsPage, this.getEditorInput());
        this.setPageText(index, this.detailsPage.getTitle());
    }

    private void createEffectiveMetamodelPage() throws PartInitException {
        this.emmPage = new EffectiveMetamodelFormPage(this, "emm", "Effective Metamodel");
        int index = this.addPage((IFormPage)this.emmPage);
        this.setPageText(index, this.emmPage.getTitle());
    }

    private void createRawTextEditorPage() throws PartInitException {
        this.textEditor = new TextEditor();
        this.textEditorPageIndex = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
        this.setPageText(this.textEditorPageIndex, this.textEditor.getTitle());
        this.setPartName(this.textEditor.getTitle());
    }

    private IDocument getDocument() {
        return this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
    }

    private void refreshForm() {
        IDocument doc = this.getDocument();
        String sContents = doc.get();
        HawkModelDescriptor descriptor = new HawkModelDescriptor();
        try {
            descriptor.load((Reader)new StringReader(sContents));
            this.detailsPage.getInstanceSection().setServerURL(descriptor.getHawkURL());
            this.detailsPage.getInstanceSection().setInstanceName(descriptor.getHawkInstance());
            this.detailsPage.getInstanceSection().setThriftProtocol(descriptor.getThriftProtocol());
            this.detailsPage.getInstanceSection().setUsername(descriptor.getUsername());
            this.detailsPage.getInstanceSection().setPassword(descriptor.getPassword());
            this.detailsPage.getContentSection().setRepositoryURL(descriptor.getHawkRepository());
            this.detailsPage.getContentSection().setFilePatterns(descriptor.getHawkFilePatterns());
            this.detailsPage.getContentSection().setLoadingMode(descriptor.getLoadingMode());
            this.detailsPage.getContentSection().setQueryLanguage(descriptor.getHawkQueryLanguage());
            this.detailsPage.getContentSection().setQuery(descriptor.getHawkQuery());
            this.detailsPage.getContentSection().setDefaultNamespaces(descriptor.getDefaultNamespaces());
            this.detailsPage.getContentSection().setSplit(descriptor.isSplit());
            this.detailsPage.getContentSection().setPageSize(descriptor.getPageSize());
            this.detailsPage.getSubscriptionSection().setSubscribed(descriptor.isSubscribed());
            this.detailsPage.getSubscriptionSection().setClientID(descriptor.getSubscriptionClientID());
            this.detailsPage.getSubscriptionSection().setDurability(descriptor.getSubscriptionDurability());
            this.emmPage.setEffectiveMetamodel(descriptor.getEffectiveMetamodel());
        }
        catch (IOException e) {
            Activator.getDefault().logError(e);
        }
    }

    private void refreshRawText() {
        HawkModelDescriptor descriptor = this.buildDescriptor();
        StringWriter sW = new StringWriter();
        try {
            descriptor.save((Writer)sW);
            IDocument doc = this.getDocument();
            doc.set(sW.toString());
        }
        catch (IOException e) {
            Activator.getDefault().logError(e);
        }
    }

    protected HawkModelDescriptor buildDescriptor() {
        HawkModelDescriptor descriptor = new HawkModelDescriptor();
        descriptor.setHawkURL(this.detailsPage.getInstanceSection().getServerURL());
        descriptor.setHawkInstance(this.detailsPage.getInstanceSection().getInstanceName());
        descriptor.setThriftProtocol(this.detailsPage.getInstanceSection().getThriftProtocol());
        descriptor.setUsername(this.detailsPage.getInstanceSection().getUsername());
        descriptor.setPassword(this.detailsPage.getInstanceSection().getPassword());
        descriptor.setHawkRepository(this.detailsPage.getContentSection().getRepositoryURL());
        descriptor.setHawkFilePatterns(this.detailsPage.getContentSection().getFilePatterns());
        descriptor.setLoadingMode(this.detailsPage.getContentSection().getLoadingMode());
        descriptor.setSubscribed(this.detailsPage.getSubscriptionSection().isSubscribed());
        descriptor.setSubscriptionClientID(this.detailsPage.getSubscriptionSection().getClientID());
        descriptor.setSubscriptionDurability(this.detailsPage.getSubscriptionSection().getDurability());
        descriptor.setHawkQueryLanguage(this.detailsPage.getContentSection().getQueryLanguage());
        descriptor.setHawkQuery(this.detailsPage.getContentSection().getQuery());
        descriptor.setDefaultNamespaces(this.detailsPage.getContentSection().getDefaultNamespaces());
        descriptor.setSplit(this.detailsPage.getContentSection().isSplit());
        descriptor.setPageSize(this.detailsPage.getContentSection().getPageSize());
        descriptor.setEffectiveMetamodel(this.emmPage.getEffectiveMetamodel());
        return descriptor;
    }

    protected void pageChange(int newPageIndex) {
        int oldPageIndex = this.getCurrentPage();
        super.pageChange(newPageIndex);
        if (this.isDirty()) {
            if (newPageIndex == this.textEditorPageIndex) {
                this.refreshRawText();
            } else if (oldPageIndex == this.textEditorPageIndex) {
                this.refreshForm();
            }
        }
    }

    protected void addPages() {
        try {
            this.createFormBasedEditorPage();
            this.createEffectiveMetamodelPage();
            this.createRawTextEditorPage();
            this.refreshForm();
        }
        catch (Exception ex) {
            Activator.getDefault().logError(ex);
        }
    }

    protected Hawk.Client connectToHawk(HawkModelDescriptor d) throws TTransportException, URISyntaxException {
        return (Hawk.Client)APIUtils.connectTo(Hawk.Client.class, (String)d.getHawkURL(), (APIUtils.ThriftProtocol)d.getThriftProtocol(), (Credentials)new LazyCredentials(d.getHawkURL()));
    }

    public boolean isDirty() {
        return super.isDirty() || this.isDirty;
    }

    protected void setDirty(boolean newValue) {
        if (this.isDirty != newValue) {
            this.isDirty = newValue;
            this.firePropertyChange(257);
        }
    }
}

