/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.query;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.hawk.core.IHawkPlugin;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.query.IAccessListener;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;

public interface IQueryEngine
extends IHawkPlugin {
    public static final String PROPERTY_FILEFIRST = "FILEFIRST";
    public static final String PROPERTY_SUBTREECONTEXT = "SUBTREE";
    public static final String PROPERTY_SUBTREE_DERIVEDALLOF = "SUBTREE_DERIVEDALLOF";
    public static final String PROPERTY_FILECONTEXT = "FILE";
    public static final String PROPERTY_REPOSITORYCONTEXT = "REPOSITORY";
    public static final String PROPERTY_DEFAULTNAMESPACES = "DEFAULTNAMESPACES";
    public static final String PROPERTY_ENABLE_TRAVERSAL_SCOPING = "ENABLE_TRAVERSAL_SCOPING";
    public static final String PROPERTY_ARGUMENTS = "ARGUMENTS";
    public static final String PROPERTY_CANCEL_CONSUMER = "EXEC_CANCEL_CONSUMER";

    public IAccessListener calculateDerivedAttributes(IModelIndexer var1, Iterable<IGraphNode> var2) throws InvalidQueryException, QueryExecutionException;

    public List<String> validate(String var1);

    public void setDefaultNamespaces(String var1);

    public Object query(IModelIndexer var1, String var2, Map<String, Object> var3) throws InvalidQueryException, QueryExecutionException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public Object query(IModelIndexer m, File query, Map<String, Object> context) throws InvalidQueryException, QueryExecutionException {
        StringBuilder code = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                FileReader fR = new FileReader(query);
                try {
                    try (BufferedReader r = new BufferedReader(fR);){
                        String line;
                        while ((line = r.readLine()) != null) {
                            code.append((CharSequence)code);
                            code.append("\r\n");
                            code.append(line);
                        }
                        r.close();
                    }
                    if (fR == null) return this.query(m, code.toString(), context);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fR == null) throw throwable;
                    fR.close();
                    throw throwable;
                }
                fR.close();
                return this.query(m, code.toString(), context);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new QueryExecutionException(e);
        }
    }

    @Override
    default public IHawkPlugin.Category getCategory() {
        return IHawkPlugin.Category.QUERY_ENGINE;
    }
}

