/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;

public class CollectNodesVisitor<T extends Visitable>
implements Visitor {
    private final List<T> nodeList = new ArrayList<T>();
    private final Class<T> nodeClass;
    private final Class<? extends Visitable> skipOverClass;

    public CollectNodesVisitor(Class<T> clazz) {
        this(clazz, null);
    }

    public CollectNodesVisitor(Class<T> clazz, Class<? extends Visitable> clazz2) {
        this.nodeClass = clazz;
        this.skipOverClass = clazz2;
    }

    @Override
    public boolean visitChildrenFirst(Visitable visitable) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public Visitable visit(Visitable visitable) {
        if (this.nodeClass.isInstance(visitable)) {
            this.nodeList.add(this.nodeClass.cast(visitable));
        }
        return visitable;
    }

    @Override
    public boolean skipChildren(Visitable visitable) {
        return this.skipOverClass == null ? false : this.skipOverClass.isInstance(visitable);
    }

    public List<T> getList() {
        return this.nodeList;
    }
}

