/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtilBase;
import org.apache.tomcat.util.net.jsse.JSSEUtil;
import org.apache.tomcat.util.net.openssl.OpenSSLContext;
import org.apache.tomcat.util.net.openssl.OpenSSLEngine;
import org.apache.tomcat.util.net.openssl.OpenSSLKeyManager;

public class OpenSSLUtil
extends SSLUtilBase {
    private static final Log log = LogFactory.getLog(OpenSSLUtil.class);
    private final JSSEUtil jsseUtil;

    public OpenSSLUtil(SSLHostConfigCertificate certificate) {
        super(certificate);
        this.jsseUtil = certificate.getCertificateFile() == null ? new JSSEUtil(certificate, false) : null;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Set<String> getImplementedProtocols() {
        return OpenSSLEngine.IMPLEMENTED_PROTOCOLS_SET;
    }

    @Override
    protected Set<String> getImplementedCiphers() {
        return OpenSSLEngine.AVAILABLE_CIPHER_SUITES;
    }

    @Override
    protected boolean isTls13Available() {
        return SSL.version() >= 0x1010100F;
    }

    @Override
    protected boolean isTls13RenegAuthAvailable() {
        return true;
    }

    @Override
    public SSLContext createSSLContext(List<String> negotiableProtocols) throws Exception {
        return new OpenSSLContext(this.certificate, negotiableProtocols);
    }

    @Override
    public KeyManager[] getKeyManagers() throws Exception {
        if (this.jsseUtil != null) {
            return this.jsseUtil.getKeyManagers();
        }
        KeyManager[] managers = new KeyManager[]{new OpenSSLKeyManager(SSLHostConfig.adjustRelativePath(this.certificate.getCertificateFile()), SSLHostConfig.adjustRelativePath(this.certificate.getCertificateKeyFile()))};
        return managers;
    }

    @Override
    public TrustManager[] getTrustManagers() throws Exception {
        if (this.jsseUtil != null) {
            return this.jsseUtil.getTrustManagers();
        }
        return null;
    }

    @Override
    public void configureSessionContext(SSLSessionContext sslSessionContext) {
        if (this.jsseUtil != null) {
            this.jsseUtil.configureSessionContext(sslSessionContext);
        }
    }
}

