/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.mock;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.osgi.framework.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockFrameworkUtil {
    private static final String EQUINOX_CLS = "org.eclipse.osgi.framework.internal.core.FilterImpl";
    private static final String KF_CLS = "org.knopflerfish.framework.FilterImpl";
    private static final String FELIX_CLS = "org.apache.felix.framework.FilterImpl";
    private final Constructor filterConstructor;

    MockFrameworkUtil() {
        ClassLoader cl = this.getClass().getClassLoader();
        Class<?> filterClz = null;
        filterClz = this.loadClass(cl, EQUINOX_CLS);
        if (filterClz == null) {
            filterClz = this.loadClass(cl, KF_CLS);
        }
        if (filterClz == null) {
            filterClz = this.loadClass(cl, FELIX_CLS);
        }
        if (filterClz == null) {
            throw new IllegalStateException("cannot find Equinox, Knopflerfish or Felix on the classpath");
        }
        try {
            this.filterConstructor = filterClz.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("found invalid filter class " + filterClz);
        }
    }

    private Class<?> loadClass(ClassLoader loader, String className) {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Filter createFilter(String filter) {
        try {
            return (Filter)this.filterConstructor.newInstance(filter);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

