/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.IdentifiableReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.models.IReflectiveModel;

public class ModelElementReference
extends IdentifiableReference<Object> {
    private static final Logger LOGGER = Logger.getLogger(ModelElementReference.class.getCanonicalName());
    private final String name;
    private final IReflectiveModel model;

    public ModelElementReference(IEolContext context, IReflectiveModel rModel, String name, Object value) {
        super(context, value);
        this.model = rModel;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeName() {
        return this.model.getTypeNameOf(this.target);
    }

    @Override
    public List<IVariableReference> getVariables(SuspendedState state) {
        ArrayList<IVariableReference> refs = new ArrayList<IVariableReference>();
        try {
            for (String propName : this.model.getPropertiesOf(this.model.getTypeNameOf(this.target))) {
                Object propValue;
                try {
                    propValue = this.model.getPropertyGetter().invoke(this.target, propName, this.context);
                }
                catch (EolRuntimeException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    propValue = "<error obtaining value>";
                }
                refs.add(state.getValueReference(this.context, propName, propValue));
            }
        }
        catch (EolModelElementTypeNotFoundException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return refs;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.model, this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelElementReference other = (ModelElementReference)obj;
        return Objects.equals(this.model, other.model) && Objects.equals(this.name, other.name);
    }
}

